/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.storedprocess.DataItemPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

class DataSourcesAndTargetsPanel
extends WAPanel
implements LayoutConstants,
ListSelectionListener {
    private JTable _table;
    private DataTableModel _tableModel;
    private DataTableModel _otherModel;
    private JScrollPane _scrollPane;
    private JButton _buttonNew;
    private JButton _buttonEdit;
    private JButton _buttonDelete;
    private JButton _buttonUp;
    private JButton _buttonDown;
    private MetadataManipulator _metadataManipulator;
    private boolean _sources;
    private double _usageVersion;
    private boolean _isNineTwo;

    public DataSourcesAndTargetsPanel(MetadataManipulator metadataManipulator, boolean sources, double usageVersion) {
        this._metadataManipulator = metadataManipulator;
        this._sources = sources;
        this._usageVersion = usageVersion;
        this._isNineTwo = usageVersion == ObjectFactory.NINETWO_VERSION.encode();
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        layout.setRemainderColumn(1);
        this.setLayout((LayoutManager)layout);
        this._tableModel = new DataTableModel();
        this._table = new JTable(this._tableModel);
        this._table.setDefaultRenderer(Object.class, (TableCellRenderer)new UtilGui.NoHtmlTableCellRenderer());
        this._table.setToolTipText(RB.getStringResource("COM.Table.Tooltip.txt"));
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setSelectionMode(0);
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.setPreferredSize(new Dimension(450, 200));
        this._buttonNew = UtilGui.createButton((String)RB.getStringResource("COM.Btn.New0.txt"));
        this._buttonNew.setEnabled(true);
        this._buttonEdit = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Mod1.txt"));
        this._buttonEdit.setEnabled(false);
        this._buttonDelete = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Del1.txt"));
        this._buttonDelete.setEnabled(false);
        this._buttonUp = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Up1.txt"));
        this._buttonUp.setEnabled(false);
        this._buttonDown = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Dwn1.txt"));
        this._buttonDown.setEnabled(false);
        JPanel buttonsPanel = new JPanel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(6, 1, 5, 5, false, true, true);
        buttonsPanel.setLayout((LayoutManager)buttonLayout);
        buttonLayout.setRemainderRow(4);
        buttonsPanel.add(this._buttonNew);
        buttonsPanel.add(this._buttonEdit);
        buttonsPanel.add(this._buttonDelete);
        buttonsPanel.add(new JPanel());
        buttonsPanel.add(this._buttonUp);
        buttonsPanel.add(this._buttonDown);
        this.add(this._scrollPane);
        this.add(buttonsPanel);
        this.createListeners();
    }

    private void createListeners() {
        this._buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selected = DataSourcesAndTargetsPanel.this._table.getSelectedRow();
                DataItemPanel.DataItem di = DataSourcesAndTargetsPanel.this.doNew();
                if (di != null) {
                    DataSourcesAndTargetsPanel.this._tableModel.addTableEntry(di, selected);
                    DataSourcesAndTargetsPanel.this._tableModel.fireTableDataChanged();
                    DataSourcesAndTargetsPanel.this.setSelection(di);
                }
            }
        });
        this._buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DataItemPanel.DataItem di;
                int selected = DataSourcesAndTargetsPanel.this._table.getSelectedRow();
                if (selected != -1 && DataSourcesAndTargetsPanel.this.doEdit(di = DataSourcesAndTargetsPanel.this._tableModel.getTableEntryElementAt(selected))) {
                    DataSourcesAndTargetsPanel.this._tableModel.fireTableDataChanged();
                    DataSourcesAndTargetsPanel.this.setSelection(di);
                }
            }
        });
        this._buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DataItemPanel.DataItem di;
                int selected = DataSourcesAndTargetsPanel.this._table.getSelectedRow();
                if (selected != -1 && DataSourcesAndTargetsPanel.this.doDelete(di = DataSourcesAndTargetsPanel.this._tableModel.getTableEntryElementAt(selected))) {
                    DataSourcesAndTargetsPanel.this._tableModel.removeTableEntry(di);
                    DataSourcesAndTargetsPanel.this._tableModel.fireTableDataChanged();
                    DataSourcesAndTargetsPanel.this.setEnabledStateOfButtons();
                }
            }
        });
        this._buttonUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selected = DataSourcesAndTargetsPanel.this._table.getSelectedRow();
                if (selected != -1) {
                    DataSourcesAndTargetsPanel.this._tableModel.moveUp(selected);
                    DataSourcesAndTargetsPanel.this._tableModel.fireTableDataChanged();
                    DataSourcesAndTargetsPanel.this._table.changeSelection(selected - 1, 0, false, false);
                    DataSourcesAndTargetsPanel.this.setEnabledStateOfButtons();
                }
            }
        });
        this._buttonDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selected = DataSourcesAndTargetsPanel.this._table.getSelectedRow();
                if (selected != -1) {
                    DataSourcesAndTargetsPanel.this._tableModel.moveDown(selected);
                    DataSourcesAndTargetsPanel.this._tableModel.fireTableDataChanged();
                    DataSourcesAndTargetsPanel.this._table.changeSelection(selected + 1, 0, false, false);
                    DataSourcesAndTargetsPanel.this.setEnabledStateOfButtons();
                }
            }
        });
    }

    private DataItemPanel.DataItem doNew() {
        ArrayList<String> listOfExistingFilerefNames = new ArrayList<String>();
        ArrayList<String> listOfExistingTableNames = new ArrayList<String>();
        this._tableModel.addToListsOfExistingNames(listOfExistingFilerefNames, listOfExistingTableNames);
        this._otherModel.addToListsOfExistingNames(listOfExistingFilerefNames, null);
        DataItemPanel.DataItem dataItem = new DataItemPanel.DataItem();
        DataItemPanel panel = new DataItemPanel(dataItem, 1, listOfExistingFilerefNames, listOfExistingTableNames, this._sources, this._usageVersion);
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), null, (String)RB.getStringResource(this._sources ? "DSTP.NewSrc.DlgTitle.txt" : "DSTP.NewTrg.DlgTitle.txt"), (MetadataDialogPanel)panel);
        int retVal = dialog.doModal();
        if (retVal == 1) {
            return dataItem;
        }
        return null;
    }

    protected boolean doEdit(DataItemPanel.DataItem dataItem) {
        ArrayList<String> listOfExistingFilerefNames = new ArrayList<String>();
        ArrayList<String> listOfExistingTableNames = new ArrayList<String>();
        this._tableModel.addToListsOfExistingNames(listOfExistingFilerefNames, listOfExistingTableNames);
        this._otherModel.addToListsOfExistingNames(listOfExistingFilerefNames, null);
        DataItemPanel panel = new DataItemPanel(dataItem, 2, listOfExistingFilerefNames, listOfExistingTableNames, this._sources, this._usageVersion);
        String titleRes = this._sources ? (this.isEditable() ? "DSTP.ModSrc.DlgTitle.txt" : "DSTP.ViewSrc.DlgTitle.txt") : (this.isEditable() ? "DSTP.ModTrg.DlgTitle.txt" : "DSTP.ViewTrg.DlgTitle.txt");
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), null, (String)RB.getStringResource(titleRes), (MetadataDialogPanel)panel);
        dialog.setEditable(this.isEditable());
        int retVal = dialog.doModal();
        return retVal == 1;
    }

    private boolean doDelete(DataItemPanel.DataItem di) {
        String msg = di._type.equals("DataTable") ? Message.format((ResourceBundle)RB.getResources(), (String)"DSTP.ConfDelTab.msg.fmt.txt", (Object)di._tableParmName) : Message.format((ResourceBundle)RB.getResources(), (String)(this._sources ? "DSTP.ConfDelSrc.msg.fmt.txt" : "DSTP.ConfDelTrg.msg.fmt.txt"), (Object)di._fileref);
        return MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("COM.ConfDel.DlgTitle.txt"), (int)3, (int)0) == 0;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabledStateOfButtons();
    }

    protected void setSelection(DataItemPanel.DataItem di) {
        int row = this._tableModel.locateRowFor(di);
        if (row != -1) {
            this._table.changeSelection(row, 0, false, false);
        }
    }

    void setEnabledStateOfButtons() {
        boolean editingPermitted = this.isEditable();
        if (this._usageVersion == ObjectFactory.NINETWO_VERSION.encode()) {
            this._buttonNew.setEnabled(editingPermitted && this._metadataManipulator._storedProcessServerSelected);
        } else {
            this._buttonNew.setEnabled(editingPermitted);
        }
        int selectedRow = this._table.getSelectedRow();
        boolean rowSelected = selectedRow >= 0;
        this._buttonEdit.setEnabled(rowSelected);
        this._buttonDelete.setEnabled(rowSelected && editingPermitted);
        int size = this._table.getRowCount();
        this._buttonUp.setEnabled(editingPermitted && selectedRow > 0);
        this._buttonDown.setEnabled(editingPermitted && selectedRow >= 0 && selectedRow < size - 1);
    }

    void setOtherModel(DataTableModel model) {
        this._otherModel = model;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        Util.configureMnemonicForButton((AbstractButton)this._buttonEdit, (String)RB.getStringResource(editable ? "COM.Btn.Mod1.txt" : "COM.Btn.View0.txt"));
        this.setEnabledStateOfButtons();
    }

    DataTableModel getModel() {
        return this._tableModel;
    }

    class DataTableModel
    extends AbstractTableModel {
        private ArrayList<DataItemPanel.DataItem> _data = new ArrayList();

        DataTableModel() {
        }

        void clear() {
            this._data.clear();
        }

        ArrayList<DataItemPanel.DataItem> getList() {
            return this._data;
        }

        void moveDown(int row) {
            DataItemPanel.DataItem di = this._data.get(row);
            this._data.remove(row);
            this._data.add(row + 1, di);
        }

        void moveUp(int row) {
            DataItemPanel.DataItem di = this._data.get(row);
            this._data.remove(row);
            this._data.add(row - 1, di);
        }

        private void addToListsOfExistingNames(List<String> filerefList, ArrayList<String> tableList) {
            int len = this._data.size();
            for (int i = 0; i < len; ++i) {
                DataItemPanel.DataItem di = this._data.get(i);
                if (di._type.equals("DataTable")) {
                    if (tableList == null) continue;
                    tableList.add(di._tableParmName);
                    continue;
                }
                filerefList.add(di._fileref);
            }
        }

        DataItemPanel.DataItem getTableEntryElementAt(int row) {
            return this._data.get(row);
        }

        void addTableEntry(DataItemPanel.DataItem di, int selected) {
            if (selected == -1) {
                this._data.add(di);
            } else {
                this._data.add(selected + 1, di);
            }
        }

        void removeTableEntry(DataItemPanel.DataItem di) {
            this._data.remove(di);
        }

        int locateRowFor(DataItemPanel.DataItem matchOP) {
            Iterator<DataItemPanel.DataItem> it = this._data.iterator();
            int i = 0;
            while (it.hasNext()) {
                DataItemPanel.DataItem di = it.next();
                if (di == matchOP) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return RB.getStringResource("COM.Hdr.Label.txt");
                }
                case 1: {
                    return RB.getStringResource("COM.Hdr.Type.txt");
                }
                case 2: {
                    return RB.getStringResource(DataSourcesAndTargetsPanel.this._isNineTwo ? "DSTP.Hdr.Fileref.txt" : "DSTP.Hdr.FilerefTable.txt");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            DataItemPanel.DataItem te = this._data.get(row);
            switch (col) {
                case 0: {
                    return te._label;
                }
                case 1: {
                    String type = te._type.equals("GenericStream") ? (DataSourcesAndTargetsPanel.this._isNineTwo ? RB.getStringResource("DIP.Typ.GenStr.txt") : RB.getStringResource(DataSourcesAndTargetsPanel.this._sources ? "DIP.Typ.GenDS.txt" : "DIP.Typ.GenDT.txt")) : (te._type.equals("XMLStream") ? (DataSourcesAndTargetsPanel.this._isNineTwo ? RB.getStringResource("DIP.Typ.XMLStr.txt") : RB.getStringResource(DataSourcesAndTargetsPanel.this._sources ? "DIP.Typ.XMLDS.txt" : "DIP.Typ.XMLDT.txt")) : (te._type.equals("DataTable") ? RB.getStringResource(DataSourcesAndTargetsPanel.this._sources ? "DIP.Typ.SrcDataTable.txt" : "DIP.Typ.TargDataTable.txt") : te._type));
                    return type;
                }
                case 2: {
                    if (te._type.equals("DataTable")) {
                        return te._tableParmName;
                    }
                    return te._fileref;
                }
            }
            return "";
        }
    }
}

