/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.storedprocess.CodeEditorDialog;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.TextStore;
import com.sas.workspace.MessageUtil;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.JComponent;

@SASScope
public class CodeEditorMetadataRepositoryDialog
extends CodeEditorDialog {
    private TextStore _textStore;

    static CodeEditorMetadataRepositoryDialog createInstance(JComponent caller) {
        Container topLevelAncestor = caller.getTopLevelAncestor();
        if (topLevelAncestor instanceof Dialog) {
            return new CodeEditorMetadataRepositoryDialog((Dialog)topLevelAncestor);
        }
        if (topLevelAncestor instanceof Frame) {
            return new CodeEditorMetadataRepositoryDialog((Frame)topLevelAncestor);
        }
        MessageUtil.displayMessage((String)("Unsupported container type : " + topLevelAncestor.getClass().getName()), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
        return null;
    }

    protected CodeEditorMetadataRepositoryDialog(Dialog dialog) {
        super(dialog);
    }

    protected CodeEditorMetadataRepositoryDialog(Frame frame) {
        super(frame);
    }

    public boolean initialize(TextStore textStore, boolean isEditable) throws RemoteException, MdException {
        this._textStore = textStore;
        return super.initialize(isEditable);
    }

    @Override
    protected String getSaveButtonString() {
        return RB.getStringResource("CEMRD.BtnOK.txt");
    }

    @Override
    protected boolean readAndSetText() {
        String fileInString;
        try {
            fileInString = this._textStore.getStoredText();
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
            return false;
        }
        this._codeEditor.setText(fileInString);
        this.setTitle(RB.getStringResource(this._isEditable ? "CEMRD.Title.txt" : "CEMRD.TitleV.txt"));
        return true;
    }

    @Override
    protected boolean save() {
        String fileInString = this._codeEditor.getText();
        try {
            fileInString = fileInString.replaceAll(" +$", "");
            this._textStore.setStoredText(fileInString);
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
            return false;
        }
        return true;
    }
}

