/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.storedprocess.CodeEditorDialog;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.StoredProcessImportListener;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WsAppServer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.rmi.RemoteException;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

@SASScope
public class CodeEditorFileSystemDialog
extends CodeEditorDialog {
    private ServerContext _serverContext;
    private String _sourceCodeRepository;
    private String _sourceFileName;
    private String _fullPath;

    static CodeEditorFileSystemDialog createInstance(JComponent caller) {
        Container topLevelAncestor = caller.getTopLevelAncestor();
        if (topLevelAncestor instanceof Dialog) {
            return new CodeEditorFileSystemDialog((Dialog)topLevelAncestor);
        }
        if (topLevelAncestor instanceof Frame) {
            return new CodeEditorFileSystemDialog((Frame)topLevelAncestor);
        }
        MessageUtil.displayMessage((String)("Unsupported container type : " + topLevelAncestor.getClass().getName()), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
        return null;
    }

    protected CodeEditorFileSystemDialog(Dialog dialog) {
        super(dialog);
    }

    protected CodeEditorFileSystemDialog(Frame frame) {
        super(frame);
    }

    public boolean initialize(Directory sourceCodeRepositoryDirectory, String sourceFileName, boolean isEditable) throws RemoteException, MdException {
        Iterator it = sourceCodeRepositoryDirectory.getDeployedComponents().iterator();
        if (!it.hasNext()) {
            throw new MdException("Missing ServerContext object.  One should be associated with the Directory \"" + sourceCodeRepositoryDirectory.getDirectoryName() + "\" with FQID " + sourceCodeRepositoryDirectory.getFQID());
        }
        this._serverContext = (ServerContext)it.next();
        this._sourceCodeRepository = sourceCodeRepositoryDirectory.getDirectoryName();
        this._sourceFileName = sourceFileName;
        return super.initialize(isEditable);
    }

    @Override
    protected int layoutTopRows(JPanel panel) {
        int row = 0;
        JLabel lblRepository = new JLabel(Util.getLabelWithoutMnemonic((String)RB.getStringResource("NETVC.Lbl.Repo.txt")));
        JLabel txtRepository = new JLabel(this._sourceCodeRepository);
        panel.add((Component)lblRepository, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, LayoutConstants.FIRST_INSETS_IN_ROW, 0, 0));
        panel.add((Component)txtRepository, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, LayoutConstants.NEXT_INSETS_IN_ROW, 0, 0));
        JLabel lblFile = new JLabel(Util.getLabelWithoutMnemonic((String)RB.getStringResource("NETVC.Lbl.FilNm.txt")));
        JLabel txtFile = new JLabel(this._sourceFileName);
        panel.add((Component)lblFile, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, LayoutConstants.FIRST_INSETS_IN_ROW, 0, 0));
        panel.add((Component)txtFile, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, LayoutConstants.NEXT_INSETS_IN_ROW, 0, 0));
        return ++row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean readAndSetText() {
        WsAppServer wsAppServer = WsAppServer.createAppServer((ServerContext)this._serverContext);
        if (wsAppServer == null) {
            try {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.cantCreatAppSrvr.fmt.txt"), (Object)this._serverContext.getName());
                UtilGui.displayError((String)msg);
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
            }
            return false;
        }
        try {
            boolean fileExists;
            try {
                fileExists = wsAppServer.doesFileExist(this._sourceCodeRepository);
            }
            catch (Exception e) {
                String msg2 = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.cantDetermineIfSCRExists.fmt.txt"), (Object)this._sourceCodeRepository, (Object)e.getLocalizedMessage());
                UtilGui.displayError((String)msg2);
                boolean bl = false;
                wsAppServer.dispose();
                return bl;
            }
            if (!fileExists) {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.SCRdoesntExist.fmt.txt"), (Object)this._sourceCodeRepository);
                UtilGui.displayError((String)msg);
                boolean msg2 = false;
                return msg2;
            }
            try {
                this._fullPath = wsAppServer.getFileFullPath(this._sourceCodeRepository, this._sourceFileName);
            }
            catch (Exception e) {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.cantComputeFileName.fmt.txt"), (Object)e.getLocalizedMessage());
                UtilGui.displayError((String)msg);
                boolean bl = false;
                wsAppServer.dispose();
                return bl;
            }
            try {
                fileExists = wsAppServer.doesFileExist(this._fullPath);
            }
            catch (Exception e) {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.cantDetermineIfFileExists.fmt.txt"), (Object)this._fullPath, (Object)e.getLocalizedMessage());
                UtilGui.displayError((String)msg);
                boolean bl = false;
                wsAppServer.dispose();
                return bl;
            }
            if (fileExists) {
                String fileInString;
                try {
                    fileInString = wsAppServer.readFile(this._fullPath);
                }
                catch (Exception e) {
                    String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.readError.fmt.txt"), (Object)this._fullPath, (Object)e.getLocalizedMessage());
                    UtilGui.displayError((String)msg);
                    boolean bl = false;
                    wsAppServer.dispose();
                    return bl;
                }
                this._codeEditor.setText(fileInString);
                this.setTitle(RB.getStringResource(this._isEditable ? "CEFSD.Title.txt" : "CEFSD.TitleV.txt"));
            } else {
                int ret = MessageUtil.displayMessage((String)UtilMisc.getMessage((String)RB.getStringResource("CEFSD.createFile.fmt.txt"), (Object)this._fullPath), (String)RB.getStringResource("CED.Title.txt"), (int)2, (int)0);
                if (ret == 1) {
                    boolean bl = false;
                    return bl;
                }
                this.setTitle(RB.getStringResource("CEFSD.TitleN.txt"));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            wsAppServer.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean save() {
        WsAppServer wsAppServer = WsAppServer.createAppServer((ServerContext)this._serverContext);
        if (wsAppServer == null) {
            try {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.cantCreatAppSrvr.fmt.txt"), (Object)this._serverContext.getName());
                UtilGui.displayError((String)msg);
            }
            catch (RemoteException e) {
                UtilGui.displayRemoteException((RemoteException)e);
            }
            return false;
        }
        String fileInString = this._codeEditor.getText();
        try {
            StoredProcessImportListener.writeFile(wsAppServer, fileInString, this._fullPath);
            this._document.markUndoStack();
            boolean e = true;
            return e;
        }
        catch (Exception e) {
            String text = e.getLocalizedMessage();
            if (text == null) {
                text = e.toString();
            }
            String msg = UtilMisc.getMessage((String)RB.getStringResource("CEFSD.writeError.fmt.txt"), (Object)this._fullPath, (Object)text);
            UtilGui.displayError((String)msg);
            boolean bl = false;
            return bl;
        }
        finally {
            wsAppServer.dispose();
        }
    }
}

