/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.editor.CodeEditor;
import com.sas.editor.CodeEditorDefaults;
import com.sas.editor.CodeEditorDocument;
import com.sas.editor.CodeEditorPane;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.JPanel;

@SASScope
public abstract class CodeEditorDialog
extends WAStandardDialog {
    protected CodeEditor _codeEditor;
    protected CodeEditorDocument _document;
    protected boolean _isEditable;

    protected CodeEditorDialog(Frame frame) {
        super(frame);
    }

    protected CodeEditorDialog(Dialog dialog) {
        super(dialog);
    }

    protected boolean initialize(boolean isEditable) throws RemoteException, MdException {
        this._isEditable = isEditable;
        WAPanel panel = new WAPanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        int row = this.layoutTopRows((JPanel)panel);
        this._codeEditor = new CodeEditor((CodeEditorDefaults)null);
        CodeEditorPane pane = this._codeEditor.getEditorPane();
        CodeEditorDefaults defaults = this._codeEditor.getDefaults();
        pane.setLineNumbers(defaults.getPropertyBoolean("CodeEditorGeneralPane.ShowLineNumbers.txt", true));
        this._document = (CodeEditorDocument)pane.getDocument();
        pane.enablePromptForUnsavedData(false);
        this._codeEditor.SetReadOnly(!isEditable);
        if (!this.readAndSetText()) {
            return false;
        }
        pane.setCaretPosition(0);
        this._codeEditor.setPreferredSize(new Dimension(500, 400));
        panel.add((Component)this._codeEditor, (Object)new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 18, 1, LayoutConstants.FIRST_INSETS_IN_ROW, 0, 0));
        this.setHelpButtonVisible(false);
        if (!isEditable) {
            this.setOKButtonVisible(false);
        }
        this.setMainPanel(panel);
        this.setResizable(true);
        return true;
    }

    protected Action createOKAction() {
        Action action = super.createOKAction();
        action.putValue("Name", this.getSaveButtonString());
        return action;
    }

    protected boolean doDataExchange(boolean bSaveToModel) {
        if (bSaveToModel) {
            return this.save();
        }
        return true;
    }

    public boolean hasDataChanged() {
        return this._document.isDocumentModified();
    }

    protected int layoutTopRows(JPanel panel) {
        return 0;
    }

    protected String getSaveButtonString() {
        return RB.getStringResource("CED.BtnSav.txt");
    }

    protected abstract boolean readAndSetText();

    protected abstract boolean save();
}

