/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.reportdocument;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.reportdocument.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.publicobjects.reportdocument.ReportDocumentSmartObject;
import com.sas.report.repository.EntryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;

public class ReportDocumentLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final Logger log = Logger.getLogger(ReportDocumentLogicalObject.class.getName());
    protected static final UsageVersion OLDEST_VERSION = ReportDocumentSmartObject.OLDEST_VERSION;
    protected static final UsageVersion CURRENT_VERSION = ReportDocumentSmartObject.CURRENT_VERSION;
    private static Pattern fileExtensionPattern = null;

    public ReportDocumentLogicalObject(Transformation transformation, TypeInterface ti, Factory factory) throws RemoteException {
        super((Root)transformation, ti, factory);
        this.setCompatibility(OLDEST_VERSION, CURRENT_VERSION);
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    protected String getProgressMessageForDelete() {
        return Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentLogicalObject.UpdProgDelete.fmt.txt", (Object)this.getName());
    }

    public boolean delete(OperationUserInteractionInterface deleteUserInteraction) {
        if (deleteUserInteraction.isOperationCancelled()) {
            return false;
        }
        String progressText = this.getProgressMessageForDelete();
        deleteUserInteraction.updateProgress(progressText);
        log.fine(progressText);
        try {
            UtilPlatformServices.getSmartObject((String)this._fqid, (String)"Transformation").delete();
        }
        catch (Exception e) {
            log.warning(e.toString());
            String messageText = Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentLogicalObject.DeleteFailedMsg.fmt.txt", (Object)this.getName());
            String titleText = RB.getStringResource("ReportDocumentLogicalObject.DeleteFailedTitle.txt");
            int choice = deleteUserInteraction.displayMessage(titleText, messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)deleteUserInteraction, (int)choice);
            if (choice == 2) {
                deleteUserInteraction.setOperationCancelled(true);
            }
            return false;
        }
        return true;
    }

    public void rename(String name, OperationUserInteractionInterface renameUserInteraction) throws LogicalTypeException, RemoteException {
        block7: {
            if (!renameUserInteraction.isOperationCancelled()) {
                String progressText = Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentLogicalObject.UpdProgRename.fmt.txt", (Object)this.getName());
                renameUserInteraction.updateProgress(progressText);
                log.fine(progressText);
                try {
                    Matcher matcher;
                    MetadataInterface smartObj = UtilPlatformServices.getSmartObject((String)this._fqid, (String)"Transformation");
                    if (!(smartObj instanceof ReportDocumentSmartObject)) {
                        throw new Exception(Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentLogicalObject.ErrProgAction.fmt.txt", (Object)this.getName()));
                    }
                    EntryInterface entry = (EntryInterface)smartObj.newServiceObject();
                    if (fileExtensionPattern == null) {
                        fileExtensionPattern = Pattern.compile("\\.[^.]+$");
                    }
                    if ((matcher = fileExtensionPattern.matcher(entry.getName())).find()) {
                        String oldExtension = matcher.group();
                        matcher = fileExtensionPattern.matcher(name);
                        if (!matcher.find() || !matcher.group().equalsIgnoreCase(oldExtension)) {
                            UtilGui.displayError((String)Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentLogicalObject.RenameExtensionNotAllowed.fmt.txt", (Object)oldExtension));
                            return;
                        }
                    }
                    entry.renameTo(name);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString());
                    String messageText = Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentLogicalObject.RenameFailedMsg.fmt.txt", (Object)this.getName());
                    String titleText = RB.getStringResource("ReportDocumentLogicalObject.RenameFailedTitle.txt");
                    int choice = renameUserInteraction.displayMessage(titleText, messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                    OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)renameUserInteraction, (int)choice);
                    if (choice != 2) break block7;
                    renameUserInteraction.setOperationCancelled(true);
                }
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name=").append(this.getName());
        buf.append(", fqid=").append(this._fqid);
        buf.append(", type=Transformation");
        return buf.toString();
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return true;
    }

    public boolean isDeleteAllowed() throws LogicalTypeException, RemoteException {
        return true;
    }

    public boolean isExportAllowed() throws LogicalTypeException {
        return this.getTypeInterface() instanceof TransportableTypeInterface;
    }
}

