/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.reportdocument;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.reportdocument.RB;
import com.sas.metadata.logical.reportdocument.ReportDocumentType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameExtensionProvider;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.publicobjects.reportdocument.ReportDocumentSmartObject;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportDocumentImportListener
extends AbstractImportListener
implements ImportNameExtensionProvider {
    static final Logger _log = Logger.getLogger(ReportDocumentImportListener.class.getName());

    public ReportDocumentImportListener(ReportDocumentType type) {
        super((TransportableTypeInterface)type);
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("ReportDocumentImportListener.ProjectRepos.txt"));
        }
        this.checkContentMapping(operation, importItems);
        return 0;
    }

    protected void checkContentMapping(ImportOperationInterface operation, List<ImportItemInterface> importItems) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        importLogger.debug((Object)RB.getStringResource("ReportDocumentImportListener.CheckContentServer.txt"));
        try {
            UtilReportServices urs = UtilReportServices.getInstance();
            HashSet<String> checkedTopLevelFolders = new HashSet<String>();
            for (ImportItemInterface importItem : importItems) {
                String topLevelFolder = importItem.getTargetPath()[0];
                if (checkedTopLevelFolders.contains(topLevelFolder)) continue;
                importLogger.debug((Object)("Checking target top level folder \"/" + topLevelFolder + "\""));
                PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)topLevelFolder);
                Repository rr = urs.getReportRepository(path);
                if (rr != null) {
                    rr.ensureRepositoryContentExists(path.getRootTree());
                    importLogger.debug((Object)"Connected to content server");
                } else {
                    rr = urs.getReportRepository(PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)"System"));
                    if (rr == null) {
                        throw new RepositoryException(Message.format((ResourceBundle)RB.getResources(), (String)"ReportDocumentImportListener.NoValidContentMapping.fmt.txt", (Object)topLevelFolder, (Object)this.getTypeInterface().getDisplayType()));
                    }
                }
                checkedTopLevelFolders.add(topLevelFolder);
            }
        }
        catch (Exception e) {
            importLogger.error((Object)e.toString(), (Throwable)e);
            _log.fine(e.toString());
            throw new MetadataPromotionException((Throwable)e);
        }
    }

    public int updateObjects(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        int rc = 0;
        for (ImportItemInterface importItem : importItems) {
            if (importItem.getImportState() != 2) continue;
            String targetOMAId = importItem.getTargetID();
            String mdType = importItem.getTypeInterface().getMetadataType();
            try {
                MetadataInterface mdi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetOMAId, (String)mdType);
                mdi.refresh();
            }
            catch (ServiceException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importContent(ImportOperationInterface operation, List importItems) throws TransportException, IOException {
        Log importLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        _log.fine("ReportDocumentImportListener invoked, object count = " + importItems.size());
        String dfObjectName = null;
        try {
            int importedItemCount = 1;
            for (ImportItemInterface item : importItems) {
                _log.fine("importing content for object #" + importedItemCount++ + " = " + item + ")");
                String targetMdObjFQID = item.getTargetID();
                dfObjectName = item.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ReportDocumentImportListener.StatusIndicator.fmt.txt"), (Object)dfObjectName));
                ReportDocumentSmartObject smartObj = ReportDocumentType.getReportDocument(operation.getServer(), targetMdObjFQID);
                String objectType = item.getTypeInterface().getDisplayType();
                importLogger.info((Object)UtilMisc.getMessage((String)UtilPromotion.getPromotionLogFormatString(), (Object)objectType, (Object)item.toString(), (Object)targetMdObjFQID));
                Map contentMap = contentHandler.getBinaryContent(item.getID());
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("ReportDocumentImportListener.ImportContentItemCount.fmt.txt"), (Object)Integer.toString(contentMap.size()), (Object)dfObjectName));
                for (Map.Entry element : contentMap.entrySet()) {
                    String key = (String)element.getKey();
                    if (!this.getTypeInterface().getPublicType().equals(key)) continue;
                    OutputStream outStream = null;
                    try {
                        InputStream inStream = (InputStream)element.getValue();
                        EntryInterface ei = (EntryInterface)smartObj.newServiceObject();
                        outStream = ei.getOutputStream(false);
                        try {
                            int b;
                            while ((b = inStream.read()) != -1) {
                                outStream.write(b);
                            }
                            outStream.flush();
                        }
                        catch (Exception e) {
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("ReportDocumentImportListener.ImportContent.ZeroLength.fmt.txt"), (Object)dfObjectName));
                        }
                    }
                    finally {
                        if (outStream == null) continue;
                        try {
                            outStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = dfObjectName == null ? RB.getStringResource("ReportDocumentImportListener.ImportFailedGeneral.txt") : UtilMisc.getMessage((String)RB.getStringResource("ReportDocumentImportListener.ImportFailedSpecific.fmt.txt"), dfObjectName);
            _log.log(Level.SEVERE, msg, e);
            importLogger.error((Object)msg, (Throwable)e);
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return 0;
    }
}

