/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.reportdocument;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.reportdocument.RB;
import com.sas.metadata.logical.reportdocument.ReportDocumentType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.publicobjects.reportdocument.ReportDocumentSmartObject;
import com.sas.report.repository.EntryInterface;
import com.sas.services.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;

public class ReportDocumentExportListener
extends AbstractExportListener {
    private static final Logger log = Logger.getLogger(ReportDocumentExportListener.class.getName());

    public ReportDocumentExportListener(ReportDocumentType type) {
        super((TransportableTypeInterface)type);
    }

    public int exportContent(ExportOperationInterface operation, List exportItems) throws TransportException, IOException {
        log.fine("ReportDocumentExportListener Invoked...");
        Log exportLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        try {
            int exportedItemsCount = 1;
            for (ExportItemInterface exportItem : exportItems) {
                String metaFQID = exportItem.getID();
                log.fine("Export item [" + exportedItemsCount++ + "] metadata ID = " + metaFQID);
                ReportDocumentSmartObject smartObject = ReportDocumentType.getReportDocument(operation.getServer(), metaFQID);
                String name = smartObject.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ReportDocumentExportListener.StatusIndicator.fmt.txt"), (Object)name));
                log.fine("ReportDocumentSmartObject object: " + name + " (" + this.getTypeInterface().getPublicType() + ")");
                EntryInterface ei = (EntryInterface)smartObject.newServiceObject();
                InputStream is = ei.getInputStream();
                contentHandler.addBinaryContent(metaFQID, this.getTypeInterface().getPublicType(), is);
                exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("ReportDocumentExportListener.ExportContentItemCount.fmt.txt"), (Object)Integer.toString(1), (Object)exportItem.toString()));
            }
        }
        catch (Exception e) {
            throw new TransportException((Throwable)e, null);
        }
        return 0;
    }
}

