/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report.scheduling;

import com.sas.metadata.logical.report.scheduling.BatchServers;
import com.sas.metadata.logical.report.scheduling.CreateJobPanel;
import com.sas.metadata.logical.report.scheduling.RB;
import com.sas.metadata.logical.report.scheduling.RBUtil;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.security.CredentialLoginServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserServiceInterface;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;

public class CreateJobDialog
extends WAStandardDialog {
    private static final Logger log = Logger.getLogger(CreateJobDialog.class.getName());
    private CreateJobPanel m_mainPanel;
    private boolean isOK = false;
    private DefaultListModel _reportListModel;
    private String _listLabel;
    private UserContextInterface _userContext;
    private BatchServers _batchServers;

    public CreateJobDialog(DefaultListModel reportListModel, String listLabel, BatchServers batchServers) {
        super((Frame)Workspace.getWorkspace(), RB.getStringResource("CreateJobDialog.Title.txt"), true);
        this._reportListModel = reportListModel;
        this._listLabel = listLabel;
        this._batchServers = batchServers;
        this.setHelpProduct("report");
        this.setHelpTopic("wrs_createschedulejobs");
    }

    protected void initialize() {
        super.initialize();
        this.m_mainPanel = new CreateJobPanel(this._reportListModel, this._listLabel, this._batchServers);
        this.setMainPanel(this.m_mainPanel);
    }

    protected void layoutWidgets() {
        super.layoutWidgets();
    }

    public boolean onOK() {
        if (super.onOK()) {
            try {
                UserServiceInterface _userService = CorePlatformServices.getUserService();
                this._userContext = _userService.newUser(this.getUserName(), this.getPassword());
            }
            catch (CredentialLoginServiceException e) {
                String msg = RBUtil.getStringResource("CreateJobDialog.IncorrectUserError.txt");
                log.warning(msg);
                UtilGui.displayError((String)msg);
                return false;
            }
            catch (Exception e) {
                String msg = RBUtil.getStringResource("CreateJob.ErrorDialog.msg.fmt.txt", e.toString());
                log.log(Level.SEVERE, msg, e);
                UtilGui.displayError((String)msg);
                return false;
            }
            this.isOK = true;
            return true;
        }
        return false;
    }

    public boolean onCancel() {
        return super.onCancel();
    }

    public boolean isOK() {
        return this.isOK;
    }

    public void setOK(boolean pIsOK) {
        this.isOK = pIsOK;
    }

    public String getPassword() {
        return this.m_mainPanel.getTopPanel().getPassword();
    }

    public String getUserName() {
        return this.m_mainPanel.getTopPanel().getUserName();
    }

    public UserContextInterface getUserContext() {
        return this._userContext;
    }

    public int getSelectedJavaBatchServer() {
        return this.m_mainPanel.getTopPanel().getSelectedJavaBatchServer();
    }
}

