/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.UtilReportRepositoryService;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.AdapterFactory;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.report.repository.RepositoryFactory;
import com.sas.report.repository.UtilReportReposService;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.reportrepository.client.domain.RepositoryExceptionHolder;
import java.io.File;
import java.rmi.RemoteException;
import java.util.logging.Logger;

public class UtilReportServices {
    public static final String REPORT_MD_OBJ_TYPE = "Transformation";
    private static final Logger log = Logger.getLogger(UtilReportServices.class.getName());
    private static final UtilReportServices _instance = new UtilReportServices();
    private static File _currentWorkingDir;
    private static String _publicType;

    public static UtilReportServices getInstance() {
        return _instance;
    }

    private UtilReportServices() {
    }

    public DirectoryInterface getDirectory(Root localJomaObj) throws IllegalStateException, ServiceException, RemoteException, RepositoryException {
        FolderInterface smartObj = (FolderInterface)UtilPlatformServices.getSmartObject((Root)localJomaObj);
        log.fine("smart object fetch returned " + smartObj);
        Object serviceObject = smartObj.newServiceObject();
        if (serviceObject == null) {
            throw new IllegalStateException(UtilMisc.getMessage((String)RB.getStringResource("URS.NoServiceObj.fmt.txt"), (Object)smartObj.getName()));
        }
        DirectoryInterface dir = AdapterFactory.adaptDirectory((Object)serviceObject);
        log.fine("RM API dir object = " + dir);
        return dir;
    }

    public EntryInterface getReport(Root localJomaObj) throws IllegalStateException, ServiceException, RemoteException, RepositoryException {
        MetadataInterface smartObj = UtilPlatformServices.getSmartObject((Root)localJomaObj);
        return this.getReport(smartObj);
    }

    public EntryInterface getReport(String mdObjFQID, String mdObjType) throws IllegalStateException, ServiceException, RemoteException, RepositoryException {
        MetadataInterface smartObj = UtilPlatformServices.getSmartObject((String)mdObjFQID, (String)mdObjType);
        if (smartObj == null) {
            throw new IllegalStateException(UtilMisc.getMessage((String)RB.getStringResource("URS.NullSmartObj.fmt.txt"), (Object)mdObjFQID, (Object)mdObjType));
        }
        return this.getReport(smartObj);
    }

    EntryInterface getReport(MetadataInterface smartObj) throws ServiceException, RemoteException, RepositoryException {
        Object serviceObject = smartObj.newServiceObject();
        if (serviceObject == null) {
            throw new IllegalStateException(UtilMisc.getMessage((String)RB.getStringResource("URS.NoServiceObj.fmt.txt"), (Object)smartObj.getName()));
        }
        EntryInterface report = AdapterFactory.adaptEntry((Object)serviceObject);
        log.fine("RM API report object = " + report);
        String reportName = smartObj.getName();
        String reportType = smartObj.getType();
        int dot = reportType.lastIndexOf(".");
        if (dot > 0) {
            reportType = reportType.substring(0, dot);
        }
        String reportNameAndType = reportName + "(" + reportType + ")";
        EntryInterface parentDir = report.getParentEntry();
        if (!parentDir.entryExists(reportNameAndType)) {
            throw new IllegalStateException(UtilMisc.getMessage((String)RB.getStringResource("URS.ReportDoesNotExist.fmt.txt"), (Object)reportName));
        }
        return report;
    }

    SessionContextInterface getSessionContext() throws IllegalStateException {
        return UtilPlatformServices.getSessionContext();
    }

    public MetadataInterface getSmartObject(Root localJomaObj) throws IllegalStateException, RemoteException, ServiceException {
        return UtilPlatformServices.getSmartObject((Root)localJomaObj);
    }

    public Repository getReportRepository(PathUrl pathUrl) throws RepositoryException, RemoteException, ServiceException {
        Repository rr;
        if (!UtilReportRepositoryService.davCredentialsSecured()) {
            RepositoryFactory rf = new RepositoryFactory(this.getSessionContext());
            rr = rf.getReportRepository(pathUrl);
        } else {
            rr = UtilReportServices.getRepositoryAdapter(pathUrl);
        }
        return rr;
    }

    static void saveCurrentWorkingDir(File f) {
        _currentWorkingDir = f;
    }

    static File getCurrentWorkingDir() {
        return _currentWorkingDir;
    }

    static void saveCurrentPublicType(String publicType) {
        _publicType = publicType;
    }

    static String getCurrentPublicType() {
        return _publicType;
    }

    static Repository getRepositoryAdapter(PathUrl pathUrl) throws RepositoryException, RemoteException, ServiceException {
        try {
            String reposName = UtilReportRepositoryService.getReposFactoryService().getReportRepository(pathUrl.toString());
            if (reposName != null) {
                return UtilReportReposService.getRepositoryAdapter(null, (UserContextInterface)UtilPlatformServices.getUserContext(), (String)reposName);
            }
            return null;
        }
        catch (RepositoryExceptionHolder e) {
            throw new RepositoryException(e.getExceptionType().getMessage());
        }
    }
}

