/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.Type;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.report.ImagesReport;
import com.sas.metadata.logical.report.ObjectFactory;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.ReportExportListener;
import com.sas.metadata.logical.report.ReportImportListener;
import com.sas.metadata.promotion.ExportListener;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;

public class ReportType
extends Type
implements TransportableTypeInterface {
    private static final Logger log = Logger.getLogger(ReportType.class.getName());
    private static final String _displayType = RB.getStringResource("ReportType.DisplayType.txt");
    private static ReportType _theInstance;
    private static String[] _requiredAttributes;
    private ExportListener _exportListener;
    private ImportListener _importListener;
    private ObjectFactory _objectFactory;

    public static synchronized TypeInterface getInstance(Factory factory, TypeDescriptorInterface typeDescriptorInterface) throws RemoteException, LogicalTypeException {
        if (factory == null) {
            throw new IllegalArgumentException("Logic error: factory should not be null.");
        }
        if (_theInstance == null) {
            _theInstance = new ReportType(factory, typeDescriptorInterface);
        } else {
            if (factory != ReportType._theInstance._factory) {
                throw new IllegalArgumentException("Only one factory instance is supported.");
            }
            _theInstance.refresh(typeDescriptorInterface);
        }
        return _theInstance;
    }

    protected ReportType(Factory factory, TypeDescriptorInterface typeDescriptorInterface) throws RemoteException, LogicalTypeException {
        super(factory, typeDescriptorInterface);
    }

    public String[] getRequiredAttributes() {
        log.fine("entering, returning " + _requiredAttributes);
        return _requiredAttributes;
    }

    public boolean isMetadataObjectOfInterest(Root root) {
        if (root instanceof Transformation) {
            Transformation trans = (Transformation)root;
            try {
                if (trans.getTransformRole().equalsIgnoreCase("Report")) {
                    log.fine("returning TRUE");
                    return true;
                }
            }
            catch (RemoteException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
        return false;
    }

    public boolean isMetadataObjectOfInterest(Map map) {
        String role;
        if (map.get("MetadataObjectType").equals("Transformation") && (role = (String)map.get("TransformRole")).equalsIgnoreCase("Report")) {
            log.fine("returning TRUE");
            return true;
        }
        return false;
    }

    public String getDisplayType() {
        return _displayType;
    }

    public ObjectFactoryInterface getObjectFactory() {
        if (this._objectFactory == null) {
            this._objectFactory = new ObjectFactory((TypeInterface)this);
        }
        return this._objectFactory;
    }

    Factory getFactory() {
        return this._factory;
    }

    public String getMetadataType() {
        return "Transformation";
    }

    public Icon getIcon(int type) {
        switch (type) {
            case 1: {
                return ImagesReport.getReportIcon16();
            }
            case 2: {
                return ImagesReport.getReportNewIcon16();
            }
            case 3: {
                return ImagesReport.getReportUpdateIcon16();
            }
        }
        return ImagesReport.getReportIcon16();
    }

    public Object getExportListener() {
        if (this._exportListener == null) {
            this._exportListener = new ReportExportListener(this);
        }
        return this._exportListener;
    }

    public Object getImportListener() {
        if (this._importListener == null) {
            this._importListener = new ReportImportListener(this);
        }
        return this._importListener;
    }

    public String getPublicType() {
        return "Report";
    }

    public String getLogicalType() {
        return "Report";
    }

    static {
        _requiredAttributes = new String[]{"TransformRole"};
    }
}

