/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.MemberInterface;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.Transformation;
import com.sas.report.repository.EntryInterface;
import com.sas.services.util.DateUtil;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;

public class ReportLogicalObject
extends LogicalObject
implements MemberInterface {
    private static final Logger log = Logger.getLogger(ReportLogicalObject.class.getName());
    private String _jomaFQID;
    private String _jomaCMetadataType;
    private String _lastUpdatedAsSasDate;

    static String convertToSasDate(double javaDateAsDouble) {
        if (javaDateAsDouble == 0.0) {
            return null;
        }
        long javaDateAsLong = (long)javaDateAsDouble;
        TimeZone timezone = TimeZone.getTimeZone("GMT");
        double sasDate = DateUtil.javaDateToSASDateTime((long)javaDateAsLong, (TimeZone)timezone);
        return Double.toString(sasDate);
    }

    static double getAssociatedTimestampValue(Transformation remoteTransformation, String attributeNameToMatch) {
        try {
            AssociationList timeStamps = remoteTransformation.getTimestamps(true);
            if (timeStamps != null) {
                for (Timestamp timestamp : timeStamps) {
                    String timestampName = timestamp.getTimestampRole();
                    if (!attributeNameToMatch.equals(timestampName)) continue;
                    return timestamp.getDateandTime();
                }
            }
            log.warning(RBUtil.getStringResource("RLO.timestampNotFoundRemote.fmt.txt", attributeNameToMatch));
        }
        catch (RemoteException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        catch (MdException e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        return 0.0;
    }

    ReportLogicalObject(Transformation remoteTransformation, TypeInterface ti, Factory factory) throws RemoteException {
        super((Root)remoteTransformation, ti, factory);
        this._jomaFQID = remoteTransformation.getFQID();
        this._jomaCMetadataType = remoteTransformation.getCMetadataType();
        this._lastUpdatedAsSasDate = remoteTransformation.getMetadataUpdated();
    }

    public Icon getIcon() {
        return this.getTypeInterface().getIcon(1);
    }

    protected String getProgressMessageForDelete() {
        return RBUtil.getStringResource("RLO.UpdProgDelete.fmt.txt", this.getName());
    }

    public boolean delete(OperationUserInteractionInterface userInteraction) {
        if (!userInteraction.isOperationCancelled()) {
            String progressText = this.getProgressMessageForDelete();
            userInteraction.updateProgress(progressText);
            log.fine(progressText);
            try {
                UtilReportServices rs = UtilReportServices.getInstance();
                EntryInterface report = rs.getReport(this._jomaFQID, this._jomaCMetadataType);
                report.delete();
                return true;
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString());
                String messageText = UtilMisc.getMessage((String)RB.getStringResource("RLO.DeleteFailedMsg.fmt.txt"), (Object)this.getName(), (Object)"See error log. ");
                String titleText = RB.getStringResource("RLO.DeleteFailedTitle.txt");
                int choice = userInteraction.displayMessage(titleText, messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
                OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)userInteraction, (int)choice);
                if (choice == 2) {
                    userInteraction.setOperationCancelled(true);
                }
                return false;
            }
        }
        return false;
    }

    public String getAttributeValue(String attributeName) {
        if ("MetadataUpdated".equals(attributeName) && this._lastUpdatedAsSasDate != null) {
            return this._lastUpdatedAsSasDate;
        }
        return super.getAttributeValue(attributeName);
    }

    public void refresh(Root root) throws LogicalTypeException, RemoteException {
        super.refresh(root);
        Transformation localTransformation = (Transformation)root;
        double lastUpdatedAsJavaDouble = ReportLogicalObject.getAssociatedTimestampValue(localTransformation, "Modified Date");
        this._lastUpdatedAsSasDate = ReportLogicalObject.convertToSasDate(lastUpdatedAsJavaDouble);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this.toString());
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("name=").append(this.getName());
        buf.append(", fqid=").append(this._jomaFQID);
        buf.append(", type=").append(this._jomaCMetadataType);
        buf.append(", lastModified=");
        try {
            Date d = UtilMetadata.parseDate((String)this._lastUpdatedAsSasDate);
            buf.append(d.toString());
        }
        catch (Exception e) {
            buf.append(e.toString());
        }
        return buf.toString();
    }

    public boolean isRenameAllowed() throws LogicalTypeException {
        return false;
    }
}

