/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.FolderContentMappingModel;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.cube.CubeConnectionType;
import com.sas.metadata.logical.informationmap.InformationMapConnectionType;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.ReportCacheID;
import com.sas.metadata.logical.report.ReportConnectionType;
import com.sas.metadata.logical.report.ReportContentHelper;
import com.sas.metadata.logical.report.ReportExImportUtil;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.storedprocess.StoredProcessConnectionType;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionPointUtil;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameExtensionProvider;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.ContentHelper;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.ImportedEntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryUtils;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.storage.editableproperties.PropertyMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportImportListener
extends AbstractImportListener
implements ImportNameExtensionProvider {
    static final String XML_ROM_FILE_INDICATOR = "<?xml version=\"";
    static final String BIP_SERVICE = "BIP Service";
    static final String SBIP_PREFIX = "SBIP://";
    static final String XPATH = "XPath";
    static final String ORIGINALPATH = "OriginalPath";
    static final String SASREPORT = "/SASReport/";
    static final String FOLDER = "Folder";
    protected static final Class[] CONNECTION_TYPES = new Class[]{ReportConnectionType.class, InformationMapConnectionType.class, CubeConnectionType.class, TableConnectionType.class, StoredProcessConnectionType.class};
    static final Logger log = Logger.getLogger(ReportImportListener.class.getName());
    private ReportContentHelper _contentHelper;

    public ReportImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public void initialize(ImportOperationInterface operation) {
        this._contentHelper = new ReportContentHelper();
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Log exportLogger = operation.getLogger();
        exportLogger.debug((Object)RB.getStringResource("RIL.CheckContentServer.txt"));
        int rc = this.checkForContentMapping(operation, objects);
        try {
            UtilReportServices rs = UtilReportServices.getInstance();
            Iterator iter = objects.iterator();
            if (iter.hasNext()) {
                ImportItemInterface importItem = (ImportItemInterface)iter.next();
                String[] folder = importItem.getTargetPath();
                exportLogger.debug((Object)("Checking target top level folder \"/" + folder[0] + "\""));
                PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)folder[0]);
                path = PathUrl.newPathUrlFromExistingUrl((ServerInterface)operation.getServer(), (PathUrl)path);
                if (path.getType() != FOLDER && path.getType() != null) {
                    path.setRootTree(folder[0]);
                }
                path.setType(FOLDER);
                Repository rr = rs.getReportRepository(path);
                if (rr == null) {
                    exportLogger.debug((Object)"Target top level folder not found");
                    for (Tree destTree : operation.getFolderImportingInto()) {
                        FolderContentMappingModel fcmm = new FolderContentMappingModel(destTree);
                        fcmm.loadMetadata();
                        if (fcmm.getBackingType() != 0) continue;
                        String newPath = "/" + destTree;
                        exportLogger.debug((Object)("Checking other top level folder \"" + newPath.toString() + "\""));
                        newPath = "SBIP://METASERVER/" + destTree;
                        path = new PathUrl(newPath);
                        path.setType(FOLDER);
                        rr = rs.getReportRepository(path);
                        if (rr != null) break;
                    }
                }
                if (rr == null) {
                    throw new Exception("Unable to locate any content mapped top level folders!");
                }
                rr.ensureRepositoryContentExists(path.getRootTree());
                exportLogger.debug((Object)RB.getStringResource("RIL.ConnectedContentServer.txt"));
            }
        }
        catch (Exception e) {
            exportLogger.error((Object)e.toString(), (Throwable)e);
            log.fine(e.toString());
            throw new MetadataPromotionException((Throwable)e);
        }
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("RIL.ProjectRepos.txt"));
        }
        log.fine("event = " + operation);
        log.fine("objects = " + objects);
        if (operation.getPackageFileVersion() < 9200) {
            rc |= this.setupConnectionPoints(operation, objects);
        }
        return rc;
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    private int checkForContentMapping(ImportOperationInterface operation, List reports) throws MetadataPromotionException {
        boolean contentMappingFound;
        Tree tree;
        Log importLogger;
        try {
            ImportItemInterface importItem;
            String[] path;
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessageWithDetails((TypeInterface)this.getTypeInterface(), (String)RB.getStringResource("RIL.ValidatingContentMapping.txt")));
            importLogger = operation.getLogger();
            if (operation.importIntoRoot() && (operation.getPromotionType() == 2 || operation.getPromotionType() == 3)) {
                String msg = RB.getStringResource("RIL.NoValidContentMapping.txt");
                importLogger.error((Object)msg);
                throw new MetadataPromotionException(msg);
            }
            Tree[] destTrees = operation.getFolderImportingInto();
            tree = null;
            contentMappingFound = false;
            int length = destTrees.length;
            if (length == 1) {
                tree = destTrees[0];
            } else if (length > 1 && reports.size() > 0 && (path = (importItem = (ImportItemInterface)reports.get(0)).getTargetPath()).length > 0) {
                String rootFolder = path[0];
                for (int i = 0; i < destTrees.length; ++i) {
                    Tree rootTree = destTrees[i];
                    if (!rootTree.getName().equals(rootFolder)) continue;
                    tree = rootTree;
                    break;
                }
                if (tree == null) {
                    try {
                        MdObjectStore store = operation.getStore();
                        SoftwareComponent sc = UtilMetadata.locateSoftwareComponent((String)UtilMetadata.getFoundationRepositoryID(), (MdObjectStore)store);
                        String scName = sc.getName();
                        if (scName.equals(BIP_SERVICE)) {
                            FolderContentMappingModel fcmm = new FolderContentMappingModel(sc);
                            fcmm.loadMetadata();
                            if (fcmm.getBackingType() == 0) {
                                String msg = UtilMisc.getMessage((String)RB.getStringResource("RIL.NoContentMappingOnRoot.fmt.txt"), (Object)rootFolder);
                                importLogger.error((Object)msg);
                                throw new MetadataPromotionException(msg);
                            }
                            return 0;
                        }
                        String msg = UtilMisc.getMessage((String)RB.getStringResource("RIL.NoContentMappingOnRoot.fmt.txt"), (Object)rootFolder);
                        importLogger.error((Object)msg);
                        throw new MetadataPromotionException(msg);
                    }
                    catch (MdException e) {
                        throw new MetadataPromotionException((Throwable)e);
                    }
                }
            }
        }
        catch (RemoteException e1) {
            throw new MetadataPromotionException((Throwable)e1);
        }
        if (tree != null) {
            String treeName = null;
            try {
                treeName = tree.getName();
                if (this.isContentMapped(tree)) {
                    contentMappingFound = true;
                }
            }
            catch (Exception e) {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("RIL.ContentMappingTestFailed.fmt.txt"), (Object)treeName);
                log.log(Level.WARNING, msg, e);
                importLogger.warn((Object)msg, (Throwable)e);
            }
            if (contentMappingFound) {
                importLogger.debug((Object)RB.getStringResource("RIL.ValidContentMappingFound.txt"));
                return 0;
            }
        }
        String msg = RB.getStringResource("RIL.NoValidContentMapping.txt");
        importLogger.error((Object)msg);
        throw new MetadataPromotionException(msg);
    }

    private boolean isContentMapped(Tree tree) throws MdException, RemoteException {
        Tree parentTree = tree.getParentTree();
        while (parentTree != null) {
            tree = parentTree;
            parentTree = tree.getParentTree();
        }
        return FolderContentMappingModel.isContentMapped((Tree)tree);
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        Log importLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        log.fine("Report Import Listener Invoked, object count = " + objects.size());
        String reportName = null;
        try {
            UtilReportServices rs = UtilReportServices.getInstance();
            ReportCacheID rptCacheId = new ReportCacheID();
            int i = 1;
            for (ImportItemInterface item : objects) {
                log.fine("importing content for object #" + i++ + " = " + item + ")");
                String targetMdObjFQID = item.getTargetID();
                reportName = item.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("REL.StatusIndicator.fmt.txt"), (Object)reportName));
                MetadataInterface smartObject = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetMdObjFQID, (String)"Transformation");
                EntryInterface report = rs.getReport(smartObject);
                String objectType = item.getTypeInterface().getDisplayType();
                importLogger.info((Object)UtilMisc.getMessage((String)UtilPromotion.getPromotionLogFormatString(), (Object)objectType, (Object)item.toString(), (Object)targetMdObjFQID));
                ((ImportedEntryInterface)report).deleteTransientData();
                Map contentMap = contentHandler.getBinaryContent(item.getID());
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.ContentItemCount.fmt.txt"), (Object)Integer.toString(contentMap.size()), (Object)reportName));
                for (Map.Entry element : contentMap.entrySet()) {
                    String key = (String)element.getKey();
                    InputStream inStream = (InputStream)element.getValue();
                    if ("###REPORT###".equals(key)) {
                        int len;
                        OutputStream outStream = report.getOutputStream(false);
                        byte[] buf = new byte[4096];
                        while ((len = inStream.read(buf)) != -1) {
                            outStream.write(buf, 0, len);
                        }
                        inStream.close();
                        outStream.close();
                        if (RepositoryUtils.isImageType((String)reportName)) continue;
                        PropertyMap localizableMap = operation.getPropertiesManager().getLocalizablePropertyMap((PromotionItemInterface)item);
                        ServerInterface si = operation.getServer();
                        PropertyMap connectionMap = new PropertyMap();
                        if (localizableMap != null) {
                            connectionMap = localizableMap;
                        }
                        int mapSize = 0;
                        List connectionPoints = item.getConnectionPoints();
                        if (connectionPoints == null) continue;
                        for (ConnectionPointInterface pt : connectionPoints) {
                            MetadataInterface smartTarget;
                            String xpath = pt.getUserDefinedProperty(XPATH);
                            String originalPath = pt.getUserDefinedProperty(ORIGINALPATH);
                            if (xpath == null || originalPath == null) continue;
                            String[] xpathTokens_1 = xpath.split(",");
                            for (int j = 0; j < xpathTokens_1.length; ++j) {
                                if (!xpathTokens_1[j].contains(item.getID())) continue;
                                if (xpathTokens_1[j].contains("@absolutePathLocation") && originalPath.startsWith(SBIP_PREFIX)) {
                                    originalPath = new PathUrl(originalPath).getAbsolutePath();
                                }
                                if (!xpathTokens_1[j].contains("BusinessModelReferenceInformation") || !xpathTokens_1[j].contains("@location") || originalPath.startsWith(SBIP_PREFIX)) break;
                                PathUrl fixOriginalPath = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)originalPath);
                                originalPath = fixOriginalPath.toString();
                                break;
                            }
                            xpathTokens_1 = null;
                            PathUrl targetPathUrl = null;
                            String targetPath = pt.getTargetPath();
                            if (targetPath != null) {
                                targetPathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)targetPath);
                            } else if (pt.getTargetID() != null && (smartTarget = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)pt.getTargetID(), (String)pt.getMetadataType())) != null) {
                                targetPathUrl = smartTarget.getPathUrl();
                            }
                            if (targetPathUrl == null) continue;
                            boolean newItem = false;
                            if (xpath.contains("ReposCube") && xpath.contains("/@name") || xpath.contains("ReposTable") && xpath.contains("/@name")) {
                                newItem = true;
                            }
                            if (originalPath.startsWith(SBIP_PREFIX)) {
                                targetPath = targetPathUrl.toString();
                                if (!targetPath.equalsIgnoreCase(originalPath)) {
                                    newItem = true;
                                }
                            } else {
                                targetPath = targetPathUrl.getAbsolutePath();
                                if (!targetPath.equalsIgnoreCase(originalPath)) {
                                    newItem = true;
                                }
                            }
                            if (!newItem) continue;
                            String[] xpathTokens = xpath.split(",");
                            for (int j = 0; j < xpathTokens.length; ++j) {
                                String _schemaName;
                                String[] name;
                                PathUrl p;
                                ServerInterface server;
                                RepositoryInterface repos;
                                MetadataInterface mi;
                                if (!xpathTokens[j].contains(item.getID()) && !xpathTokens[j].startsWith(SASREPORT)) continue;
                                xpathTokens[j] = xpathTokens[j].replaceFirst(item.getID(), "");
                                if (xpathTokens[j].contains("ReposCube") && xpathTokens[j].contains("/@name")) {
                                    mi = null;
                                    repos = smartObject.getRepository();
                                    server = repos.getServer();
                                    p = new PathUrl(targetPath);
                                    mi = server.getObjectByPath(p);
                                    Cube _cube = (Cube)mi.getRepositoryEntity();
                                    name = ReportExImportUtil.getNamedPath(_cube, importLogger);
                                    String _cubeName = name[2];
                                    _schemaName = name[1];
                                    String _serverName = name[0];
                                    connectionMap.setProperty(xpathTokens[j], _cubeName);
                                    ++mapSize;
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_cubeName, (Object)xpathTokens[j]));
                                    String[] xpathCalculateTokens = xpathTokens[j].split("/");
                                    String _schemaXPath = xpathCalculateTokens[0];
                                    String _serverXPath = xpathCalculateTokens[0];
                                    int _schemaLength = xpathCalculateTokens.length - 3;
                                    int _serverLength = xpathCalculateTokens.length - 5;
                                    for (int s = 1; s < _schemaLength; ++s) {
                                        _schemaXPath = _schemaXPath + "/" + xpathCalculateTokens[s];
                                        if (s >= _serverLength) continue;
                                        _serverXPath = _serverXPath + "/" + xpathCalculateTokens[s];
                                    }
                                    _schemaXPath = _schemaXPath + "/@name";
                                    _serverXPath = _serverXPath + "/@name";
                                    connectionMap.setProperty(_schemaXPath, _schemaName);
                                    ++mapSize;
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_schemaName, (Object)_schemaXPath));
                                    connectionMap.setProperty(_serverXPath, _serverName);
                                    ++mapSize;
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_serverName, (Object)_serverXPath));
                                    continue;
                                }
                                if (xpathTokens[j].contains("ReposTable") && xpathTokens[j].contains("/@name")) {
                                    mi = null;
                                    repos = smartObject.getRepository();
                                    server = repos.getServer();
                                    p = new PathUrl(targetPath);
                                    mi = server.getObjectByPath(p);
                                    PhysicalTable _physicalTable = (PhysicalTable)mi.getRepositoryEntity();
                                    name = ReportExImportUtil.getNamedPath(_physicalTable, importLogger);
                                    String _physicalTableName = null;
                                    _schemaName = null;
                                    String _libraryName = name[1];
                                    String _serverName = name[0];
                                    if (name.length == 3) {
                                        _physicalTableName = name[2];
                                    } else if (name.length == 4) {
                                        _physicalTableName = name[3];
                                        _schemaName = name[2];
                                    }
                                    connectionMap.setProperty(xpathTokens[j], _physicalTableName);
                                    ++mapSize;
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_physicalTableName, (Object)xpathTokens[j]));
                                    String[] xpathCalculateTokens = xpathTokens[j].split("/");
                                    String _libraryXPath = xpathCalculateTokens[0];
                                    String _serverXPath = xpathCalculateTokens[0];
                                    int _schemaLength = xpathCalculateTokens.length - 3;
                                    int _serverLength = xpathCalculateTokens.length - 5;
                                    for (int s = 1; s < _schemaLength; ++s) {
                                        _libraryXPath = _libraryXPath + "/" + xpathCalculateTokens[s];
                                        if (s >= _serverLength) continue;
                                        _serverXPath = _serverXPath + "/" + xpathCalculateTokens[s];
                                    }
                                    _libraryXPath = _libraryXPath + "/@name";
                                    _serverXPath = _serverXPath + "/@name";
                                    connectionMap.setProperty(_libraryXPath, _libraryName);
                                    ++mapSize;
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_libraryName, (Object)_libraryXPath));
                                    connectionMap.setProperty(_serverXPath, _serverName);
                                    ++mapSize;
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_serverName, (Object)_serverXPath));
                                    if (_schemaName == null) continue;
                                    String _schemaXPath = _libraryXPath.replace("/@name", "/@schemaName");
                                    connectionMap.setProperty(_schemaXPath, _schemaName);
                                    importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)_schemaName, (Object)_schemaXPath));
                                    continue;
                                }
                                connectionMap.setProperty(xpathTokens[j], targetPath);
                                ++mapSize;
                                importLogger.debug((Object)UtilMisc.getMessage((String)RB.getStringResource("RIL.UpdateReport.fmt.txt"), (Object)originalPath, (Object)targetPath, (Object)xpathTokens[j]));
                            }
                        }
                        this._contentHelper.retrieveUpdateContentFromPackage(report, operation, si, connectionMap);
                        continue;
                    }
                    rptCacheId.setFullName(key);
                    String cacheName = rptCacheId.getCacheName();
                    String cacheItemName = rptCacheId.getItemName();
                    CacheSetInterface csi = report.getCacheSetInterface();
                    CacheInterface cache = csi.get(cacheName);
                    CacheItemInterface cacheItem = cache.exists(cacheItemName) ? cache.get(cacheItemName) : cache.create(cacheItemName);
                    OutputStream oStream = cacheItem.getOutputStream();
                    this._contentHelper.writeToOutputStream(inStream, oStream);
                }
            }
        }
        catch (Exception e) {
            String msg = reportName == null ? RB.getStringResource("RIL.ImportFailedGeneral.txt") : UtilMisc.getMessage((String)RB.getStringResource("RIL.ImportFailedSpecific.fmt.txt"), reportName);
            log.log(Level.SEVERE, msg, e);
            importLogger.error((Object)msg, (Throwable)e);
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            this._contentHelper.deleteTemporaryFiles();
        }
        return 0;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        int rc = 0;
        for (ImportItemInterface importItem : objects) {
            if (importItem.getImportState() != 2) continue;
            String targetOMAId = importItem.getTargetID();
            String mdType = importItem.getTypeInterface().getMetadataType();
            try {
                MetadataInterface mdi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetOMAId, (String)mdType);
                mdi.refresh();
            }
            catch (ServiceException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rc;
    }

    private int setupConnectionPoints(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        int rc = 0;
        ServerInterface server = null;
        try {
            server = operation.getServer();
        }
        catch (Exception e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        int count = objects.size();
        int index = 0;
        boolean counter = false;
        for (ImportItemInterface item : objects) {
            String msg;
            String id = item.getID();
            String name = item.getName();
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)item.getTypeInterface(), (String)name, (int)(++index), (int)count));
            try {
                Map contentMap = contentHandler.getBinaryContent(id);
                for (String key : contentMap.keySet()) {
                    if (!"###REPORT###".equals(key)) continue;
                    InputStream is = (InputStream)contentMap.get(key);
                    ContentHelper contentHelper = new ContentHelper();
                    ConnectionPointInterface pt = null;
                    Map urlList = contentHelper.retrieveMapOfSbipAndAbsolutePathUrl(is);
                    for (Map.Entry me : urlList.entrySet()) {
                        String _theURL = (String)me.getValue();
                        String _xpath = (String)me.getKey();
                        if (_theURL.endsWith("(Folder)")) continue;
                        PathUrl pathUrl = null;
                        if (_theURL.startsWith("/")) {
                            pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)_theURL);
                        } else if (_theURL.toUpperCase().startsWith("SBIP")) {
                            pathUrl = new PathUrl(_theURL);
                        }
                        if (pathUrl == null || pathUrl.getType() == null) {
                            importLogger.debug((Object)("Ignoring this Report dependency, unable to identify : " + (String)me.getValue()));
                            continue;
                        }
                        if (pathUrl.getType().equals("BriefInformationMap")) {
                            pathUrl.setType("InformationMap");
                        }
                        if ((pt = ConnectionPointUtil.createImportConnectionPoint((ImportOperationInterface)operation, (ImportItemInterface)item, (PathUrl)pathUrl)) == null) continue;
                        if (pt.getUserDefinedProperty(ORIGINALPATH) == null) {
                            pt.addUserDefinedProperty(XPATH, id + _xpath);
                            pt.addUserDefinedProperty(ORIGINALPATH, _theURL);
                            continue;
                        }
                        String existingKey = pt.getUserDefinedProperty(XPATH);
                        pt.removeUserDefinedProperty(XPATH);
                        _xpath = id + _xpath + "," + existingKey;
                        pt.addUserDefinedProperty(XPATH, _xpath);
                    }
                }
            }
            catch (IOException io) {
                msg = UtilMisc.getMessage((String)RB.getStringResource("RIL.CannotGetContent.fmt.txt"), (Object)name);
                importLogger.error((Object)msg, (Throwable)io);
                rc = 8;
            }
            catch (TransportException te) {
                msg = UtilMisc.getMessage((String)RB.getStringResource("RIL.CannotGetContent.fmt.txt"), (Object)name);
                importLogger.error((Object)msg, (Throwable)te);
                rc = 8;
            }
            catch (ServiceException se) {
                msg = UtilMisc.getMessage((String)RB.getStringResource("RIL.CannotGetReport.fmt.txt"), (Object)name);
                importLogger.error((Object)msg, (Throwable)se);
                rc = 8;
            }
        }
        return rc;
    }
}

