/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Timestamp;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.Entry;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.RepositoryDuplicateNameException;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportGeneralPropertyTab
extends BIPTreeElementGeneralPropertyTab {
    private static final Logger log1 = Logger.getLogger(ReportGeneralPropertyTab.class.getName());
    private Transformation _transformation;
    private ReportManagementUpdateHelper _rmHelper;
    private String _oldName;
    private String newName;
    private String tempNewName = "";
    private boolean OKbutton;

    private static final Config twiddleConfig(Config config) {
        config.setUserControlled(ConfigGeneralPanel.NAME);
        return config;
    }

    public ReportGeneralPropertyTab(Root root, Tree containingTree, int type, TypeInterface ti, Config config, Transformation localTransformation) throws RemoteException {
        super(root, containingTree, 1, ti, ReportGeneralPropertyTab.twiddleConfig(config));
        this._transformation = localTransformation;
        this._rmHelper = new ReportManagementUpdateHelper(localTransformation);
        WATextField nameField = (WATextField)this.getUserControlledComponent(ConfigGeneralPanel.NAME);
        nameField.setText(this._transformation.getName());
        this._oldName = this._transformation.getName();
        this.setHelpProduct("folderview");
        this.setHelpTopic("generaltab");
    }

    public void onParentOK() {
        log1.fine("entering");
        this.OKbutton = true;
        try {
            if (this._transformation.objectModified()) {
                this._rmHelper.updateTimestamp();
            }
        }
        catch (RemoteException e) {
            log1.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        super.onParentOK();
    }

    public void saveSettingsAndCleanUp() {
        WATextField nameField;
        String newName;
        super.saveSettingsAndCleanUp();
        if (this.OKbutton && !this._oldName.equals(newName = (nameField = (WATextField)this.getUserControlledComponent(ConfigGeneralPanel.NAME)).getText())) {
            this._rmHelper.update(this._oldName, newName);
        }
        this.OKbutton = false;
    }

    protected boolean dataValidate() throws RemoteException {
        WATextField nameField;
        block13: {
            nameField = (WATextField)this.getUserControlledComponent(ConfigGeneralPanel.NAME);
            if (nameField != null) {
                this.newName = nameField.getText();
                log1.fine("oldName: " + this._oldName + ", newName=" + this.newName);
                try {
                    if (this._oldName.equals(this.newName)) {
                        return true;
                    }
                    Entry.validateName((String)this.newName);
                    UtilReportServices rs = UtilReportServices.getInstance();
                    try {
                        EntryInterface entry = rs.getReport((Root)this._transformation);
                        DirectoryInterface myDir = (DirectoryInterface)entry.getParentEntry();
                        if (myDir.entryExists(this.newName)) {
                            String msg = RBUtil.getStringResource("ReportManagementHelper.ReportExists.fmt.txt");
                            throw new RepositoryDuplicateNameException(msg);
                        }
                        break block13;
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                        return false;
                    }
                    catch (ServiceException e) {
                        e.printStackTrace();
                        return false;
                    }
                    catch (RepositoryDuplicateNameException e) {
                        String exMsg = e.getLocalizedMessage();
                        if (exMsg == null) {
                            exMsg = e.toString();
                        }
                        String msg = RBUtil.getStringResource("ReportManagementHelper.RenameFailed.fmt.txt", this._oldName, this.newName, exMsg);
                        log1.log(Level.WARNING, msg);
                        UtilGui.displayError((String)msg);
                        nameField.grabFocus();
                        nameField.setText(this._oldName);
                        return false;
                    }
                    catch (RepositoryException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                catch (IllegalArgumentException e) {
                    String exMsg = e.getLocalizedMessage();
                    if (exMsg == null) {
                        exMsg = e.toString();
                    }
                    String msg = RBUtil.getStringResource("ReportManagementHelper.RenameFailed.fmt.txt", this._oldName, this.newName, exMsg);
                    log1.log(Level.WARNING, msg);
                    UtilGui.displayError((String)msg);
                    nameField.grabFocus();
                    nameField.setText(this._oldName);
                    return false;
                }
            }
            return false;
        }
        if (!this.extensionMatch(this._oldName, this.newName) && !this.tempNewName.equals(this.newName)) {
            String msg = RBUtil.getStringResource("RGP.ExtensionChangeNotAllowed.fmt.txt", this._oldName, this.newName);
            UtilGui.displayWarning((String)msg);
            log1.log(Level.WARNING, msg);
            nameField.grabFocus();
            nameField.setText(this._oldName);
            return false;
        }
        return true;
    }

    boolean extensionMatch(String oldName, String newName) {
        String oldNameExt = "";
        String newNameExt = "";
        int oldNameExtOffset = this._oldName.lastIndexOf(46);
        int newNameExtOffset = newName.lastIndexOf(46);
        if (oldNameExtOffset != -1) {
            oldNameExt = this._oldName.substring(oldNameExtOffset + 1);
        }
        if (newNameExtOffset != -1) {
            newNameExt = newName.substring(newNameExtOffset + 1);
        }
        return oldNameExt.equals(newNameExt);
    }

    static class ReportManagementUpdateHelper {
        private static final Logger log2 = Logger.getLogger(ReportManagementUpdateHelper.class.getName());
        private Transformation _transformation;
        private String _oldName;

        ReportManagementUpdateHelper(Transformation localTransformation) {
            this._transformation = localTransformation;
            try {
                this._oldName = this._transformation.getName();
            }
            catch (RemoteException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }

        boolean update(String _oldName, String newName) {
            try {
                UtilReportServices rs = UtilReportServices.getInstance();
                EntryInterface report = rs.getReport((Root)this._transformation);
                report.renameTo(newName);
                this.updateTimestamp();
                return true;
            }
            catch (Exception e) {
                String exMsg = e.getLocalizedMessage();
                if (exMsg == null) {
                    exMsg = e.toString();
                }
                String msg = RBUtil.getStringResource("ReportManagementHelper.RenameFailed.fmt.txt", _oldName, newName, exMsg);
                log2.log(Level.SEVERE, msg, e);
                UtilGui.displayError((String)msg);
                try {
                    this._transformation.setName(_oldName);
                }
                catch (RemoteException e2) {
                    e2.printStackTrace();
                }
                return true;
            }
        }

        boolean updateTimestamp() {
            try {
                UtilReportServices rs = UtilReportServices.getInstance();
                Date _today = new Date();
                long nowMilliseconds = _today.getTime();
                Timestamp _lm = this.getTimestamp(this._transformation, "Modified Date");
                if (null != _lm) {
                    _lm.setDateandTime((double)nowMilliseconds);
                } else {
                    log2.log(Level.WARNING, "Timestamp EntryAttributes.LAST_MODIFIED was not updated");
                }
            }
            catch (Exception e) {
                String exMsg = e.getLocalizedMessage();
                if (exMsg == null) {
                    exMsg = e.toString();
                }
                log2.log(Level.WARNING, exMsg, e);
            }
            return true;
        }

        public Timestamp getTimestamp(Transformation mdi, String timestampRole) throws RepositoryException, RemoteException {
            AssociationList vTimestampObjects = this.getTimestamps(mdi);
            for (Timestamp timestamp : vTimestampObjects) {
                String timestampName = timestamp.getTimestampRole();
                if (timestampRole.compareTo(timestampName) != 0) continue;
                return timestamp;
            }
            return null;
        }

        public AssociationList getTimestamps(Transformation mdi) throws RepositoryException, RemoteException {
            AssociationList timeStamps = null;
            try {
                timeStamps = mdi.getTimestamps(false);
                if (timeStamps == null || timeStamps.size() <= 0) {
                    timeStamps = mdi.getTimestamps(true);
                }
            }
            catch (MdException e) {
                throw new RepositoryException((Throwable)e, e.getMessage());
            }
            catch (RemoteException e) {
                throw new RepositoryException((Throwable)e, e.getMessage());
            }
            return timeStamps;
        }
    }
}

