/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DatabaseSchema;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.RelationalSchema;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.ServerContext;
import java.rmi.RemoteException;
import java.util.List;

public final class ReportExImportUtil {
    public static PhysicalTable getTable(MdStore store, String reposId, String serverName, String libraryName, String tableName, Log log) {
        PhysicalTable table = null;
        if (serverName != null && serverName.length() > 0 && libraryName != null && libraryName.length() > 0 && tableName != null && tableName.length() > 0) {
            String search = "<XMLSelect search=\"*[@Name='" + ReportExImportUtil.encodedAttrValueChars(tableName) + "'][TablePackage/*[@Name='" + libraryName + "']/DeployedComponents/*[@Name='" + serverName + "']]\"/>";
            table = (PhysicalTable)ReportExImportUtil.getMetadataObj(store, reposId, "PhysicalTable", search, log);
            if (table == null) {
                log.error((Object)("Unable to retrieve table \"" + tableName + "\" in library \"" + libraryName + "\" in workspace server \"" + serverName + "\"."));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Either Server, library, or table name was not specified");
        }
        return table;
    }

    public static PhysicalTable getTable(MdStore store, String reposId, String serverName, String libraryName, String schemaName, String tableName, Log log) {
        PhysicalTable table = null;
        if (serverName != null && serverName.length() > 0 && libraryName != null && libraryName.length() > 0 && schemaName != null && schemaName.length() > 0 && tableName != null && tableName.length() > 0) {
            String search = "<XMLSelect search=\"*[@Name='" + ReportExImportUtil.encodedAttrValueChars(tableName) + "'][TablePackage/*[@Name='" + schemaName + "']/UsedByPackages/SASLibrary[@Name='" + libraryName + "']/DeployedComponents/*[@Name='" + serverName + "']]\"/>";
            table = (PhysicalTable)ReportExImportUtil.getMetadataObj(store, reposId, "PhysicalTable", search, log);
            if (table == null) {
                log.error((Object)("Unable to retrieve table \"" + tableName + "\" in library \"" + libraryName + "(" + schemaName + ")\" in workspace server \"" + serverName + "\"."));
            }
        } else if (log.isDebugEnabled()) {
            log.error((Object)"Either Server, library, schema, or table name was not specified");
        }
        return table;
    }

    public static String getCubeSearch(String serverName, String schemaName, String cubeName, Log log) {
        String search = null;
        if (serverName != null && serverName.length() > 0 && schemaName != null && schemaName.length() > 0 && cubeName != null && cubeName.length() > 0) {
            search = "*[@Name='" + ReportExImportUtil.encodedAttrValueChars(cubeName) + "'][AssociatedOLAPSchema/*[@Name='" + schemaName + "']/DeployedComponents/*[@Name='" + serverName + "']]";
        } else if (log.isDebugEnabled()) {
            log.error((Object)"Either Server, schema, or cube name was not specified");
        }
        return search;
    }

    public static Cube getCube(MdStore store, String reposId, String serverName, String schemaName, String cubeName, Log log) {
        String xmlSelect;
        Cube cube = null;
        String search = ReportExImportUtil.getCubeSearch(serverName, schemaName, cubeName, log);
        if (search != null && (cube = (Cube)ReportExImportUtil.getMetadataObj(store, reposId, "Cube", xmlSelect = "<XMLSelect search=\"" + search + "\"/>", log)) == null) {
            log.error((Object)("Unable to retrieve cube \"" + cubeName + "\" in schema \"" + schemaName + "\" in workspace server \"" + serverName + "\"."));
        }
        return cube;
    }

    private static CMetadata getMetadataObj(MdStore store, String reposId, String type, String options, Log log) {
        CMetadata cMetaObj;
        block8: {
            cMetaObj = null;
            if (store != null && reposId != null && reposId.length() > 0 && options != null && options.length() > 0 && type != null && type.length() > 0) {
                try {
                    int flags = 392;
                    MdOMIUtil mdUtil = store.getFactory().getOMIUtil();
                    List mObjs = mdUtil.getMetadataObjectsSubset(store, reposId, type, flags, options, false);
                    if (mObjs.size() >= 1) {
                        cMetaObj = (CMetadata)mObjs.get(0);
                    }
                    break block8;
                }
                catch (MdException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exception:", (Throwable)e);
                    }
                    break block8;
                }
                catch (RemoteException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Exception:", (Throwable)e);
                    }
                    break block8;
                }
            }
            if (log.isDebugEnabled()) {
                log.error((Object)"Invalid arguments list");
            }
        }
        return cMetaObj;
    }

    public static String[] getNamedPath(PhysicalTable table, Log log) throws MdException, RemoteException {
        String[] path = null;
        if (table != null) {
            int index;
            int size;
            SASLibrary library = null;
            String tableName = table.getName();
            RelationalSchema schema = table.getTablePackage();
            if (schema instanceof DatabaseSchema) {
                path = new String[4];
                path[3] = tableName;
                path[2] = schema.getName();
                AssociationList usedByPackages = schema.getUsedByPackages(true);
                size = usedByPackages.size();
                if (size > 0) {
                    index = 0;
                    do {
                        RelationalSchema assocMetadata;
                        if (!((assocMetadata = (RelationalSchema)usedByPackages.get(index)) instanceof SASLibrary)) continue;
                        library = (SASLibrary)assocMetadata;
                        path[1] = library.getName();
                        break;
                    } while (++index < size);
                } else {
                    path = null;
                    log.error((Object)("database schema " + schema.getName() + " does not have a parent sas library"));
                }
            } else if (schema instanceof SASLibrary) {
                path = new String[3];
                path[2] = tableName;
                library = (SASLibrary)schema;
                path[1] = library.getName();
            } else {
                path = null;
            }
            if (library != null) {
                AssociationList deployedComponents = library.getDeployedComponents(true);
                size = deployedComponents.size();
                for (index = 0; index < size; ++index) {
                    Object obj = deployedComponents.get(index);
                    if (!(obj instanceof ServerContext)) continue;
                    ServerContext serverContext = (ServerContext)obj;
                    path[0] = serverContext.getName();
                    break;
                }
                if (index == size) {
                    path = null;
                    log.error((Object)("library " + library.getName() + " does not have a parent server context"));
                }
            } else {
                path = null;
                log.error((Object)"database schema does not have a parent sas library");
            }
        }
        return path;
    }

    public static String[] getNamedPath(Cube cube, Log log) throws MdException, RemoteException {
        String[] path = null;
        if (cube != null) {
            String cubeName = cube.getName();
            OLAPSchema olapSchema = cube.getAssociatedOLAPSchema();
            if (olapSchema != null) {
                ServerContext serverContext = null;
                AssociationList deployedComponents = olapSchema.getDeployedComponents(true);
                int size = deployedComponents.size();
                for (int index = 0; index < size; ++index) {
                    Object obj = deployedComponents.get(index);
                    if (!(obj instanceof ServerContext)) continue;
                    serverContext = (ServerContext)obj;
                    break;
                }
                if (serverContext != null) {
                    path = new String[]{serverContext.getName(), olapSchema.getName(), cubeName};
                } else {
                    log.error((Object)("olap schema " + olapSchema.getName() + " does not have a parent server context"));
                }
            } else {
                log.error((Object)("cube " + cubeName + " does not have a parent schema"));
            }
        }
        return path;
    }

    private static String encodedAttrValueChars(String unencodedAttrValue) {
        String out = unencodedAttrValue;
        if (unencodedAttrValue != null) {
            int inlen = unencodedAttrValue.length();
            boolean needsEncoding = false;
            block11: for (int i = 0; i < inlen && !needsEncoding; ++i) {
                char c = unencodedAttrValue.charAt(i);
                switch (c) {
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\u000b': 
                    case '\f': 
                    case '\r': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': 
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '<': 
                    case '>': 
                    case '\\': 
                    case '\ufffe': 
                    case '\uffff': {
                        needsEncoding = true;
                        continue block11;
                    }
                }
            }
            if (needsEncoding) {
                StringBuffer buf = new StringBuffer(inlen + 25);
                block12: for (int i = 0; i < inlen; ++i) {
                    char c = unencodedAttrValue.charAt(i);
                    switch (c) {
                        case '\u0000': 
                        case '\u0001': 
                        case '\u0002': 
                        case '\u0003': 
                        case '\u0004': 
                        case '\u0005': 
                        case '\u0006': 
                        case '\u0007': 
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\u000b': 
                        case '\f': 
                        case '\r': 
                        case '\u000e': 
                        case '\u000f': 
                        case '\u0010': 
                        case '\u0011': 
                        case '\u0012': 
                        case '\u0013': 
                        case '\u0014': 
                        case '\u0015': 
                        case '\u0016': 
                        case '\u0017': 
                        case '\u0018': 
                        case '\u0019': 
                        case '\u001a': 
                        case '\u001b': 
                        case '\u001c': 
                        case '\u001d': 
                        case '\u001e': 
                        case '\u001f': 
                        case '\\': 
                        case '\ufffe': 
                        case '\uffff': {
                            buf.append("&#");
                            buf.append(Integer.toString(c));
                            buf.append(';');
                            continue block12;
                        }
                        case '\"': {
                            buf.append("&quot;");
                            continue block12;
                        }
                        case '&': {
                            buf.append("&amp;");
                            continue block12;
                        }
                        case '\'': {
                            buf.append("&apos;");
                            continue block12;
                        }
                        case '<': {
                            buf.append("&lt;");
                            continue block12;
                        }
                        case '>': {
                            buf.append("&gt;");
                            continue block12;
                        }
                        default: {
                            buf.append(c);
                        }
                    }
                }
                out = buf.toString();
            }
        }
        return out;
    }
}

