/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.RBUtil;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ReportContentPropertiesPanelTab
extends SmartWsDescriptionWizardTab {
    private static final Logger log = Logger.getLogger(ReportContentPropertiesPanelTab.class.getName());
    private EntryInterface _report;
    private Exception _error;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportContentPropertiesPanelTab(Root rootItem) {
        super(RB.getStringResource("ReportContentPropertiesPanel.PanelName.txt"));
        String name = null;
        this.setHelpProduct("report");
        this.setHelpTopic("wrs_properties_contenttab");
        try {
            name = rootItem.getName();
            UtilReportServices rs = UtilReportServices.getInstance();
            this._report = rs.getReport(rootItem);
        }
        catch (Exception e) {
            String msg = RBUtil.getStringResource("ReportContentPropertiesPanel.ConstructorFailure.fmt.txt", name);
            log.log(Level.WARNING, msg, e);
            this._error = e;
        }
        finally {
            this.layoutWidgets();
        }
    }

    protected void layoutWidgets() {
        try {
            DefaultMutableTreeNode topNode;
            this.setLayout(new GridBagLayout());
            this.setName(RB.getStringResource("ReportContentPropertiesPanel.TabName.txt"));
            String reportName = "";
            long sizeOfContent = 0L;
            long totalSizeOfContent = 0L;
            if (this._report != null) {
                reportName = this._report.getName();
                totalSizeOfContent = sizeOfContent = this._report.getSizeOfContent();
                topNode = new DefaultMutableTreeNode(this.getSizeStr(reportName, sizeOfContent));
            } else {
                topNode = new DefaultMutableTreeNode(this._error.getLocalizedMessage());
            }
            JTree tree = new JTree(topNode);
            JLabel label = new JLabel(RB.getStringResource("ReportContentPropertiesPanel.ContentHeading.txt"));
            this.add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 4, 3, 2), 0, 0));
            if (this._report != null) {
                CacheSetInterface cs = this._report.getCacheSetInterface();
                List cacheList = cs.list(null);
                for (CacheInterface cache : cacheList) {
                    String cacheName = cache.getName();
                    log.fine("cache: " + cacheName);
                    DefaultMutableTreeNode cacheNode = new DefaultMutableTreeNode(cacheName);
                    topNode.add(cacheNode);
                    List cacheItemList = cache.list(null);
                    for (CacheItemInterface cacheItem : cacheItemList) {
                        String cacheItemName = cacheItem.getName();
                        long cacheItemSize = cacheItem.getSizeOfContent();
                        totalSizeOfContent += cacheItemSize;
                        String text = this.getSizeStr(cacheItemName, cacheItemSize);
                        log.fine("cacheItem: " + text);
                        DefaultMutableTreeNode cacheItemNode = new DefaultMutableTreeNode(text);
                        cacheNode.add(cacheItemNode);
                    }
                }
            }
            tree.expandPath(new TreePath(topNode.getPath()));
            JScrollPane treeScrollPane = new JScrollPane(tree);
            this.add(treeScrollPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(8, 4, 3, 2), 0, 0));
            label = new JLabel(RB.getStringResource("ReportContentPropertiesPanel.TotalSizeOfContent.txt"));
            this.add(label, new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 4, 3, 2), 0, 0));
            label = new JLabel(this.getSizeStr(totalSizeOfContent));
            this.add(label, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 2, new Insets(8, 4, 3, 2), 0, 0));
        }
        catch (Exception e) {
            String msg = RBUtil.getStringResource("ReportContentPropertiesPanel.WidgetLayoutFailure.fmt.txt", this._report.getName());
            log.log(Level.WARNING, msg, e);
        }
    }

    private String getSizeStr(String name, long size) {
        StringBuffer buf = new StringBuffer();
        buf.append(name);
        buf.append("    (");
        this.addSize(buf, size);
        buf.append(')');
        return buf.toString();
    }

    private String getSizeStr(long size) {
        StringBuffer buf = new StringBuffer();
        this.addSize(buf, size);
        return buf.toString();
    }

    private void addSize(StringBuffer buf, long size) {
        if (size < 1000L) {
            buf.append(Long.toString(size));
            buf.append(' ');
            buf.append(RB.getStringResource("COM.Size.Bytes.txt"));
        } else if (size < 1000000L) {
            buf.append(Long.toString(size / 1000L));
            buf.append(' ');
            buf.append(RB.getStringResource("COM.Size.KB.txt"));
        } else {
            buf.append(Long.toString(size / 1000000L));
            buf.append(' ');
            buf.append(RB.getStringResource("COM.Size.MB.txt"));
        }
    }
}

