/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.report.RB;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.report.repository.EntryInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

class ReportContentHelper
extends ContentHelper {
    private static final Logger log = Logger.getLogger(ReportContentHelper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveAndUpdateContentFromPackage(InputStream inStream, OutputStream outStream, ImportOperationInterface importHandler) throws FileNotFoundException, IOException {
        BufferedInputStream iStream = new BufferedInputStream(inStream);
        try {
            boolean sbipUpdateNeeded = false;
            int prefixLength = "<?xml version=\"".length();
            int bytesRead = iStream.read(this._dataBuffer, 0, prefixLength);
            String startOfFile = null;
            if (bytesRead == prefixLength) {
                startOfFile = new String(this._dataBuffer, 0, bytesRead, "UTF-8");
                sbipUpdateNeeded = "<?xml version=\"".equals(startOfFile);
            }
            if (sbipUpdateNeeded) {
                String targetReposName = importHandler.getRepositoryName();
                List infoMaps = importHandler.getImportItems("InformationMap");
                List infoMapsOlap = importHandler.getImportItems("InformationMap.OLAP");
                List infoMapsRelational = importHandler.getImportItems("InformationMap.Relational");
                List storedProcs = importHandler.getImportItems("StoredProcess");
                List reports = importHandler.getImportItems("Report");
                ArrayList allImportedObjects = new ArrayList();
                allImportedObjects.addAll(infoMaps);
                allImportedObjects.addAll(infoMapsOlap);
                allImportedObjects.addAll(infoMapsRelational);
                allImportedObjects.addAll(storedProcs);
                allImportedObjects.addAll(reports);
                StringBuffer buf = new StringBuffer();
                buf.append(startOfFile);
                InputStreamReader isr = new InputStreamReader((InputStream)iStream, "UTF-8");
                char[] charBuf = new char[4096];
                int charsRead = isr.read(charBuf);
                while (charsRead > 0) {
                    buf.append(charBuf, 0, charsRead);
                    charsRead = isr.read(charBuf);
                }
                String endString = "\"";
                boolean notFinished = true;
                int currPtr = 0;
                while (notFinished) {
                    int p = Math.max(buf.indexOf("SBIP://", currPtr), buf.indexOf("sbip://", currPtr));
                    if (p != -1) {
                        int startOfUrl = p;
                        if (buf.charAt(startOfUrl - 1) == '>') {
                            endString = "<";
                        } else if (buf.charAt(startOfUrl - 1) == '\"') {
                            endString = "\"";
                        }
                        int closingQuote = buf.indexOf(endString, startOfUrl);
                        if (closingQuote > startOfUrl) {
                            String oldUrl = buf.substring(startOfUrl, closingQuote);
                            log.fine("old url = " + oldUrl);
                            String newUrl = PromotionUtil.getNewSBIPUrl((String)oldUrl, (String)targetReposName, allImportedObjects);
                            buf.replace(startOfUrl, closingQuote, newUrl);
                            currPtr = p + newUrl.length();
                            continue;
                        }
                        log.warning("No closing quote found!");
                        currPtr += 7;
                        continue;
                    }
                    notFinished = false;
                }
                OutputStreamWriter osw = new OutputStreamWriter(outStream, "UTF-8");
                String updatedContent = buf.toString();
                osw.write(updatedContent);
                osw.flush();
            } else {
                while (bytesRead > 0) {
                    outStream.write(this._dataBuffer, 0, bytesRead);
                    bytesRead = iStream.read(this._dataBuffer);
                }
            }
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException sbipUpdateNeeded) {}
            }
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Failed on repository write/close", e);
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retrieveUpdateContentFromPackage(EntryInterface report, ImportOperationInterface importHandler, ServerInterface server, PropertyMap map) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        String tempFile = null;
        String targetReposName = importHandler.getRepositoryName();
        List infoMaps = importHandler.getImportItems("InformationMap");
        List infoMapsOlap = importHandler.getImportItems("InformationMap.OLAP");
        List infoMapsRelational = importHandler.getImportItems("InformationMap.Relational");
        List storedProcs = importHandler.getImportItems("StoredProcess");
        List reports = importHandler.getImportItems("Report");
        List reportImages = importHandler.getImportItems("Report.Image");
        List reportComponents = importHandler.getImportItems("Report.Component");
        ArrayList allImportedObjects = new ArrayList();
        allImportedObjects.addAll(infoMaps);
        allImportedObjects.addAll(infoMapsOlap);
        allImportedObjects.addAll(infoMapsRelational);
        allImportedObjects.addAll(storedProcs);
        allImportedObjects.addAll(reports);
        allImportedObjects.addAll(reportImages);
        allImportedObjects.addAll(reportComponents);
        try {
            int len;
            is = report.getInputStream();
            XMLReader r = XMLReaderFactory.createXMLReader();
            WriteReportItems cHandler = new WriteReportItems(targetReposName, allImportedObjects, importHandler, server, map);
            r.setContentHandler(cHandler);
            r.setErrorHandler(new QuietErrorHandler());
            r.parse(new InputSource(is));
            is.close();
            tempFile = cHandler.getTempFileName();
            is = new FileInputStream(tempFile);
            os = report.getOutputStream(false);
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) != -1) {
                os.write(buf, 0, len);
            }
            is.close();
            os.close();
            String string = tempFile;
            return string;
        }
        catch (SAXParseException e) {
            String msg = "[" + report.getName() + "] " + e.getMessage() + " @line#" + e.getLineNumber();
            log.log(Level.FINE, " " + msg);
        }
        catch (Exception e) {
            String msg = "[" + report.getName() + "] " + e.getMessage();
            log.log(Level.WARNING, " " + msg);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    log.log(Level.SEVERE, "Failed on repository write/close", e);
                    throw e;
                }
            }
        }
        return tempFile;
    }

    class WriteReportItems
    implements ContentHandler {
        private List urlList = new ArrayList();
        private Map<String, String> prefixes = new HashMap<String, String>();
        private boolean _isTextNode = false;
        private Writer out;
        private File tempFile;
        private PropertyMap localizeMap;
        private ServerInterface _si;
        private ImportOperationInterface _importHandler;
        private String _targetReposName;
        private List _allImportedObjects;
        private int i = 1;
        private boolean sasReportVerify;
        private String _xpath = "";
        private String _xpathEZ = "";
        private Stack stack = new Stack();
        private Map env = new HashMap();
        private final String[] textNodes = new String[]{"ActionValue", "Caption", "ContextValue", "CSV", "Label", "Note", "Property", "Span", "URLValue", "Value", "ViewElement"};
        private final String[] textMultipleNodes = new String[]{"Graph/Titles/Title", "Graph/Footnotes/Footnote", "Formats/Mapping/Label"};
        private final String[] nameAttrs = new String[]{"ActionValue", "Caption", "Column", "ContextValue", "CSV", "Label", "Note", "PromptValue", "Property", "RowGroup", "SASReport", "Span", "URLValue", "Value", "ViewElement"};
        private final String[] labelAttrs = new String[]{"AbstractAction", "ByGroupSection", "Container", "DataItem", "DataItemReference", "DataItemReferenceUse", "DataItemUse", "Dimension", "Hierarchy", "IQData", "Level", "Member", "Property", "SASProcessContainer", "SASProcessSection", "Scheme", "Section", "Variable"};
        private final String[] locationAttrs = new String[]{"InformationMap/@absolutePathLocation", "InformationMap/@location", "Image/@file", "Graph/@altImage", "SASProcessSection/@file", "SASProcessContainer/@file", "BusinessModelReferenceInformation/@location"};
        private static final String SBIP_PREFIX = "SBIP://";
        private static final String EMPTY_STRING = "";
        private static final String SBIPURL_PATH_SEPARATOR = "/";
        private static final String SBIP_PREFIX_ABSOLUTE = "SBIP://.";
        private boolean _collectText = true;
        private boolean _collectSubElementText = false;
        private boolean _spanMode = false;
        private boolean _spanModePermissable = false;
        private int _spanDepth = 0;
        private int _tokenCount = 0;
        private Map _spanSubElementMap = new LinkedHashMap();
        private Map _spanSubElementMap2 = new LinkedHashMap();
        private final String span = "Span";
        private StringBuilder spanBuffer;
        private StringBuilder subElementBuffer;
        CharArrayWriter text = new CharArrayWriter();
        CharArrayWriter textSubElement = new CharArrayWriter();
        private static final String CDATA_START = "<![CDATA[";
        private static final String CDATA_END = "]]>";
        private static final String CDATA_END_ESCAPED = "]]&gt;";

        public WriteReportItems(String targetReposName, List allImportedObjects, ImportOperationInterface importHandler, ServerInterface server, PropertyMap map) {
            this.localizeMap = map;
            String[] dynamicSubNodes = new String[]{"[NB-1]", "[PV-1]", "[PN-1]", "[RV-1]", "[SP-1]", "[EX-1]", "[DT-1]"};
            if (!this.localizeMap.isEmpty()) {
                String _theURL = EMPTY_STRING;
                Iterator loIter = this.localizeMap.getPropertyIterator();
                block2: while (loIter.hasNext()) {
                    _theURL = this.localizeMap.getProperty(loIter.next().toString());
                    for (int j = 0; j < dynamicSubNodes.length; ++j) {
                        if (!_theURL.contains(dynamicSubNodes[j])) continue;
                        this._spanModePermissable = true;
                        break block2;
                    }
                }
            }
            this._si = server;
            this._importHandler = importHandler;
            this._targetReposName = targetReposName;
            this._allImportedObjects = allImportedObjects;
            this._spanSubElementMap.put("PromptValue", "PV");
            this._spanSubElementMap.put("PageNumber", "PN");
            this._spanSubElementMap.put("ReportValue", "RV");
            this._spanSubElementMap.put("NBSP", "NB");
            this._spanSubElementMap.put("Span", "SP");
            this._spanSubElementMap.put("Expression", "EX");
            this._spanSubElementMap.put("Date", "DT");
            try {
                this.tempFile = File.createTempFile("Sax", ".xml");
                this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.tempFile), "UTF-8"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public String getTempFileName() {
            return this.tempFile.getAbsolutePath();
        }

        public void setListOfReportUrls(List reportUrls) throws IOException {
            this.urlList = reportUrls;
        }

        private void completeTextNode() throws SAXException {
            try {
                if (!this._spanModePermissable) {
                    this.out.write(this.XMLESCAPE(this.text.toString()));
                } else {
                    this.out.write(this.text.toString());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.text.reset();
        }

        private void completeSubElementTextNode() throws SAXException {
            this.textSubElement.reset();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this._collectText) {
                this.text.write(ch, start, length);
            }
            if (this._collectSubElementText) {
                this.textSubElement.write(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) {
            this.text.write(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.completeTextNode();
            try {
                this.out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String _itemValue = this.text.toString();
            if (this._spanMode) {
                if (qName.equals("Span")) {
                    --this._spanDepth;
                    if (this._spanDepth < 0) {
                        this._spanMode = false;
                        this._collectText = true;
                        try {
                            this.out.write(this.spanBuffer.toString());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        this.spanBuffer.append(this.text.toString());
                    }
                } else {
                    if (this.textSubElement.size() > 0) {
                        this.subElementBuffer.append(this.textSubElement.toString());
                    }
                    this.subElementBuffer.append("</" + qName + ">");
                    this.completeSubElementTextNode();
                    String elementShortName = this._spanSubElementMap.get(qName).toString();
                    if (elementShortName == null) {
                        elementShortName = qName;
                    }
                    String token = "[" + elementShortName + "-" + this._tokenCount + "]";
                    this._spanSubElementMap2.put(token, this.subElementBuffer.toString());
                    this.text.append(token);
                    this._collectText = true;
                }
            }
            if (!this._spanMode) {
                if (this._isTextNode) {
                    try {
                        if (this.localizeMap != null) {
                            _itemValue = this.localizeValue(this._xpath, _itemValue);
                        }
                        if (this._xpathEZ.endsWith("URLValue")) {
                            _itemValue = this.locationValue(_itemValue);
                        }
                        if (_itemValue != null) {
                            this.text.reset();
                            this.text.write(_itemValue);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    this._isTextNode = false;
                }
                try {
                    this.completeTextNode();
                    this.out.write("</" + qName + ">");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            int p = this._xpath.lastIndexOf(SBIPURL_PATH_SEPARATOR);
            this._xpath = this._xpath.substring(0, p);
            int pEZ = this._xpathEZ.lastIndexOf(SBIPURL_PATH_SEPARATOR);
            this._xpathEZ = this._xpathEZ.substring(0, pEZ);
            this.env = (Map)this.stack.pop();
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.completeTextNode();
        }

        @Override
        public void startDocument() throws SAXException {
            try {
                this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            }
            catch (IOException e) {
                throw new UnexpectedLocalizationException((Throwable)e);
            }
            this.completeTextNode();
        }

        private String locationValue(String url) {
            if ((url.toUpperCase().startsWith(SBIP_PREFIX) || url.toUpperCase().startsWith(SBIPURL_PATH_SEPARATOR)) && (url = PromotionUtil.getNewSBIPUrl((String)url, (String)this._targetReposName, (List)this._allImportedObjects)).toUpperCase().startsWith(SBIP_PREFIX) && !url.toUpperCase().startsWith(SBIP_PREFIX_ABSOLUTE)) {
                try {
                    PathUrl pathUrl = new PathUrl(url);
                    url = PathUrl.newPathUrlFromExistingUrl((ServerInterface)this._si, (PathUrl)pathUrl).toString();
                }
                catch (ServiceException e) {
                    e.printStackTrace();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return url;
        }

        private String localizeValue(String _xpath, String itemValue) {
            String localizeValue = itemValue;
            String _itemValue = this.localizeMap.getProperty(_xpath);
            if (_itemValue != null) {
                _itemValue = this.XMLESCAPE(_itemValue);
                try {
                    for (Map.Entry shortElementTag : this._spanSubElementMap2.entrySet()) {
                        _itemValue = _itemValue.replace(shortElementTag.getKey().toString(), shortElementTag.getValue().toString());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                localizeValue = _itemValue;
            }
            return localizeValue;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            this._xpath = this._xpath + SBIPURL_PATH_SEPARATOR + qName;
            this._xpathEZ = this._xpathEZ + SBIPURL_PATH_SEPARATOR + qName;
            int ord = 1;
            if (this.env.containsKey(qName)) {
                ord = (Integer)this.env.get(qName);
                this.env.put(qName, new Integer(++ord));
            } else {
                this.env.put(qName, new Integer(ord));
            }
            if (!this.stack.empty()) {
                this._xpath = this._xpath + "[" + ord + "]";
            }
            this.stack.add(this.env);
            this.env = new HashMap();
            this.env.put(qName, new Integer(1));
            if (qName.equals("Span") && !this._spanMode && this._spanModePermissable) {
                this.completeTextNode();
                this.spanBuffer = new StringBuilder(EMPTY_STRING);
                this.spanBuffer.append("<" + qName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.spanBuffer.append(" ");
                    this.spanBuffer.append(atts.getQName(i) + "=\"");
                    String itemValue = atts.getValue(atts.getQName(i));
                    this.spanBuffer.append(this.XMLESCAPE(itemValue) + "\"");
                }
                this.spanBuffer.append(">");
                this._tokenCount = 0;
                this._spanDepth = 0;
                this._spanMode = true;
                this._isTextNode = true;
                this._collectText = true;
            } else if (qName.equals("Span") && this._spanMode) {
                ++this._spanDepth;
                this._collectText = true;
            } else if (!qName.equals("Span") && this._spanMode) {
                ++this._tokenCount;
                this._collectText = false;
                this.completeSubElementTextNode();
                this._collectSubElementText = true;
                this.subElementBuffer = new StringBuilder(EMPTY_STRING);
                this.subElementBuffer.append("<" + qName);
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.subElementBuffer.append(" ");
                    this.subElementBuffer.append(atts.getQName(i) + "=\"");
                    String itemValue = atts.getValue(atts.getQName(i));
                    this.subElementBuffer.append(this.XMLESCAPE(itemValue) + "\"");
                }
                this.subElementBuffer.append(">");
            } else {
                this.completeTextNode();
                this._collectText = true;
                if (!this.sasReportVerify) {
                    this.sasReportVerify = true;
                    if (!qName.equalsIgnoreCase("SASReport")) {
                        throw new SAXException(RB.getStringResource("ReportContentHelper.sasreportNotFound.txt"));
                    }
                }
                this._isTextNode = false;
                try {
                    int i;
                    this.out.write("<" + qName);
                    for (Map.Entry<String, String> me : this.prefixes.entrySet()) {
                        this.out.write(" xmlns" + (me.getKey().length() > 0 ? ":" + me.getKey() : EMPTY_STRING) + "=\"" + me.getValue() + "\"");
                    }
                    this.prefixes.clear();
                    if (qName.length() > 0) {
                        for (int i2 = 0; i2 < this.textNodes.length; ++i2) {
                            if (!qName.equalsIgnoreCase(this.textNodes[i2])) continue;
                            this._isTextNode = true;
                            break;
                        }
                    }
                    for (i = 0; i < this.textMultipleNodes.length; ++i) {
                        if (!this._xpathEZ.endsWith(this.textMultipleNodes[i])) continue;
                        this._isTextNode = true;
                    }
                    for (i = 0; i < atts.getLength(); ++i) {
                        this.out.write(" ");
                        this.out.write(atts.getQName(i) + "=\"");
                        String itemValue = atts.getValue(atts.getQName(i));
                        if (!this.localizeMap.isEmpty()) {
                            itemValue = this.localizeValue(this._xpath + "/@" + atts.getQName(i), itemValue);
                        }
                        String _xpathEZWithAttr = this._xpathEZ + "/@" + atts.getQName(i);
                        for (int k = 0; k < this.locationAttrs.length; ++k) {
                            if (!_xpathEZWithAttr.endsWith(this.locationAttrs[k])) continue;
                            itemValue = this.locationValue(itemValue);
                            break;
                        }
                        this.out.write(this.XMLESCAPE(itemValue) + "\"");
                    }
                    this.out.write(">");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.completeTextNode();
            this.prefixes.put(prefix, uri);
        }

        public String XMLESCAPE(String text) {
            if (text == null) {
                return EMPTY_STRING;
            }
            if (text.startsWith(CDATA_START) && text.endsWith(CDATA_END)) {
                return text;
            }
            text = text.replaceAll("&", "&amp;");
            text = text.replaceAll("\"", "&quot;");
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
            return text;
        }
    }

    class QuietErrorHandler
    implements ErrorHandler {
        QuietErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

