/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.report.ActionCreateJobEntry;
import com.sas.metadata.logical.report.ActionExportReportContent;
import com.sas.metadata.logical.report.ActionImportReportContent;
import com.sas.metadata.logical.report.ActionTestContent;
import com.sas.metadata.logical.report.ActionTestFolder;
import com.sas.metadata.logical.report.ActionTestReport;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.ReportContentPropertiesPanelTab;
import com.sas.metadata.logical.report.ReportGeneralPropertyTab;
import com.sas.metadata.logical.report.ReportLogicalObject;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.wadmin.visuals.JOMANotesTab;
import com.sas.wadmin.visuals.WAExtAttrPropertyTab;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ObjectFactory
implements ObjectFactoryInterface {
    private static final Logger log = Logger.getLogger(ObjectFactory.class.getName());
    private String _options;
    protected TypeInterface _type;

    protected ObjectFactory(TypeInterface type) {
        this._type = type;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        if (!this.isReport(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        ReportLogicalObject report = new ReportLogicalObject((Transformation)root, this._type, Factory.getInstance());
        return report;
    }

    public LogicalObjectInterface createItemFromMetadataObject1(Root root) throws RemoteException {
        log.fine("entering");
        if (!this.isReport(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        ReportLogicalObject report = new ReportLogicalObject((Transformation)root, this._type, Factory.getInstance());
        return report;
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root complexRpt, Config config) throws MdException, RemoteException {
        log.fine("entering");
        if (!this.isReport(complexRpt)) {
            throw new IllegalArgumentException("Internal logic error: " + complexRpt.toString() + " is not an object of interest.");
        }
        if (config == null) {
            config = new Config();
        }
        if (config.getInitValue(ConfigGeneralPanel.HELP_PRODUCT, null) == null) {
            config.setInitValue(ConfigGeneralPanel.HELP_PRODUCT, (Object)"bimanager");
        }
        if (config.getInitValue(ConfigGeneralPanel.HELP_TOPIC, null) == null) {
            config.setInitValue(ConfigGeneralPanel.HELP_TOPIC, (Object)"bim_generaltab");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            Transformation transformation = (Transformation)complexRpt;
            Tree tree = (Tree)transformation.getTrees().get(0);
            ReportGeneralPropertyTab generalTab = new ReportGeneralPropertyTab((Root)transformation, tree, 1, this._type, config, transformation);
            list.add((Object)generalTab);
            ReportContentPropertiesPanelTab contentTab = new ReportContentPropertiesPanelTab((Root)transformation);
            list.add((Object)contentTab);
            JOMANotesTab notesTab = new JOMANotesTab((Root)transformation);
            notesTab.setName(RB.getStringResource("ObjectFactory.NotesTabName.txt"));
            list.add(notesTab);
            WAExtAttrPropertyTab extAttrTab = new WAExtAttrPropertyTab((CMetadata)transformation);
            extAttrTab.setName(RB.getStringResource("ObjectFactory.ExtAttrTabName.txt"));
            list.add(extAttrTab);
        }
        catch (RemoteException e) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
        }
        return list;
    }

    public Factory getFactory() {
        return Factory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String reposID) throws MdException {
        log.fine("entering");
        if (reposID == null) {
            throw new IllegalArgumentException("logic error: no reposid specified");
        }
        if (this._options == null) {
            this._options = "<XMLSELECT Search=\"*[@TransformRole='Report']\"/><Templates><Transformation " + this.getFactory().getTemplateFormOfRequiredAndNeededAttributes(this._type) + "/></Templates>";
        }
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        MdObjectStore myStore = null;
        try {
            myStore = Workspace.getMdFactory().createObjectStore();
            List reports = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)myStore, reposID, "Transformation", 388, this._options);
            for (Transformation trans : reports) {
                list.add(this.createItemFromMetadataObject((Root)trans));
            }
        }
        catch (RemoteException e) {
            new MdException((Throwable)e);
        }
        finally {
            try {
                if (myStore != null) {
                    myStore.dispose();
                }
            }
            catch (RemoteException e) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)e);
            }
        }
        return list;
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) {
        FolderInterface fi;
        log.finest("logicalObject = " + logicalObject + ", root = " + root);
        Frame frame = this.getFactory().getFrame();
        ArrayList<AbstractAction> actionList = new ArrayList<AbstractAction>();
        Action[] array = new Action[1];
        if (logicalObject instanceof ReportLogicalObject) {
            actionList.add(new ActionExportReportContent(frame, logicalObject, root, this, config));
            if (log.isLoggable(Level.FINE)) {
                actionList.add(new ActionTestReport(frame, logicalObject, root, this, config));
            }
        } else if (logicalObject instanceof FolderInterface && !(fi = (FolderInterface)logicalObject).isRoot() && fi.isContentMapped() && this._type.getPublicType().equals("Report")) {
            try {
                actionList.add(new ActionImportReportContent(frame, logicalObject, root, this, config));
                array[0] = new ActionImportReportContent(frame, logicalObject, root, this, config);
                array[0].setEnabled(((FolderInterface)logicalObject).isCreateChildAllowed());
                return array;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            catch (LogicalTypeException e) {
                e.printStackTrace();
            }
            if (log.isLoggable(Level.FINE)) {
                actionList.add(new ActionTestContent(frame, logicalObject, root, this, config));
                actionList.add(new ActionTestFolder(frame, logicalObject, root, this, config));
            }
        }
        return actionList.toArray(new Action[actionList.size()]);
    }

    public Action[] getActions(LogicalObjectInterface[] logicalObjects, Root[] roots, Config config) {
        if (log.isLoggable(Level.FINEST)) {
            log.finest("logicalObject count = " + logicalObjects.length);
            for (int i = 0; i < logicalObjects.length; ++i) {
                log.finest("logicalObjects[" + i + "] = " + logicalObjects[i]);
            }
        }
        ArrayList<ActionCreateJobEntry> actionList = new ArrayList<ActionCreateJobEntry>();
        if (this.allLogicalObjectsAreReports(logicalObjects) && this._type.getPublicType().equals("Report")) {
            Frame frame = this.getFactory().getFrame();
            actionList.add(new ActionCreateJobEntry(frame, logicalObjects, roots, this, config));
        }
        return actionList.toArray(new Action[actionList.size()]);
    }

    private boolean allLogicalObjectsAreReports(LogicalObjectInterface[] logicalObjects) {
        for (int i = 0; i < logicalObjects.length; ++i) {
            if (!(logicalObjects[i] instanceof ReportLogicalObject)) {
                return false;
            }
            if (logicalObjects[i].getTypeInterface().getPublicType().equals("Report")) continue;
            return false;
        }
        return true;
    }

    private boolean allLogicalObjectsAreReports(LogicalObjectInterface logicalObject) {
        if (!(logicalObject instanceof ReportLogicalObject)) {
            return false;
        }
        return logicalObject.getName().indexOf(".srx") != -1;
    }

    private boolean isReport(Root root) throws RemoteException {
        boolean isReport = false;
        if (root instanceof Transformation) {
            Transformation trans = (Transformation)root;
            String publicType = trans.getPublicType();
            if (publicType.startsWith("Report")) {
                isReport = true;
            } else if (trans.getTransformRole().equalsIgnoreCase("Report")) {
                isReport = true;
            }
        }
        return isReport;
    }
}

