/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.Factory;
import com.sas.report.repository.DirectoryInterface;
import com.sas.report.repository.OMRID;
import com.sas.services.information.PluginLoader;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class DependentTypesHelper {
    private static final String PROPS_FILE = "/com/sas/metadata/logical/report/dependentTypes.properties";
    private static final String PLFT_GROUP = "sas.services.information.types";
    private static final String BID_PLUGIN = "bidlogtypes";
    private static Properties props = null;
    private static DependentTypesHelper self = new DependentTypesHelper();
    private static Map fileFilterCreatorImplMap = null;
    private static Map entryCreatorImplMap = null;
    private static Map typeCreatorImplMap = null;
    private static Map entryInstantiatorClassesMap = null;
    private static Map typeInstantiatorClassesMap = null;
    private static Map createTypeMethodsMap = null;
    private static Map getFileFilterMethodsMap = null;
    private static Map tryCreateEntryMethodsMap = null;
    private static Map tryCreateEntryInstantiatorMethodsMap = null;

    private static Class getClass(String className) {
        Class<?> clazz = null;
        try {
            clazz = PluginLoader.getInstance((String)PLFT_GROUP).loadClass(BID_PLUGIN, className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = Class.forName(className);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return clazz;
    }

    private DependentTypesHelper() {
    }

    public static Map getFileFilterCreatorMap() {
        return fileFilterCreatorImplMap;
    }

    public static Map getEntryCreatorMap() {
        return entryCreatorImplMap;
    }

    public static Map getTypeCreatorMap() {
        return typeCreatorImplMap;
    }

    public static Map getEntryInstantiatorClasses() {
        return entryInstantiatorClassesMap;
    }

    public static Map getTypeInstantiatorClasses() {
        return typeInstantiatorClassesMap;
    }

    public static Method getCreateTypeMethod(String group) {
        return (Method)createTypeMethodsMap.get(group);
    }

    public static Method getFileFilterMethod(String group) {
        return (Method)getFileFilterMethodsMap.get(group);
    }

    public static Method getCreateEntryMethod(String group) {
        return (Method)tryCreateEntryMethodsMap.get(group);
    }

    public static Method getCreateEntryInstantiatorMethod(String group) {
        return (Method)tryCreateEntryInstantiatorMethodsMap.get(group);
    }

    static {
        InputStream inStream = DependentTypesHelper.class.getResourceAsStream(PROPS_FILE);
        if (inStream != null) {
            props = new Properties();
            try {
                props.load(inStream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    Method method;
                    Class clazz2;
                    String group;
                    String prop = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (prop.endsWith(".EntryInstantiatorClass")) {
                        group = prop.substring(0, prop.indexOf(46));
                        if (entryInstantiatorClassesMap == null) {
                            entryInstantiatorClassesMap = new HashMap();
                        }
                        try {
                            clazz2 = DependentTypesHelper.getClass(value);
                            if (clazz2 == null) continue;
                            entryInstantiatorClassesMap.put(group, clazz2);
                            method = clazz2.getMethod("getFileFilter", null);
                            if (method != null) {
                                if (getFileFilterMethodsMap == null) {
                                    getFileFilterMethodsMap = new HashMap();
                                }
                                getFileFilterMethodsMap.put(group, method);
                            }
                            if ((method = clazz2.getMethod("tryCreateEntry", OMRID.class, DirectoryInterface.class, File.class, String.class)) != null) {
                                if (tryCreateEntryMethodsMap == null) {
                                    tryCreateEntryMethodsMap = new HashMap();
                                }
                                tryCreateEntryMethodsMap.put(group, method);
                            }
                            if ((method = clazz2.getMethod("tryCreateEntryInstantiator", OMRID.class, String.class)) == null) continue;
                            if (tryCreateEntryInstantiatorMethodsMap == null) {
                                tryCreateEntryInstantiatorMethodsMap = new HashMap();
                            }
                            tryCreateEntryInstantiatorMethodsMap.put(group, method);
                        }
                        catch (Exception clazz2) {}
                        continue;
                    }
                    if (prop.endsWith(".TypeInstantiatorClass")) {
                        group = prop.substring(0, prop.indexOf(46));
                        if (typeInstantiatorClassesMap == null) {
                            typeInstantiatorClassesMap = new HashMap();
                        }
                        try {
                            clazz2 = DependentTypesHelper.getClass(value);
                            if (clazz2 == null) continue;
                            typeInstantiatorClassesMap.put(group, clazz2);
                            method = clazz2.getMethod("tryCreateType", Factory.class, TypeDescriptorInterface.class, String.class);
                            if (method == null) continue;
                            if (createTypeMethodsMap == null) {
                                createTypeMethodsMap = new HashMap();
                            }
                            createTypeMethodsMap.put(group, method);
                        }
                        catch (Exception clazz3) {}
                        continue;
                    }
                    if (prop.endsWith(".FileFilterCreatorClass")) {
                        group = prop.substring(0, prop.indexOf(46));
                        if (fileFilterCreatorImplMap == null) {
                            fileFilterCreatorImplMap = new HashMap();
                        }
                        try {
                            clazz2 = DependentTypesHelper.getClass(value);
                            if (clazz2 == null) continue;
                            fileFilterCreatorImplMap.put(group, clazz2.newInstance());
                        }
                        catch (Exception clazz4) {}
                        continue;
                    }
                    if (prop.endsWith(".EntryCreatorClass")) {
                        group = prop.substring(0, prop.indexOf(46));
                        if (entryCreatorImplMap == null) {
                            entryCreatorImplMap = new HashMap();
                        }
                        try {
                            clazz2 = DependentTypesHelper.getClass(value);
                            if (clazz2 == null) continue;
                            entryCreatorImplMap.put(group, clazz2.newInstance());
                        }
                        catch (Exception clazz5) {}
                        continue;
                    }
                    if (!prop.endsWith(".TypeCreatorClass")) continue;
                    group = prop.substring(0, prop.indexOf(46));
                    if (typeCreatorImplMap == null) {
                        typeCreatorImplMap = new HashMap();
                    }
                    try {
                        clazz2 = DependentTypesHelper.getClass(value);
                        if (clazz2 == null) continue;
                        typeCreatorImplMap.put(group, clazz2.newInstance());
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

