/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.report.ObjectFactory;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.AdapterFactory;
import com.sas.report.repository.DirectoryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionTestFolder
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ActionTestFolder.class.getName());
    private Frame _frame;
    private Root _root;

    public ActionTestFolder(Frame frame, LogicalObjectInterface logicalObj, Root root, ObjectFactory objectFactory, Config config) {
        log.fine("entering");
        this._frame = frame;
        this._root = root;
        this.putValue("Name", "Smart Object Test for Folders (development only)");
        String strMneumonic = null;
        if (strMneumonic != null) {
            this.putValue("MnemonicKey", new Integer(strMneumonic.charAt(0)));
        }
        this.putValue("ShortDescription", "Attempt to access RM API via Smart Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        log.fine("event = " + event);
        this._frame.setCursor(Cursor.getPredefinedCursor(3));
        try {
            log.info("################## BEGIN TEST CODE ##################");
            log.info("Step 1: Test services and verify that we can get a session...");
            SessionContextInterface session = UtilPlatformServices.getSessionContext();
            if (session == null) {
                throw new NullPointerException("UtilPlatformServices.getSessionContext() returned null!");
            }
            log.info("Step 2: Obtaining Information Services object for this node...");
            log.info("metadata object = " + this._root);
            MetadataInterface smartObj = UtilPlatformServices.getSmartObject((Root)this._root);
            log.info("fetch returned " + smartObj);
            log.info("Step 3: Obtaining service object from smart object...");
            Object serviceObject = smartObj.newServiceObject();
            if (serviceObject == null) {
                throw new IllegalStateException("No service object exists for '" + smartObj + "'");
            }
            log.info("Step 4: Adapt the smart object to a bonafide Report Management object");
            DirectoryInterface dir = AdapterFactory.adaptDirectory((Object)serviceObject);
            log.info("RM API dir object = " + dir);
            log.info("dir.getName() = " + dir.getName());
            log.info("dir.getAttributes()...");
            StringBuffer buf = new StringBuffer();
            buf.append("\n\n");
            Iterator itor = dir.getAttributes();
            while (itor.hasNext()) {
                Map.Entry entry = (Map.Entry)itor.next();
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                String keyAndValue = "   " + key + " = " + value;
                log.info(keyAndValue);
                buf.append(keyAndValue);
                buf.append('\n');
            }
            log.info("################## TEST COMPLETE! ##################");
            JOptionPane.showMessageDialog(this._frame, "It worked!\n" + dir + buf.toString(), "Repository Smart Object Test", 1);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "TEST FAILED: ", e);
            StringWriter sWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(sWriter));
            JOptionPane.showMessageDialog(this._frame, "Failure:\n" + sWriter.toString(), "Repository Smart Object Test", 0);
        }
        finally {
            this._frame.setCursor(Cursor.getPredefinedCursor(0));
            log.info("################## END TEST CODE ##################");
        }
    }
}

