/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.prompts;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.prompts.GeneralPromptDefinitionTabPanel;
import com.sas.metadata.logical.prompts.GeneralTabPanel;
import com.sas.metadata.logical.prompts.PromptGroupTabPanel;
import com.sas.metadata.logical.prompts.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.Prompt;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.information.metadata.prompt.OMRPromptDefinitionInterface;
import com.sas.services.information.metadata.prompt.OMRPromptGroupInterface;
import com.sas.services.information.metadata.prompt.PromptsPersistUtil;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public final class PromptTypesUtil {
    private static final String RB_KEY = "PromptTypesUtil.";
    static String[] REQUIRED_ATTRIBUTES = new String[]{"UsageVersion"};

    private PromptTypesUtil() {
    }

    public static BaseOMRPromptInterface getPromptFromLogicalObject(SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        BaseOMRPromptInterface prompt = (BaseOMRPromptInterface)UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)logicalObject);
        if (prompt == null) {
            throw new IllegalStateException(RB.getStringResource("PromptTypesUtil.noSmartObject.fmt.log", logicalObject.getName()));
        }
        return prompt;
    }

    public static PromptDefinitionInterface getPromptDefinitionModelFromLogicalObject(SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        PromptDefinitionInterface retVal = null;
        BaseOMRPromptInterface prompt = PromptTypesUtil.getPromptFromLogicalObject(logicalObject);
        if (prompt instanceof OMRPromptDefinitionInterface) {
            retVal = ((OMRPromptDefinitionInterface)prompt).getPromptDefinition();
        }
        return retVal;
    }

    public static PromptDefinitionInterface getPromptDefinitionModelFromObject(Prompt prompt) throws RemoteException, MdException {
        return PromptsPersistUtil.getPromptDefinitionFromPromptObject((Prompt)prompt, (SessionContextInterface)UtilPlatformServices.getSessionContext());
    }

    public static PromptGroupInterface getPromptGroupModelFromObject(PromptGroup promptGroup) throws RemoteException, MdException {
        return PromptsPersistUtil.getPromptGroupFromPromptGroupObject((PromptGroup)promptGroup, (SessionContextInterface)UtilPlatformServices.getSessionContext());
    }

    public static PromptGroupInterface getPromptGroupModelFromLogicalObject(SimpleLogicalObjectInterface logicalObject) throws ServiceException, RemoteException {
        PromptGroupInterface retVal = null;
        BaseOMRPromptInterface prompt = PromptTypesUtil.getPromptFromLogicalObject(logicalObject);
        if (prompt instanceof OMRPromptGroupInterface) {
            retVal = ((OMRPromptGroupInterface)prompt).getPromptGroup();
        }
        return retVal;
    }

    public static BaseOMRPromptInterface updateLogicalObjectWithPromptDefinition(SimpleLogicalObjectInterface logicalObject, PromptDefinitionInterface definition) throws ServiceException, RemoteException {
        return PromptTypesUtil.updateLogicalObjectWithPromptDefinition(logicalObject, definition, null);
    }

    public static BaseOMRPromptInterface updateLogicalObjectWithPromptDefinition(SimpleLogicalObjectInterface logicalObject, PromptDefinitionInterface definition, String newName) throws ServiceException, RemoteException {
        return PromptTypesUtil.updateLogicalObjectWithPromptDefinition(logicalObject, definition, newName, null);
    }

    public static BaseOMRPromptInterface updateLogicalObjectWithPromptDefinition(SimpleLogicalObjectInterface logicalObject, PromptDefinitionInterface definition, String newName, String newDescription) throws ServiceException, RemoteException {
        BaseOMRPromptInterface prompt = PromptTypesUtil.getPromptFromLogicalObject(logicalObject);
        if (prompt instanceof OMRPromptDefinitionInterface) {
            if (newName != null) {
                prompt.setName(newName);
            }
            if (newDescription != null) {
                prompt.setDescription(newDescription);
            }
            prompt = PromptsPersistUtil.updateDefinitionSmartObject((PromptDefinitionInterface)definition, (UserContextInterface)UtilPlatformServices.getUserContext(), (OMRPromptDefinitionInterface)((OMRPromptDefinitionInterface)prompt), null);
            prompt.update();
        }
        return prompt;
    }

    public static void updateObjectWithPromptDefinition(Root root, PromptDefinitionInterface definition, MdFactory factory) throws RemoteException, MdException {
        PromptsPersistUtil.setPromptDefinitionOnOMRObject((PromptDefinitionInterface)definition, (Root)root, (SessionContextInterface)UtilPlatformServices.getSessionContext(), (MdFactory)factory);
    }

    public static void updatePromptWithPromptDefinition(Prompt prompt, PromptDefinitionInterface definition, MdFactory factory) throws RemoteException, MdException {
        PromptsPersistUtil.updatePromptWithDefinition((Prompt)prompt, (PromptDefinitionInterface)definition, (SessionContextInterface)UtilPlatformServices.getSessionContext(), (MdFactory)factory);
    }

    public static void updatePromptGroupWithPromptGroup(PromptGroup promptGroup, PromptGroupInterface group, MdFactory factory) throws RemoteException, MdException {
        PromptsPersistUtil.updatePromptGroupWithGroup((PromptGroup)promptGroup, (PromptGroupInterface)group, (SessionContextInterface)UtilPlatformServices.getSessionContext(), (MdFactory)factory);
    }

    public static BaseOMRPromptInterface updateLogicalObjectWithPromptGroup(SimpleLogicalObjectInterface logicalObject, PromptGroupInterface group) throws ServiceException, RemoteException {
        BaseOMRPromptInterface prompt = PromptTypesUtil.getPromptFromLogicalObject(logicalObject);
        if (prompt instanceof OMRPromptGroupInterface) {
            prompt = PromptsPersistUtil.updateGroupSmartObject((PromptGroupInterface)group, (UserContextInterface)UtilPlatformServices.getUserContext(), (OMRPromptGroupInterface)((OMRPromptGroupInterface)prompt), null);
            prompt.update();
        }
        return prompt;
    }

    static List getPropertyTabs(LogicalObjectInterface logicalObject, Root root, Config config, TypeInterface type) throws MdException, RemoteException {
        if (config == null) {
            config = new Config();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        if (null != logicalObject && null != root) {
            TypeInterface typeInterface;
            String logicalType;
            Tree tree = null;
            if (!root.getTrees().isEmpty()) {
                tree = (Tree)root.getTrees().get(0);
            }
            if ((logicalType = (typeInterface = logicalObject.getTypeInterface()).getPublicType()).equals("Prompt")) {
                try {
                    PromptDefinitionInterface promptDefinitionInterface = null;
                    if (root instanceof Prompt) {
                        promptDefinitionInterface = PromptTypesUtil.getPromptDefinitionModelFromObject((Prompt)root);
                    }
                    GeneralPromptDefinitionTabPanel generalPromptDefTab = new GeneralPromptDefinitionTabPanel(root, logicalObject, promptDefinitionInterface, tree, typeInterface, config);
                    list.add((Object)generalPromptDefTab);
                }
                catch (RemoteException e) {
                    throw new MdException((Throwable)e);
                }
            }
            GeneralTabPanel generalTab = new GeneralTabPanel(root, tree, type, config);
            list.add((Object)generalTab);
            if (logicalObject.isReadCompatible() && logicalType.equals("PromptGroup")) {
                PromptGroupInterface promptGroupInterface = null;
                try {
                    promptGroupInterface = PromptTypesUtil.getPromptGroupModelFromObject((PromptGroup)root);
                    PromptGroupTabPanel promptGroupTab = new PromptGroupTabPanel(root, logicalObject, promptGroupInterface, 1, config);
                    list.add((Object)promptGroupTab);
                }
                catch (RemoteException e) {
                    throw new MdException((Throwable)e);
                }
            }
        }
        return list;
    }
}

