/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.prompts;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.prompts.PromptTypesUtil;
import com.sas.metadata.logical.prompts.RB;
import com.sas.metadata.logical.storedprocess.ConfigParameterPanel;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PromptGroup;
import com.sas.metadata.remote.Root;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.visuals.swing.designtime.MainPromptPanel;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.Locale;

class PromptGroupTabPanel
extends SmartWsDescriptionWizardTab
implements LayoutConstants {
    private Config _config;
    private int _type;
    private LogicalObjectInterface _logicalObject;
    private PromptGroupInterface _promptGroup;
    private MainPromptPanel _mainPromptPanel;
    private Root _root;

    public PromptGroupTabPanel(Root root, LogicalObjectInterface logicalObject, PromptGroupInterface promptGroup, int type, Config config) {
        this._logicalObject = logicalObject;
        this._promptGroup = promptGroup;
        this._config = config;
        this._type = type;
        this._root = root;
        String description = (String)config.getInitValue(ConfigParameterPanel.WIZARD_DESCRIPTION, (Object)RB.getStringResource("PromptGroupTabPanel.Wiz.txt"));
        this.setDescription(description);
        this.setName(RB.getStringResource("PromptGroupTabPanel.Tab.txt"));
        if (type == 1) {
            this.setHelpProduct("prompts");
            this.setHelpTopic("group_promptstab");
        } else {
            this.setHelpProduct("newstp");
            this.setHelpTopic("parameterswin");
        }
        AutoSizingGridLayout layout = new AutoSizingGridLayout(1, 1, 5, 5, true, true, true);
        double[] sizes = new double[1];
        int[] mins = new int[1];
        this.setLayout((LayoutManager)layout);
        this._mainPromptPanel = new MainPromptPanel();
        this._mainPromptPanel.setSharedButtonsVisible(false);
        this._mainPromptPanel.setValidateDataItems(true);
        this.add((Component)this._mainPromptPanel);
        sizes[0] = 0.6;
        mins[0] = 276;
        ProportionalSpacePartitioner psp = new ProportionalSpacePartitioner(sizes, mins, null);
        layout.setRowSpacePartitioner((SpacePartitionerInterface)psp);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._mainPromptPanel.setEnabled(editable);
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        if (this._type == 0) {
            this._promptGroup = (PromptGroupInterface)this._config.getInitValue(ConfigParameterPanel.PARAMETER_TREE, null);
            if (this._promptGroup == null) {
                this._promptGroup = new com.sas.prompts.groups.PromptGroup();
            }
            this._promptGroup.setPromptGroupLabel(RB.getStringResource("PromptGroupTabPanel.Parms.txt"), Locale.getDefault());
        }
        this._mainPromptPanel.setRootPromptGroup(this._promptGroup);
        this._mainPromptPanel.setUserContext(UtilPlatformServices.getUserContext());
        this._mainPromptPanel.validate(null);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        try {
            if (this._root instanceof PromptGroup) {
                PromptTypesUtil.updatePromptGroupWithPromptGroup((PromptGroup)this._root, this._promptGroup, this._logicalObject.getTypeInterface().getObjectFactory().getFactory().getMdFactory());
            }
        }
        catch (Exception e) {
            throw new MdException((Throwable)e);
        }
    }

    protected boolean dataValidate() throws RemoteException {
        if (this._mainPromptPanel != null) {
            this._mainPromptPanel.setValidateDataItems(true);
            ValidationEntry validationEntry = this._mainPromptPanel.validate(null);
            if (validationEntry == null) {
                return true;
            }
            MessageUtil.displayMessage((String)validationEntry.getMessage(), (String)RB.getStringResource("PromptLogicalObject.DelDlgTitle.txt"), (int)0);
            return false;
        }
        return true;
    }
}

