/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.prompts;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObject;
import com.sas.metadata.logical.OperationUserInteractionInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.prompts.PromptTypesUtil;
import com.sas.metadata.logical.prompts.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import java.rmi.RemoteException;
import java.util.List;

public abstract class BasePromptLogicalObject
extends LogicalObject {
    static final String RB_KEY = "PromptLogicalObject.";

    public BasePromptLogicalObject(Root root, TypeInterface ti, Factory factory) throws RemoteException {
        super(root, ti, factory);
    }

    public boolean delete(OperationUserInteractionInterface oui) {
        boolean retVal = true;
        String progressText = this.getProgressMessageForDelete();
        oui.updateProgress(progressText);
        BaseOMRPromptInterface prompt = null;
        try {
            prompt = PromptTypesUtil.getPromptFromLogicalObject((SimpleLogicalObjectInterface)this);
            if (prompt != null) {
                prompt.delete();
            }
        }
        catch (ServiceException e) {
            this.continueDeleting(oui, (MetadataInterface)prompt, (Exception)((Object)e));
        }
        catch (RemoteException e) {
            this.continueDeleting(oui, (MetadataInterface)prompt, e);
        }
        return retVal;
    }

    private void continueDeleting(OperationUserInteractionInterface oui, MetadataInterface prompt, Exception e) {
        if (oui.continueOperationWithPrompting()) {
            String folderName = "";
            if (prompt != null) {
                try {
                    List parents = prompt.getParents();
                    if (parents != null && parents.size() > 0) {
                        folderName = ((FolderInterface)parents.get(0)).getName();
                    }
                }
                catch (Exception parents) {
                    // empty catch block
                }
            }
            String messageText = UtilMisc.getMessage((String)RB.getStringResource("PromptLogicalObject.DelExcpOccrd.fmt.txt"), (Object)this.getName(), (Object)folderName, (Object)UtilMisc.getExceptionMessageText((Exception)e));
            int choice = oui.displayMessage(RB.getStringResource("PromptLogicalObject.DelDlgTitle.txt"), messageText, 2, OperationUserInteractionInterface.OK_OKTOALL_CANCEL_CHOICE_SET);
            OperationUserInteractionInterface.Updater.updateUsingOkOkToAllCancelValue_OkToAllTerminatesPrompting((OperationUserInteractionInterface)oui, (int)choice);
        }
    }

    private boolean isDeletable(boolean retVal, BaseOMRPromptInterface prompt) throws RemoteException, ServiceException {
        AssociationList list;
        if (!prompt.getPromptReferences().isEmpty()) {
            retVal = false;
            return retVal;
        }
        Root root = (Root)prompt.getRepositoryEntity();
        try {
            list = root.getSourceTransformations();
        }
        catch (MdException e) {
            throw new ServiceException((Throwable)e);
        }
        if (!list.isEmpty()) {
            retVal = false;
            return retVal;
        }
        if (null != prompt.getPromptEnabledObject()) {
            retVal = false;
            return retVal;
        }
        return retVal;
    }

    public String toString() {
        return this.getName();
    }
}

