/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.project;

import com.sas.metadata.logical.FolderContentMappingModel;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.project.ProjectContentHelper;
import com.sas.metadata.logical.project.ProjectType;
import com.sas.metadata.logical.project.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.MissingResourceHandler;
import com.sas.metadata.promotion.MissingResourceInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.TargetSBIPUrl;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.report.repository.ProjectInterface;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProjectImportListener
extends AbstractImportListener {
    static final String XML_ROM_FILE_INDICATOR = "<?xml version=\"";
    static final String BIP_SERVICE = "BIP Service";
    static final Logger log = Logger.getLogger(ProjectImportListener.class.getName());
    private static final String MetadataObjectType = "ClassifierMap";
    private String _Key;
    private ProjectContentHelper _contentHelper;

    public ProjectImportListener(TransportableTypeInterface type, String key) {
        super(type);
        this._Key = key;
        log.fine("new ProjectImportListener being constructed");
    }

    public void initialize(ImportOperationInterface operation) {
        this._contentHelper = new ProjectContentHelper();
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("ProjectListener.ProjectRepos.txt"));
        }
        log.fine("event = " + operation);
        log.fine("objects = " + objects);
        int rc = this.checkForContentMapping(operation, objects);
        if (operation.getPromotionType() != 2) {
            rc |= this.findMissingResources(operation, objects);
        }
        return rc;
    }

    private int checkForContentMapping(ImportOperationInterface operation, List workbooks) throws MetadataPromotionException {
        boolean contentMappingFound;
        Tree tree;
        Log importLogger;
        try {
            ImportItemInterface importItem;
            String[] path;
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessageWithDetails((TypeInterface)this.getTypeInterface(), (String)RB.getStringResource("ProjectListener.ValidatingContentMapping.txt")));
            importLogger = operation.getLogger();
            if (operation.importIntoRoot() && (operation.getPromotionType() == 2 || operation.getPromotionType() == 3)) {
                String msg = RB.getStringResource("ProjectListener.NoValidContentMapping.txt");
                importLogger.error((Object)msg);
                throw new MetadataPromotionException(msg);
            }
            Tree[] destTrees = operation.getFolderImportingInto();
            tree = null;
            contentMappingFound = false;
            int length = destTrees.length;
            if (length == 1) {
                tree = destTrees[0];
            } else if (length > 1 && workbooks.size() > 0 && (path = (importItem = (ImportItemInterface)workbooks.get(0)).getTargetPath()).length > 0) {
                String rootFolder = path[0];
                for (int i = 0; i < destTrees.length; ++i) {
                    Tree rootTree = destTrees[i];
                    if (!rootTree.getName().equals(rootFolder)) continue;
                    tree = rootTree;
                    break;
                }
                if (tree == null) {
                    try {
                        MdObjectStore store = operation.getStore();
                        SoftwareComponent sc = UtilMetadata.locateSoftwareComponent((String)UtilMetadata.getFoundationRepositoryID(), (MdObjectStore)store);
                        String scName = sc.getName();
                        if (scName.equals(BIP_SERVICE)) {
                            FolderContentMappingModel fcmm = new FolderContentMappingModel(sc);
                            fcmm.loadMetadata();
                            if (fcmm.getBackingType() == 0) {
                                String msg = UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.NoContentMappingOnRoot.txt"), (Object)rootFolder);
                                importLogger.error((Object)msg);
                                throw new MetadataPromotionException(msg);
                            }
                            return 0;
                        }
                        String msg = UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.NoContentMappingOnRoot.txt"), (Object)rootFolder);
                        importLogger.error((Object)msg);
                        throw new MetadataPromotionException(msg);
                    }
                    catch (MdException e) {
                        throw new MetadataPromotionException((Throwable)e);
                    }
                }
            }
        }
        catch (RemoteException e1) {
            throw new MetadataPromotionException((Throwable)e1);
        }
        if (tree != null) {
            String treeName = null;
            try {
                treeName = tree.getName();
                if (this.isContentMapped(tree)) {
                    contentMappingFound = true;
                }
            }
            catch (Exception e) {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.ContentMappingTestFailed.fmt.txt"), (Object)treeName);
                log.log(Level.WARNING, msg, e);
                importLogger.warn((Object)msg, (Throwable)e);
            }
            if (contentMappingFound) {
                importLogger.info((Object)RB.getStringResource("ProjectListener.ValidContentMappingFound.txt"));
                return 0;
            }
        }
        String msg = RB.getStringResource("ProjectListener.NoValidContentMapping.txt");
        importLogger.error((Object)msg);
        throw new MetadataPromotionException(msg);
    }

    private boolean isContentMapped(Tree tree) throws MdException, RemoteException {
        Tree parentTree = tree.getParentTree();
        while (parentTree != null) {
            tree = parentTree;
            parentTree = tree.getParentTree();
        }
        return FolderContentMappingModel.isContentMapped((Tree)tree);
    }

    private int findMissingResources(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        RepositoryInterface repos;
        ServerInterface server;
        Log importLogger = operation.getLogger();
        int rc = 0;
        MissingResourceHandler resourceHandler = operation.getResourceHandler();
        try {
            server = operation.getServer();
            repos = server.getRepository(operation.getRepositoryName());
            if (repos == null) {
                return rc;
            }
        }
        catch (Exception e) {
            throw new MetadataPromotionException((Throwable)e);
        }
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        List infoMaps = operation.getImportItems("InformationMap");
        List infoMapsOlap = operation.getImportItems("InformationMap.OLAP");
        List infoMapsRelational = operation.getImportItems("InformationMap.Relational");
        List storedProcs = operation.getImportItems("StoredProcess");
        List reports = operation.getImportItems("Report");
        ArrayList allImportedObjects = new ArrayList();
        allImportedObjects.addAll(infoMaps);
        allImportedObjects.addAll(infoMapsOlap);
        allImportedObjects.addAll(infoMapsRelational);
        allImportedObjects.addAll(storedProcs);
        allImportedObjects.addAll(reports);
        HashMap<String, TargetSBIPUrl> objectCache = new HashMap<String, TargetSBIPUrl>();
        int count = objects.size();
        int index = 0;
        for (ImportItemInterface item : objects) {
            String msg;
            String id = item.getID();
            String name = item.getName();
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)item.getTypeInterface(), (String)name, (int)(++index), (int)count));
            try {
                Map contentMap = contentHandler.getBinaryContent(id);
                for (String key : contentMap.keySet()) {
                    if (!this._Key.equals(key)) continue;
                    InputStream is = (InputStream)contentMap.get(key);
                    List urlList = this._contentHelper.retrieveListOfUrls(is);
                    int size = urlList.size();
                    for (int i = 0; i < size; ++i) {
                        String sourceUrl = (String)urlList.get(i);
                        if (sourceUrl.endsWith("(Folder")) continue;
                        TargetSBIPUrl targetSBIP = (TargetSBIPUrl)objectCache.get(sourceUrl);
                        if (targetSBIP != null) {
                            if (targetSBIP.isObjectBeingImported() || targetSBIP.objectExistsOnTarget()) continue;
                            PathUrl pathUrl = null;
                            String absolutePath = null;
                            MissingResourceInterface resource = null;
                            if (targetSBIP.getTargetUrl().toUpperCase().startsWith("SBIP")) {
                                pathUrl = new PathUrl(targetSBIP.getTargetUrl());
                                absolutePath = PromotionUtil.getAbsolutePathForSBIPUrl((PathUrl)pathUrl);
                            }
                            if (targetSBIP.getTargetUrl().toUpperCase().startsWith("/")) {
                                absolutePath = targetSBIP.getTargetUrl();
                            }
                            if (absolutePath != null) {
                                resource = resourceHandler.getMissingResource(absolutePath);
                            }
                            if (resource == null) continue;
                            resource.addDependentObject(item);
                            continue;
                        }
                        targetSBIP = PromotionUtil.getTargetSBIPUrl((String)sourceUrl, (String)operation.getRepositoryName(), allImportedObjects);
                        objectCache.put(sourceUrl, targetSBIP);
                        MetadataInterface mi = null;
                        PathUrl pathUrl = null;
                        if (targetSBIP.isObjectBeingImported()) continue;
                        String sbipUrlStr = targetSBIP.getTargetUrl();
                        if (sbipUrlStr.startsWith("/")) {
                            pathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)sbipUrlStr);
                            mi = server.getObjectByPath(pathUrl);
                        }
                        if (sbipUrlStr.toUpperCase().startsWith("SBIP")) {
                            pathUrl = new PathUrl(sbipUrlStr);
                            mi = repos.getObjectByPath(pathUrl);
                        }
                        boolean missingType = false;
                        if (pathUrl.getType() == null) {
                            missingType = true;
                            pathUrl.setType("Project");
                        }
                        if (mi == null) {
                            if (missingType) {
                                int slashIndex;
                                pathUrl.setType("Folder");
                                mi = repos.getObjectByPath(pathUrl);
                                if (mi != null) {
                                    targetSBIP.setObjectExistsOnTarget(true);
                                    continue;
                                }
                                String url = targetSBIP.getTargetUrl();
                                if (url.indexOf(46, slashIndex = url.lastIndexOf(47)) == -1) {
                                    pathUrl.setType("Folder");
                                } else {
                                    pathUrl.setType("Project");
                                }
                            }
                            targetSBIP.setObjectExistsOnTarget(false);
                            if (pathUrl.getType().equalsIgnoreCase("Folder")) continue;
                            String objectType = (String)UtilPromotion._smartObjectMap.get(pathUrl.getType());
                            if (objectType == null) {
                                objectType = pathUrl.getType();
                            }
                            String absolutePath = PromotionUtil.getAbsolutePathForSBIPUrl((PathUrl)pathUrl);
                            MissingResourceInterface resource = resourceHandler.createMissingResource(objectType, absolutePath);
                            resource.addDependentObject(item);
                            continue;
                        }
                        targetSBIP.setObjectExistsOnTarget(true);
                    }
                }
            }
            catch (IOException io) {
                msg = UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.CannotGetContent.fmt.txt"), (Object)name);
                importLogger.error((Object)msg, (Throwable)io);
                rc = 8;
            }
            catch (TransportException te) {
                msg = UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.CannotGetContent.fmt.txt"), (Object)name);
                importLogger.error((Object)msg, (Throwable)te);
                rc = 8;
            }
            catch (ServiceException se) {
                msg = UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.CannotGetReport.fmt.txt"), (Object)name);
                importLogger.error((Object)msg, (Throwable)se);
                rc = 8;
            }
        }
        return rc;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        Log importLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        log.fine("Report Import Listener Invoked, object count = " + objects.size());
        String reportName = null;
        try {
            int i = 1;
            for (ImportItemInterface item : objects) {
                log.fine("importing content for object #" + i++ + " = " + item + ")");
                String targetMdObjFQID = item.getTargetID();
                reportName = item.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.StatusIndicator.fmt.txt"), (Object)reportName));
                ProjectInterface project = ProjectType.getProject(operation.getServer(), targetMdObjFQID);
                String objectType = item.getTypeInterface().getDisplayType();
                importLogger.info((Object)UtilMisc.getMessage((String)UtilPromotion.getPromotionLogFormatString(), (Object)objectType, (Object)item.toString(), (Object)targetMdObjFQID));
                Map contentMap = contentHandler.getBinaryContent(item.getID());
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.ImportContentItemCount.fmt.txt"), (Object)Integer.toString(contentMap.size()), (Object)reportName));
                for (Map.Entry element : contentMap.entrySet()) {
                    String key = (String)element.getKey();
                    InputStream inStream = (InputStream)element.getValue();
                    if (!this._Key.equals(key)) continue;
                    OutputStream outStream = project.getOutputStream();
                    this._contentHelper.retrieveAndUpdateContentFromPackage(inStream, outStream, operation);
                }
            }
        }
        catch (Exception e) {
            String msg = reportName == null ? RB.getStringResource("ProjectListener.ImportFailedGeneral.txt") : UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.ImportFailedSpecific.fmt.txt"), reportName);
            log.log(Level.SEVERE, msg, e);
            importLogger.error((Object)msg, (Throwable)e);
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        finally {
            this._contentHelper.deleteTemporaryFiles();
        }
        return 0;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        int rc = 0;
        for (ImportItemInterface importItem : objects) {
            if (importItem.getImportState() != 2) continue;
            String targetOMAId = importItem.getTargetID();
            String mdType = importItem.getTypeInterface().getMetadataType();
            try {
                MetadataInterface mdi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetOMAId, (String)mdType);
                mdi.refresh();
            }
            catch (ServiceException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rc;
    }
}

