/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.project;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.project.ProjectExportItem;
import com.sas.metadata.logical.project.ProjectType;
import com.sas.metadata.logical.project.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.report.repository.ProjectInterface;
import com.sas.services.TransportException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;

class ProjectExportListener
extends AbstractExportListener {
    private static final Logger log = Logger.getLogger(ProjectExportListener.class.getName());
    private String _Key;

    public ProjectExportListener(TransportableTypeInterface type, String key) {
        super(type);
        this._Key = key;
        log.fine("entering");
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException {
        log.fine("Project Export Listener Invoked");
        Log exportLogger = operation.getLogger();
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        try {
            int i = 1;
            for (ExportItemInterface exportItem : objects) {
                String fqid = exportItem.getID();
                log.fine("objects[" + i++ + "] = " + fqid);
                ProjectInterface project = ProjectType.getProject(operation.getServer(), fqid);
                String name = project.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.StatusIndicator.fmt.txt"), (Object)name));
                log.fine("project: " + name);
                InputStream iStream = project.getInputStream();
                contentHandler.addBinaryContent(fqid, this._Key, iStream);
                exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("ProjectListener.ExportContentItemCount.fmt.txt"), (Object)Integer.toString(1), (Object)exportItem.toString()));
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        return 0;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new ProjectExportItem(name, id, type);
    }
}

