/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.informationmap.InformationMapUtil;
import com.sas.metadata.logical.informationmap.MapToImport;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.logical.storedprocess.StoredProcessConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.ValidationResponse;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.ServerContextInterface;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import java.util.Iterator;
import java.util.List;

public class StoredProcessValidator
implements ConnectionValidatorInterface {
    public String getConnectionTypeName() {
        return StoredProcessConnectionType.class.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void validate(ValidationResponse response, ImportOperationInterface operation, ConnectionPointInterface connection) {
        if (operation.getPromotionType() == 2) {
            return;
        }
        MdObjectStore store = operation.getStore();
        ServerContextInterface serverContextForStoredProcess = null;
        StoredProcessInterface storedProcess = null;
        LogicalServerInterface logicalServerForStoreProcess = null;
        try {
            boolean isStoredProcess = false;
            if ("StoredProcess".equals(connection.getPublicType())) {
                isStoredProcess = true;
            }
            if (connection.getPublicType() == null && "AbstractJob".equalsIgnoreCase(connection.getMetadataType())) {
                isStoredProcess = true;
            }
            if (!isStoredProcess) return;
            String target = connection.getTargetID();
            if (target == null) {
                String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.nullStoredProcess.txt"), (Object[])new Object[]{connection.getSourcePath()});
                response.setReturnCode(1);
                response.setMessage(message);
                return;
            }
            CMetadata jOMAObject = store.getObject(target);
            if (jOMAObject == null) {
                jOMAObject = InformationMapUtil.getjOMAObjectFromId((PromotionInterface)operation, connection.getMetadataType(), target);
            }
            if (jOMAObject == null) {
                if (!target.substring(0, 7).equalsIgnoreCase("_UNKNOWN") && !connection.isUnknown()) {
                    String message = RB.getStringResource("StoredProcessValidator.unknownTargetForStoredProcess.fmt.txt");
                    response.setReturnCode(2);
                    response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                    return;
                }
                String message = RB.getStringResource("StoredProcessValidator.unknownTargetForStoredProcess.fmt.txt");
                response.setReturnCode(1);
                response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                return;
            }
            MetadataInterface metadataForJOMAStoredProcess = PromotionUtil.getSmartObject((PromotionInterface)operation, (CMetadata)jOMAObject);
            if (!(metadataForJOMAStoredProcess instanceof StoredProcessInterface)) {
                String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.badStoredProcessMetadata.fmt.txt"), (Object[])new Object[]{metadataForJOMAStoredProcess.getName(), metadataForJOMAStoredProcess.getType()});
                response.setReturnCode(2);
                response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                return;
            }
            storedProcess = (StoredProcessInterface)metadataForJOMAStoredProcess;
            logicalServerForStoreProcess = storedProcess.getServer();
            if (logicalServerForStoreProcess == null) {
                String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.nullStoredProcessLogicalServer.txt"), (Object[])new Object[]{storedProcess.getName()});
                response.setReturnCode(2);
                response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                return;
            }
            List serverContextServersForStoredProcess = logicalServerForStoreProcess.getServed();
            for (Object objectSServer : serverContextServersForStoredProcess) {
                if (!(objectSServer instanceof ServerContextInterface)) continue;
                serverContextForStoredProcess = (ServerContextInterface)objectSServer;
                break;
            }
            if (serverContextForStoredProcess == null) {
                String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.badStoreProcessNoServer.txt"), (Object[])new Object[]{storedProcess.getName()});
                response.setReturnCode(2);
                response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                return;
            }
            List connectionAssociations = connection.getAssociatedObjects();
            ServerContextInterface omrServerContext = null;
            String mapName = "";
            boolean isOLAP = false;
            Iterator associationItera = connectionAssociations.iterator();
            while (true) {
                MapToImport mapObject;
                if (!associationItera.hasNext()) {
                    if (isOLAP) return;
                    StoredProcessInterface.LogicalServerType type = storedProcess.getLogicalServerType();
                    if (type == StoredProcessInterface.LogicalServerType.WORKSPACE) return;
                    if (type == StoredProcessInterface.LogicalServerType.ANY) return;
                    String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.badLogicalServerTypeRELATIONAL.fmt.txt"), (Object[])new Object[]{logicalServerForStoreProcess.getName(), storedProcess.getName(), type});
                    response.setReturnCode(1);
                    response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                    return;
                }
                Object itemInAssociations = associationItera.next();
                String mapServerContextID = null;
                if (!(itemInAssociations instanceof MapToImport) || (mapObject = (MapToImport)((Object)itemInAssociations)).getImportState() == 0) continue;
                mapName = mapObject.getMapName();
                if (mapObject.getBaseResourceTree().getResourcesByType(ExternalResourceType.WorkspaceServer).isEmpty()) {
                    isOLAP = true;
                }
                List connectionPointsForMap = mapObject.getConnectionPoints();
                for (Object connectionPointForMap : connectionPointsForMap) {
                    ConnectionPointInterface mapConnection;
                    String targetServerID;
                    if (!(connectionPointForMap instanceof ConnectionPointInterface) || (targetServerID = (mapConnection = (ConnectionPointInterface)connectionPointForMap).getTargetID()) == null || !"ServerContext".equalsIgnoreCase(mapConnection.getMetadataType())) continue;
                    CMetadata jOMAObjectForConnectOnMap = store.getObject(targetServerID);
                    MetadataInterface metadataForJOMOnMap = PromotionUtil.getSmartObject((PromotionInterface)operation, (CMetadata)jOMAObjectForConnectOnMap);
                    if (!(metadataForJOMOnMap instanceof ServerContextInterface)) {
                        String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.badServerFormat.txt"), (Object[])new Object[]{serverContextForStoredProcess.getName(), mapName, metadataForJOMOnMap.getName()});
                        response.setReturnCode(2);
                        response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                        return;
                    }
                    omrServerContext = (ServerContextInterface)metadataForJOMOnMap;
                    mapServerContextID = omrServerContext.getReposId();
                    if (mapServerContextID.equalsIgnoreCase(serverContextForStoredProcess.getReposId())) break;
                    String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.badStoredProcess.fmt.txt"), (Object[])new Object[]{storedProcess.getName(), mapName, omrServerContext.getName(), serverContextForStoredProcess.getName()});
                    response.setReturnCode(1);
                    response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
                    return;
                }
                if (mapServerContextID == null || omrServerContext == null) break;
            }
            String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.badMapId.txt"), (Object[])new Object[]{mapName});
            response.setReturnCode(2);
            response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
            return;
        }
        catch (Exception e) {
            String message = UtilMisc.getMessage((String)RB.getStringResource("StoredProcessValidator.metadataError.fmt.txt"), (Object[])new Object[]{e.getLocalizedMessage(), connection.getName()});
            response.setReturnCode(2);
            response.setMessage(UtilMisc.getMessage((String)message, (Object)connection.getName()));
            return;
        }
    }
}

