/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.informationmap.InformationMapGeneralPanel;
import com.sas.metadata.logical.informationmap.InformationMapLogicalObject;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.workspace.visuals.WsGenericGeneralPropertyTab;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class ObjectFactory
implements ObjectFactoryInterface {
    protected TypeInterface _type;
    private String _options;
    private Action[] EMPTY_ACTION_ARRAY = new Action[0];

    protected ObjectFactory(TypeInterface type) {
        this._type = type;
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        if (!this.isInformationMap(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        InformationMapLogicalObject map = new InformationMapLogicalObject((Transformation)root, this._type, Factory.getInstance());
        return map;
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root mdo, Config config) throws MdException, RemoteException {
        if (!this.isInformationMap(mdo)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + mdo.toString() + " .");
        }
        ArrayList<InformationMapGeneralPanel> lTabs = new ArrayList<InformationMapGeneralPanel>();
        InformationMapGeneralPanel tabGeneral = new InformationMapGeneralPanel(mdo, (Tree)mdo.getTrees().get(0), logicalObject.getTypeInterface(), config);
        tabGeneral.setEditable(false);
        lTabs.add(tabGeneral);
        WsGenericGeneralPropertyTab tabAdvanced = new WsGenericGeneralPropertyTab((CMetadata)mdo);
        tabAdvanced.setName(RB.getStringResource("InformationMapPropertiesDialog.Advanced.txt"));
        lTabs.add((InformationMapGeneralPanel)tabAdvanced);
        return lTabs;
    }

    public Factory getFactory() {
        return Factory.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String reposID) throws MdException, RemoteException {
        if (reposID == null) {
            throw new IllegalArgumentException("logic error: no reposid specified");
        }
        if (this._options == null) {
            this._options = "<XMLSELECT Search=\"*[@TransformRole='InformationMap']\"/><Templates><Transformation " + this.getFactory().getTemplateFormOfRequiredAndNeededAttributes(this._type) + "/></Templates>";
        }
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        MdObjectStore myStore = this.getFactory().getMdFactory().createObjectStore();
        try {
            List tranformations = this.getFactory().getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)myStore, reposID, "Transformation", 388, this._options);
            for (Transformation trans : tranformations) {
                list.add(this.createItemFromMetadataObject((Root)trans));
            }
        }
        finally {
            myStore.dispose();
        }
        return list;
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) {
        return this.EMPTY_ACTION_ARRAY;
    }

    public Action[] getActions(LogicalObjectInterface[] logicalObject, Root[] roots, Config config) {
        return this.EMPTY_ACTION_ARRAY;
    }

    private boolean isInformationMap(Root root) throws RemoteException {
        boolean isInfoMap = false;
        if (root instanceof Transformation) {
            Transformation trans = (Transformation)root;
            String publicType = trans.getPublicType();
            if (publicType.startsWith("InformationMap")) {
                isInfoMap = true;
            } else if (trans.getTransformRole().equalsIgnoreCase("InformationMap")) {
                isInfoMap = true;
            }
        }
        return isInfoMap;
    }
}

