/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.impl.IQModelImplUtilities;
import com.sas.iquery.metadata.resourceutil.ModelXMLRetrievalInterface2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.promotion.DefaultImportItem;
import com.sas.metadata.promotion.ImportItemInterface;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MapToImport
extends DefaultImportItem
implements ModelXMLRetrievalInterface2 {
    private ImportItemInterface _mapImportItem;
    private String _mapXML;
    private String _mapName;
    private String _sourceSbipUrl;
    private String _targetSbipUrl;
    private String _publicType;
    private PhysicalResourceTree2 _basePhysicalResourceTree = null;
    private boolean _containsPrompts = false;
    private List _tranformationSources;
    private IQModelUtility _utility = new IQModelUtility();
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>";

    public MapToImport(String mapName, String id, TransportableTypeInterface type) {
        super(mapName, id, type);
        this._mapName = mapName;
        this._mapImportItem = this;
        this._publicType = type.getPublicType();
        this.setUserObject((Object)this);
    }

    public ImportItemInterface getImportItem() {
        return this._mapImportItem;
    }

    public String getXML() {
        return this._mapXML;
    }

    public String getMapName() {
        return this._mapName;
    }

    public String getOMRMapID() {
        return this.getID();
    }

    public void setSourceSbipUrl(String url) {
        this._sourceSbipUrl = url;
    }

    public void setTargetSbipUrl(String url) {
        this._targetSbipUrl = url;
    }

    public boolean isValidForImport() {
        return this._mapImportItem.getImportState() != 0;
    }

    public void setIsValidForImport(boolean valid) {
        if (!valid) {
            this._mapImportItem.setImportState(0);
        }
    }

    public boolean equals(Object obj) {
        boolean rc = super.equals(obj);
        if (!rc && obj instanceof MapToImport) {
            MapToImport that = (MapToImport)((Object)obj);
            if (this._utility.isSame(this._sourceID, that._sourceID)) {
                rc = true;
            }
        }
        return rc;
    }

    public int hashCode() {
        int rc = 7;
        return rc += this._sourceID.hashCode();
    }

    public String getModelXML() {
        return this.getXML();
    }

    public Object getMap() {
        return this._mapImportItem;
    }

    public String getSourceSbipUrl() {
        return this._sourceSbipUrl;
    }

    public String getTargetSbipUrl() {
        return this._targetSbipUrl;
    }

    public String processModelXML(String modelXML) throws MetadataException {
        String result = null;
        Document doc = this._utility.createDocument("<?xml version=\"1.0\" encoding=\"UTF-8\" ?><a x=\"" + modelXML + "\"/>");
        Element topElement = doc.getDocumentElement();
        if (topElement != null) {
            result = this._utility.fetchAttribute(topElement, "x");
        }
        return result;
    }

    public void setBaseResourceTree(PhysicalResourceTree2 baseTree) {
        this._basePhysicalResourceTree = baseTree;
    }

    public PhysicalResourceTree2 getBaseResourceTree() {
        return this._basePhysicalResourceTree;
    }

    public void setContainsPrompts(boolean hasPrompts) {
        this._containsPrompts = hasPrompts;
    }

    public boolean getContainsPrompts() {
        return this._containsPrompts;
    }

    public void setTranformationSources(List transformationSources) {
        this._tranformationSources = transformationSources;
    }

    public List getTranformationSources() {
        return this._tranformationSources;
    }

    public String getPublicType() {
        return this._publicType;
    }

    public void setPublicType(String publicType) {
        this._publicType = publicType;
    }

    public void setXML(String xml) {
        this._mapXML = xml;
    }

    public class IQModelUtility
    extends IQModelImplUtilities {
        public boolean isSame(Object obj1, Object obj2) {
            return IQModelUtility.same((Object)obj1, (Object)obj2);
        }

        public Document createDocument(String xml) throws MetadataException {
            return IQModelUtility.newDocument((String)xml);
        }

        public String fetchAttribute(Element element, String attributeName) {
            return IQModelUtility.getAttr((Element)element, (String)attributeName);
        }
    }
}

