/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.jfs.JFSResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMAResourceImpl;
import com.sas.iquery.metadata.physical.oma.OMASoftwareServer;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceObjectRelationshipUtility2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.iquery.util.impl.ArrayMessageFormatter;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.promotion.AbstractPromotionListener;
import com.sas.metadata.promotion.ExportListener;
import com.sas.metadata.promotion.ImportListener;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class InformationMapUtil {
    public static final String IMAP_TRANSFORM_ROLE = "InformationMap";

    private InformationMapUtil() {
    }

    static BriefInformationMap getBriefInformationMap(SimpleLogicalObjectInterface logicalObject) throws RemoteException, ServiceException {
        BriefInformationMap briefMap = (BriefInformationMap)UtilPlatformServices.getSmartObject((SimpleLogicalObjectInterface)logicalObject);
        return briefMap;
    }

    static BriefInformationMap getBriefInformationMap(ServerInterface server, SimpleLogicalObjectInterface logicalObject) throws RemoteException, ServiceException {
        BriefInformationMap briefMap = (BriefInformationMap)PromotionUtil.getSmartObject((ServerInterface)server, (SimpleLogicalObjectInterface)logicalObject);
        return briefMap;
    }

    static int logUnresolvedResources(Log log, BriefInformationMap bmap, PhysicalResourceTree2 tree, List<? extends PhysicalResource> unresolvedResources, AbstractPromotionListener caller, int initalReturnCode) throws IllegalStateException, ServiceException, RemoteException, MetadataException {
        int rc = initalReturnCode;
        if (unresolvedResources != null && unresolvedResources.size() > 0) {
            String dPath;
            Collections.sort(unresolvedResources, new PhysicalResourceObjectRelationshipUtility2.PhysicalResourceResolutionTypeComparator());
            boolean done = false;
            ArrayList<PhysicalResource> processedResources = new ArrayList<PhysicalResource>();
            ArrayList<String> messages = new ArrayList<String>();
            int numOfUnresolvedResources = unresolvedResources.size();
            for (int index = 0; index < numOfUnresolvedResources && !done; ++index) {
                ExternalResourceType type;
                String labelText = null;
                String typeText = null;
                PhysicalResource res = unresolvedResources.get(index);
                PhysicalResource parent = null;
                parent = res instanceof ResourceRelationshipInterface ? ((ResourceRelationshipInterface)res).getParentResource() : tree.getParentResource(res);
                if (parent != null) {
                    if (!parent.isUnresolved()) {
                        type = ExternalResourceType.getType((PhysicalResource)res);
                        labelText = res.getLabel();
                        typeText = type.toString().toLowerCase();
                        processedResources.add(res);
                        if (type == ExternalResourceType.Column) {
                            labelText = parent.getLabel() + "." + labelText;
                            ExternalResourceType pType = ExternalResourceType.getType((PhysicalResource)parent);
                            typeText = pType.toString().toLowerCase() + "." + typeText;
                        }
                    } else if (!processedResources.contains(parent)) {
                        type = ExternalResourceType.getType((PhysicalResource)parent);
                        labelText = parent.getLabel();
                        typeText = type.toString().toLowerCase();
                        processedResources.add(parent);
                    }
                } else {
                    type = ExternalResourceType.getType((PhysicalResource)res);
                    labelText = res.getLabel();
                    typeText = type.toString().toLowerCase();
                    if (type == ExternalResourceType.WorkspaceServer || type == ExternalResourceType.OLAPServer) {
                        done = true;
                    }
                    processedResources.add(res);
                }
                if (labelText == null) continue;
                String resString = UtilMisc.getMessage((String)RB.getStringResource("InformationMapUtil.SourceTargetValues.fmt.txt"), (Object[])new Object[]{labelText, typeText});
                messages.add(resString);
            }
            String rbString = null;
            rbString = caller instanceof ExportListener ? RB.getStringResource("InformationMapUtil.resourcesNotFound.export.fmt.txt") : (caller instanceof ImportListener ? RB.getStringResource("InformationMapUtil.resourcesNotFound.import.fmt.txt") : RB.getStringResource("InformationMapUtil.resourcesNotFound.fmt.txt"));
            String mapName = bmap.getName();
            PathUrl pUrl = bmap.getPathUrl();
            if (pUrl != null && (dPath = pUrl.getDisplayPath()) != null) {
                mapName = dPath;
            }
            String headerMessage = UtilMisc.getMessage((String)rbString, (Object[])new Object[]{mapName});
            ArrayMessageFormatter arrayFormatter = null;
            int numOfMessages = messages.size();
            if (numOfMessages <= 5) {
                for (int i = 0; i < numOfMessages; ++i) {
                    messages.set(i, "\t" + (String)messages.get(i));
                }
                arrayFormatter = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, messages.toArray());
            } else {
                messages.set(0, "\t" + (String)messages.get(0));
                arrayFormatter = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_LONG, messages.toArray());
            }
            ArrayMessageFormatter formatter = new ArrayMessageFormatter(ArrayMessageFormatter.LISTSTYLE_ONEPERLINE, new Object[]{headerMessage, arrayFormatter});
            log.warn((Object)formatter);
            rc |= 4;
        }
        return rc;
    }

    static CMetadata getjOMAObjectFromId(PromotionInterface operation, String metadataType, String targetOMAId) throws RemoteException, MdException {
        MdObjectStore store;
        CMetadata jOMAObject = null;
        if (targetOMAId.indexOf(36) <= -1 && metadataType != null && !(store = operation.getStore()).isDeletedObject(targetOMAId)) {
            store.getFactory().getUtil().printOutputln("InformationMapImportListener going to server for object: " + targetOMAId);
            List returnObjects = store.getFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, operation.getRepositoryID(), metadataType, 412, "<XMLSelect search=\"*[@Id='" + targetOMAId + "']\"/>", true);
            if (returnObjects != null && returnObjects.size() == 1) {
                jOMAObject = (CMetadata)returnObjects.get(0);
            }
        }
        return jOMAObject;
    }

    static MetadataInterface getMetadataInterface(PromotionInterface operation, PhysicalResource omaResource) throws RemoteException, ServiceException {
        MetadataInterface smartObj = null;
        Object metaObject = InformationMapUtil.getMetadataObject(omaResource);
        if (metaObject instanceof MetadataInterface) {
            smartObj = (MetadataInterface)metaObject;
        } else if (metaObject instanceof CMetadata) {
            smartObj = PromotionUtil.getSmartObject((PromotionInterface)operation, (CMetadata)((CMetadata)metaObject));
        }
        return smartObj;
    }

    static Object getMetadataObject(PhysicalResource omaResource) {
        Object result = null;
        if (omaResource instanceof JFSResourceImpl) {
            result = ((JFSResourceImpl)omaResource).getMetadataInterface();
        } else if (omaResource instanceof OMAResourceImpl) {
            result = omaResource instanceof OMASoftwareServer ? ((OMASoftwareServer)omaResource).getServerContext() : ((OMAResourceImpl)omaResource).getOMAObject();
        }
        return result;
    }
}

