/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.IntelligentQueryMetadataServiceFactory;
import com.sas.iquery.metadata.IntelligentQueryMetadataServiceInterface;
import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.BriefInformationMap;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.resourceutil.InformationMapResourceReplacementManager2;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.informationmap.InformationMapUtil;
import com.sas.metadata.logical.informationmap.LogicalObjectUtility;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InformationMapExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    private List _consumesObjects;
    private List _consumedByObjects;

    public InformationMapExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        List out;
        Log log = Log.getInstance(null);
        if (relationshipType == 1) {
            if (this._consumedByObjects == null) {
                this._consumedByObjects = new ArrayList();
                try {
                    BriefInformationMap briefMap = InformationMapUtil.getBriefInformationMap(this._exportOperation.getServer(), (SimpleLogicalObjectInterface)this);
                    this._consumedByObjects = this.getConsumedByObjects(briefMap, log);
                }
                catch (RemoteException e) {
                    log.debug((Object)e.getLocalizedMessage());
                    this._consumedByObjects.clear();
                    LogicalTypeException th = new LogicalTypeException((Exception)e);
                    throw th;
                }
                catch (MdException e) {
                    log.debug((Object)e.getLocalizedMessage());
                    this._consumedByObjects.clear();
                    LogicalTypeException th = new LogicalTypeException((Exception)((Object)e));
                    throw th;
                }
                catch (ServiceException e) {
                    log.debug((Object)e.getLocalizedMessage());
                    this._consumedByObjects.clear();
                    LogicalTypeException th = new LogicalTypeException((Exception)((Object)e));
                    throw th;
                }
            }
            out = this._consumedByObjects;
        } else {
            if (this._consumesObjects == null) {
                this._consumesObjects = new ArrayList();
                try {
                    BriefInformationMap briefMap = InformationMapUtil.getBriefInformationMap(this._exportOperation.getServer(), (SimpleLogicalObjectInterface)this);
                    this._consumesObjects = this.getConsumesObjects(briefMap, log);
                }
                catch (RemoteException e) {
                    log.debug((Object)e.getLocalizedMessage());
                    this._consumesObjects.clear();
                    LogicalTypeException th = new LogicalTypeException((Exception)e);
                    throw th;
                }
                catch (MetadataException e) {
                    log.debug((Object)e.getLocalizedMessage());
                    this._consumesObjects.clear();
                    LogicalTypeException th = new LogicalTypeException((Exception)((Object)e));
                    throw th;
                }
                catch (ServiceException e) {
                    log.debug((Object)e.getLocalizedMessage());
                    this._consumesObjects.clear();
                    LogicalTypeException th = new LogicalTypeException((Exception)((Object)e));
                    throw th;
                }
            }
            out = this._consumesObjects;
        }
        return out;
    }

    private List getConsumedByObjects(BriefInformationMap briefMap, Log log) throws MdException, RemoteException, ServiceException, LogicalTypeException {
        Transformation t;
        ArrayList consumedByJomaObjects;
        Object reposObj;
        ArrayList<SimpleLogicalObjectInterface> consumedByObjects = new ArrayList<SimpleLogicalObjectInterface>();
        if (briefMap != null && (reposObj = briefMap.getRepositoryEntity()) instanceof Transformation && (consumedByJomaObjects = new ArrayList((t = (Transformation)reposObj).getTransformationTargets())).size() > 0) {
            for (Root jomaObject : consumedByJomaObjects) {
                SimpleLogicalObjectInterface logicalObject = PrivateObjectImportUtility.getLogicalFromJOMAObject((Root)jomaObject);
                if (logicalObject == null) continue;
                consumedByObjects.add(logicalObject);
            }
        }
        return consumedByObjects;
    }

    private List getConsumesObjects(BriefInformationMap briefMap, Log log) throws MetadataException, ServiceException, RemoteException, LogicalTypeException {
        List consumesObjects = new ArrayList();
        if (briefMap != null) {
            IntelligentQueryMetadataServiceInterface iq_svc = IntelligentQueryMetadataServiceFactory.newService();
            InformationMapResourceReplacementManager2 iRRM = new InformationMapResourceReplacementManager2(briefMap, this._exportOperation.getSessionContext(), iq_svc, log.getLog4JLogger(), true, true);
            consumesObjects = this.getDependentLogicalObjects(iRRM);
            iRRM.dispose();
            List prompts = briefMap.getPrompts();
            for (BaseOMRPromptInterface prompt : prompts) {
                List sources = prompt.getValueSources();
                List dependentSources = this.getDependentLogicalObjects(sources);
                for (Object source : dependentSources) {
                    consumesObjects.add(source);
                }
            }
        }
        Iterator it = consumesObjects.iterator();
        while (it.hasNext()) {
            SimpleLogicalObjectInterface logicalObject = (SimpleLogicalObjectInterface)it.next();
            if (!"ApplicationServer".equals(logicalObject.getTypeInterface().getPublicType())) continue;
            it.remove();
        }
        return consumesObjects;
    }

    private List getDependentLogicalObjects(InformationMapResourceReplacementManager2 iRRM) throws MetadataException, LogicalTypeException, ServiceException, RemoteException {
        ArrayList<SimpleLogicalObjectInterface> returnList = new ArrayList<SimpleLogicalObjectInterface>();
        LogicalObjectUtility logicalUtil = new LogicalObjectUtility((PromotionInterface)this._exportOperation);
        PhysicalResourceTree2 pTree = iRRM.getResourceManager().getDependentPhysicalObjectsAsTree();
        List resources = pTree.getResources();
        for (PhysicalResource res : resources) {
            SimpleLogicalObjectInterface ret;
            if (res.isUnresolved() || (ret = logicalUtil.getNewLogicalObject(res)) == null) continue;
            returnList.add(ret);
        }
        return returnList;
    }

    private List getDependentLogicalObjects(List inSmartObjects) throws ServiceException, RemoteException, MetadataException, LogicalTypeException {
        ArrayList<SimpleLogicalObjectInterface> returnList = new ArrayList<SimpleLogicalObjectInterface>();
        LogicalObjectUtility logicalUtil = new LogicalObjectUtility((PromotionInterface)this._exportOperation);
        for (MetadataInterface res : inSmartObjects) {
            SimpleLogicalObjectInterface ret = logicalUtil.getNewLogicalObject(res);
            if (ret == null) continue;
            returnList.add(ret);
        }
        return returnList;
    }
}

