/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.iquery.metadata.MetadataException;
import com.sas.iquery.metadata.business.impl.ResourceRelationshipInterface;
import com.sas.iquery.metadata.physical.JFSResource;
import com.sas.iquery.metadata.physical.PhysicalResource;
import com.sas.iquery.metadata.physical.jfs.JFSStoredProcess;
import com.sas.iquery.metadata.resourceutil.physical.ExternalResourceType;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceResolutionTypeComparator;
import com.sas.iquery.metadata.resourceutil.physical.PhysicalResourceTree2;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.informationmap.AbstractPointManager;
import com.sas.metadata.logical.informationmap.InformationMapUtil;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.MissingResourceHandler;
import com.sas.metadata.promotion.MissingResourceInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.TargetSBIPUrl;
import com.sas.metadata.remote.CMetadata;
import com.sas.services.ServiceException;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.session.SessionContextInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InformationMapConnectionPointManager
extends AbstractPointManager {
    public InformationMapConnectionPointManager(PromotionInterface operation) {
        super(operation);
    }

    void populateConnectionPoints(PhysicalResourceTree2 baseTree) throws MetadataPromotionException {
        List resourceList = baseTree.getResources();
        this.getResourceToConnectionPointMapping(resourceList, baseTree);
    }

    Map getResourceToConnectionPointMapping(List resources, PhysicalResourceTree2 baseTree) throws MetadataPromotionException {
        LinkedHashMap<PhysicalResource, ConnectionPointInterface> importObjectToPhysicalResourceMap = new LinkedHashMap<PhysicalResource, ConnectionPointInterface>();
        try {
            ArrayList resList = new ArrayList(resources);
            Collections.sort(resList, new PhysicalResourceResolutionTypeComparator());
            Iterator<Object> iter = resList.iterator();
            while (iter.hasNext()) {
                PhysicalResource phyRes = (PhysicalResource)iter.next();
                ExternalResourceType pType = ExternalResourceType.getType((PhysicalResource)phyRes);
                if (pType.isTypeSearchable()) {
                    ConnectionPointInterface cxPoint;
                    Object foundObject = importObjectToPhysicalResourceMap.get(phyRes);
                    if (foundObject != null) continue;
                    String searchStr = null;
                    if (phyRes instanceof ResourceRelationshipInterface) {
                        searchStr = ((ResourceRelationshipInterface)phyRes).getSearchString();
                    }
                    if ((cxPoint = this.getConectionPoint(phyRes, pType, searchStr)) == null) {
                        List unselectedItemsByType;
                        ImportOperationInterface importOp;
                        Map unselectedItems;
                        String publicType = pType.getPublicType();
                        if (publicType == null) continue;
                        boolean matched = false;
                        boolean isStoredProcess = publicType.equalsIgnoreCase("StoredProcess");
                        PromotionItemInterface promotionItem = null;
                        List promotionItemsByType = this._operation.getPromotionItems(publicType);
                        if (promotionItemsByType != null) {
                            Iterator iterItems = promotionItemsByType.iterator();
                            while (iterItems.hasNext() && !matched) {
                                promotionItem = (PromotionItemInterface)iterItems.next();
                                matched = this.isMatch(promotionItem, phyRes, isStoredProcess, baseTree, importObjectToPhysicalResourceMap);
                            }
                        }
                        if (!matched && this._operation.getPromotionType() == 1 && this._operation instanceof ImportOperationInterface && (unselectedItems = (importOp = (ImportOperationInterface)this._operation).getDeselectedItems()) != null && (unselectedItemsByType = (List)unselectedItems.get(publicType)) != null) {
                            Iterator iterItems = unselectedItemsByType.iterator();
                            while (iterItems.hasNext() && !matched) {
                                promotionItem = (PromotionItemInterface)iterItems.next();
                                matched = this.isMatch(promotionItem, phyRes, isStoredProcess, baseTree, importObjectToPhysicalResourceMap);
                            }
                        }
                        if (matched) {
                            cxPoint = this.createConnectionPoint(promotionItem, phyRes, pType, searchStr, baseTree);
                            importObjectToPhysicalResourceMap.put(phyRes, cxPoint);
                            continue;
                        }
                        if (this._operation.getPromotionType() != 0 || !(this._operation instanceof ExportOperationInterface) || phyRes.isUnresolved()) continue;
                        cxPoint = this.createConnectionPoint(phyRes, pType, searchStr, baseTree);
                        importObjectToPhysicalResourceMap.put(phyRes, cxPoint);
                        continue;
                    }
                    List targetList = baseTree.getResourceOwningObjects(phyRes);
                    cxPoint.addAssociatedObjects(targetList);
                    importObjectToPhysicalResourceMap.put(phyRes, cxPoint);
                    continue;
                }
                iter.remove();
            }
            for (PhysicalResource res : importObjectToPhysicalResourceMap.keySet()) {
                resList.remove(res);
                if (this._logger == null || !this._logger.isDebugEnabled()) continue;
                String foundDebugMsg = UtilMisc.getMessage((String)RB.getStringResource("InformationMapConnectionPointManager.ResToImportItem.fmt.txt"), (Object[])new Object[]{res, importObjectToPhysicalResourceMap.get(res)});
                this._logger.debug(foundDebugMsg);
            }
            this.createUnknownConnectionPoints(baseTree, resList, importObjectToPhysicalResourceMap);
        }
        catch (MetadataException me) {
            throw new MetadataPromotionException((Throwable)me);
        }
        catch (ServiceException se) {
            throw new MetadataPromotionException((Throwable)se);
        }
        catch (RemoteException re) {
            throw new MetadataPromotionException((Throwable)re);
        }
        return importObjectToPhysicalResourceMap;
    }

    private ConnectionPointInterface getConectionPoint(PhysicalResource phyRes, ExternalResourceType pType, String searchStr) throws RemoteException, ServiceException {
        ConnectionPointInterface cxPoint = null;
        if (!phyRes.isUnresolved()) {
            Object metaObj = InformationMapUtil.getMetadataObject(phyRes);
            String id = null;
            if (metaObj instanceof MetadataInterface) {
                id = ((MetadataInterface)metaObj).getIdentifier();
            } else if (metaObj instanceof CMetadata) {
                id = ((CMetadata)metaObj).getId();
            }
            if (id != null) {
                cxPoint = this._connectionManager.getConnection(id);
            }
        }
        if (searchStr != null) {
            List searchList;
            if (cxPoint == null) {
                cxPoint = pType == ExternalResourceType.StoredProcess ? this._connectionManager.getConnectionByPath(ConnectionObjectType.MetadataType, pType.getOMRType(), searchStr) : this.getConnectionBySearchString(ConnectionObjectType.MetadataType, pType.getOMRType(), searchStr);
            } else if (pType != ExternalResourceType.StoredProcess && !this.containsStringIgnoreCase(searchList = cxPoint.getSourceSearchList(), searchStr)) {
                searchList.add(0, searchStr);
            }
        }
        return cxPoint;
    }

    private boolean isMatch(PromotionItemInterface promotionItem, PhysicalResource phyRes, boolean isStoredProcess, PhysicalResourceTree2 baseTree, Map importObjectToPhysicalResourceMap) throws MetadataException {
        boolean match = false;
        if (isStoredProcess) {
            match = this.validateStoredProcessItem(phyRes, promotionItem, importObjectToPhysicalResourceMap);
        } else if (phyRes.getLabel().equalsIgnoreCase(promotionItem.getName())) {
            match = this.hasValidParentage(promotionItem, phyRes, baseTree, importObjectToPhysicalResourceMap);
        }
        return match;
    }

    private boolean validateStoredProcessItem(PhysicalResource phyRes, PromotionItemInterface promotionItem, Map importObjectToPhysicalResourceMap) {
        boolean isValid = false;
        if (phyRes instanceof JFSStoredProcess) {
            String[] sourcePath = promotionItem.getSourcePath();
            String spname = promotionItem.getName();
            String sourcePathValue = this.getPathValueFromArray(sourcePath, spname, promotionItem.getTypeInterface().getPublicType());
            JFSStoredProcess spValue = (JFSStoredProcess)phyRes;
            String spLocation = spValue.getLocation();
            if (spLocation != null && spLocation.contains(sourcePathValue)) {
                isValid = true;
            }
        }
        return isValid;
    }

    private boolean hasValidParentage(PromotionItemInterface promotionItem, PhysicalResource phyRes, PhysicalResourceTree2 baseTree, Map importObjectToPhysicalResourceMap) throws MetadataException {
        boolean isParentageValid = false;
        PhysicalResource parentPhyRes = baseTree.getParentResource(phyRes);
        if (parentPhyRes != null) {
            Object foundParentObject = importObjectToPhysicalResourceMap.get(parentPhyRes);
            if (foundParentObject == null) {
                String parentOMRType;
                List doCxPointsByType;
                ConnectionPointInterface cxPoint;
                ExternalResourceType pType = ExternalResourceType.getType((PhysicalResource)parentPhyRes);
                String searchString = "";
                if (parentPhyRes instanceof ResourceRelationshipInterface) {
                    searchString = ((ResourceRelationshipInterface)parentPhyRes).getSearchString();
                }
                if ((cxPoint = this.getConnectionBySearchString(doCxPointsByType = this.getConnectionPointsByTypeFromDO(promotionItem, parentOMRType = pType.getOMRType()), parentOMRType, searchString)) != null) {
                    importObjectToPhysicalResourceMap.put(parentPhyRes, cxPoint);
                    isParentageValid = true;
                } else {
                    String parentName = parentPhyRes.getLabel();
                    List importItemsByType = this._operation.getPromotionItems(pType.getPublicType());
                    Iterator iterItems = importItemsByType.iterator();
                    while (iterItems.hasNext() && !isParentageValid) {
                        PromotionItemInterface promoteItItem;
                        Object iterObject = iterItems.next();
                        if (!(iterObject instanceof PromotionItemInterface) || !parentName.equalsIgnoreCase((promoteItItem = (PromotionItemInterface)iterObject).getName())) continue;
                        cxPoint = this.createConnectionPoint(promoteItItem, parentPhyRes, pType, searchString, baseTree);
                        importObjectToPhysicalResourceMap.put(parentPhyRes, cxPoint);
                        isParentageValid = true;
                    }
                }
            } else {
                isParentageValid = true;
            }
        } else {
            isParentageValid = true;
        }
        return isParentageValid;
    }

    private ConnectionPointInterface createConnectionPoint(PhysicalResource phyRes, ExternalResourceType pType, String searchStr, PhysicalResourceTree2 baseTree) throws MetadataException, ServiceException, RemoteException {
        ConnectionPointInterface cxPoint = null;
        MetadataInterface smartObj = InformationMapUtil.getMetadataInterface(this._operation, phyRes);
        if (smartObj == null) {
            cxPoint = this._connectionManager.createUnknownConnection(pType.getOMRType(), phyRes.getLabel());
            cxPoint.setSourcePath("");
            cxPoint.addSourceSearch(((ResourceRelationshipInterface)phyRes).getSearchString());
            cxPoint.setDescription(phyRes.getDescription());
        } else {
            String omrID = smartObj.getIdentifier();
            cxPoint = this._connectionManager.getConnection(omrID);
            if (cxPoint == null) {
                String itemName = phyRes.getLabel();
                String publicType = pType.getPublicType();
                cxPoint = this._connectionManager.createConnection(pType.getOMRType(), omrID, itemName);
                cxPoint.setPublicType(publicType);
                cxPoint.setDescription(phyRes.getDescription());
                if (searchStr != null) {
                    if (pType.equals((Object)ExternalResourceType.StoredProcess)) {
                        cxPoint.setSourcePath(searchStr);
                    } else {
                        PathUrl url = smartObj.getPathUrl();
                        if (url != null) {
                            cxPoint.setSourcePath(url.getAbsolutePath());
                        }
                        cxPoint.addSourceSearch(searchStr);
                    }
                } else {
                    PathUrl url = smartObj.getPathUrl();
                    if (url != null) {
                        cxPoint.setSourcePath(url.getAbsolutePath());
                    }
                }
            }
        }
        List targetList = baseTree.getResourceOwningObjects(phyRes);
        cxPoint.addAssociatedObjects(targetList);
        ((ConnectionPoint)cxPoint).setActive(true);
        return cxPoint;
    }

    private ConnectionPointInterface createConnectionPoint(PromotionItemInterface promotionItem, PhysicalResource phyRes, ExternalResourceType pType, String searchStr, PhysicalResourceTree2 baseTree) throws MetadataException {
        ConnectionPointInterface cxPoint = null;
        String promotionID = promotionItem.getID();
        if (promotionID == null) {
            cxPoint = this._connectionManager.createUnknownConnection(pType.getOMRType(), phyRes.getLabel());
            cxPoint.addSourceSearch(((ResourceRelationshipInterface)phyRes).getSearchString());
        } else {
            cxPoint = this._connectionManager.getConnection(promotionID);
            if (cxPoint == null) {
                String itemName = promotionItem.getName();
                String publicType = promotionItem.getTypeInterface().getPublicType();
                cxPoint = this._connectionManager.createConnection(pType.getOMRType(), promotionID, itemName);
                cxPoint.setPublicType(publicType);
                cxPoint.addAssociatedObject(promotionItem);
                cxPoint.setDescription(promotionItem.getDescription());
                if (searchStr != null) {
                    if (pType.equals((Object)ExternalResourceType.StoredProcess)) {
                        cxPoint.setSourcePath(searchStr);
                    } else {
                        String[] sourcePath = promotionItem.getSourcePath();
                        String path = this.getPathValueFromArray(sourcePath, itemName, publicType);
                        cxPoint.setSourcePath(path);
                        cxPoint.addSourceSearch(searchStr);
                    }
                } else {
                    String[] sourcePath = promotionItem.getSourcePath();
                    String path = this.getPathValueFromArray(sourcePath, itemName, publicType);
                    cxPoint.setSourcePath(path);
                }
            }
        }
        List targetList = baseTree.getResourceOwningObjects(phyRes);
        cxPoint.addAssociatedObjects(targetList);
        this.activateConnection(promotionItem, cxPoint);
        return cxPoint;
    }

    private void createUnknownConnectionPoints(PhysicalResourceTree2 resourceTree, List resourceList, Map resourceToConnectionMappings) throws MetadataException {
        for (PhysicalResource resource : resourceList) {
            ExternalResourceType resType = ExternalResourceType.getType((PhysicalResource)resource);
            if (!resType.isTypeSearchable()) continue;
            String sourceSearch = null;
            if (resource instanceof ResourceRelationshipInterface) {
                sourceSearch = ((ResourceRelationshipInterface)resource).getSearchString();
            }
            String metadataType = resType.getMetadataType(resource);
            if (sourceSearch == null) continue;
            ConnectionPointInterface cpoint = this._connectionManager.createUnknownConnection(metadataType, resource.getLabel());
            cpoint.setPublicType(resType.getPublicType());
            List targetList = resourceTree.getResourceOwningObjects(resource);
            cpoint.addAssociatedObjects(targetList);
            if (resource instanceof JFSResource) {
                cpoint.setSourcePath(sourceSearch);
            } else {
                cpoint.addSourceSearch(sourceSearch);
            }
            this.activateConnection(null, cpoint);
            resourceToConnectionMappings.put(resource, cpoint);
        }
    }

    private void activateConnection(PromotionItemInterface connectionItem, ConnectionPointInterface pt) {
        ImportItemInterface importConnection;
        if (connectionItem == null) {
            if (!pt.isActive() && pt instanceof ConnectionPoint) {
                ((ConnectionPoint)pt).setActive(true);
            }
        } else if (connectionItem instanceof ImportItemInterface && (importConnection = (ImportItemInterface)connectionItem).getImportState() != 0 && pt.isActive() && pt instanceof ConnectionPoint) {
            ((ConnectionPoint)pt).setActive(false);
        }
    }

    private ConnectionPointInterface getConnectionBySearchString(ConnectionObjectType type, String typeValue, String searchString) {
        List connectionsByType = this._connectionManager.getConnections(type, typeValue, true);
        return this.getConnectionBySearchString(connectionsByType, typeValue, searchString);
    }

    private ConnectionPointInterface getConnectionBySearchString(List cxPoints, String typeValue, String searchString) {
        ConnectionPointInterface cpt = null;
        if (searchString != null && typeValue != null && cxPoints != null) {
            boolean isPre92 = this._operation.getPackageFileVersion() < 9200;
            boolean isTable = ExternalResourceType.getExternalResourceTypeForMetadataType((String)typeValue) == ExternalResourceType.Table;
            Iterator iter = cxPoints.iterator();
            while (iter.hasNext() && cpt == null) {
                ConnectionPointInterface pt = (ConnectionPointInterface)iter.next();
                List searchList = pt.getSourceSearchList();
                if (isPre92 && isTable) {
                    Iterator slit = searchList.iterator();
                    while (slit.hasNext() && cpt == null) {
                        String ptSearchStr = (String)slit.next();
                        if (!ptSearchStr.contains("DeployedComponents")) {
                            String ptName = "*[@name='" + pt.getName().toLowerCase() + "']";
                            if (!searchString.toLowerCase().startsWith(ptName)) continue;
                            searchList.add(0, searchString);
                            cpt = pt;
                            continue;
                        }
                        if (!this.containsStringIgnoreCase(searchList, searchString)) continue;
                        cpt = pt;
                    }
                    continue;
                }
                if (!this.containsStringIgnoreCase(searchList, searchString)) continue;
                cpt = pt;
            }
        }
        return cpt;
    }

    private List getConnectionPointsByTypeFromDO(PromotionItemInterface dObject, String metadataType) {
        ArrayList<ConnectionPointInterface> returnValue = new ArrayList<ConnectionPointInterface>();
        List cxPointMap = dObject.getConnectionPoints();
        for (ConnectionPointInterface cPoint : cxPointMap) {
            if (!cPoint.getMetadataType().equals(metadataType)) continue;
            returnValue.add(cPoint);
        }
        return returnValue;
    }

    private boolean containsStringIgnoreCase(List list, String key) {
        boolean found = false;
        Iterator iter = list.iterator();
        while (iter.hasNext() && !found) {
            String value = (String)iter.next();
            if (!value.equalsIgnoreCase(key)) continue;
            found = true;
        }
        return found;
    }

    void findMissingPathURLResources(SessionContextInterface session, Map importedObjectsMappings, PhysicalResourceTree2 baseTree) throws Exception {
        ServerInterface server;
        RepositoryInterface repos;
        MissingResourceHandler resourceHandler = null;
        List storedProcessList = null;
        if (this._operation instanceof ImportOperationInterface) {
            resourceHandler = ((ImportOperationInterface)this._operation).getResourceHandler();
            storedProcessList = ((ImportOperationInterface)this._operation).getImportItems("StoredProcess");
        }
        if ((repos = (server = this._operation.getServer()).getRepository(this._operation.getRepositoryName())) == null) {
            return;
        }
        HashMap<String, TargetSBIPUrl> objectCache = new HashMap<String, TargetSBIPUrl>();
        for (PhysicalResource resource : importedObjectsMappings.keySet()) {
            Object importTarget;
            if (!baseTree.getResourceType(resource).equals((Object)ExternalResourceType.StoredProcess) || !((importTarget = importedObjectsMappings.get(resource)) instanceof ConnectionPointInterface)) continue;
            ConnectionPointInterface rPoint = (ConnectionPointInterface)importTarget;
            String sourceUrl = rPoint.getSourcePath();
            TargetSBIPUrl targetSBIP = (TargetSBIPUrl)objectCache.get(sourceUrl);
            if (targetSBIP != null) {
                if (targetSBIP.isObjectBeingImported() || targetSBIP.objectExistsOnTarget()) continue;
                PathUrl pathUrl = new PathUrl(targetSBIP.getTargetUrl());
                String absolutePath = PromotionUtil.getAbsolutePathForSBIPUrl((PathUrl)pathUrl);
                MissingResourceInterface mr = resourceHandler.getMissingResource(absolutePath);
                if (resource == null) continue;
                mr.addDependentObjects(rPoint.getAssociatedObjects());
                continue;
            }
            targetSBIP = PromotionUtil.getTargetSBIPUrl((String)sourceUrl, (String)this._operation.getRepositoryName(), (List)storedProcessList);
            objectCache.put(sourceUrl, targetSBIP);
            if (targetSBIP.isObjectBeingImported()) continue;
            String path = targetSBIP.getTargetUrl();
            PathUrl pathUrl = path.startsWith("/") ? PathUrl.newPathUrlFromAbsolutePath((ServerInterface)server, (String)path) : new PathUrl(path);
            MetadataInterface mi = repos.getObjectByPath(pathUrl);
            if (mi == null) {
                targetSBIP.setObjectExistsOnTarget(false);
                String objectType = (String)UtilPromotion._smartObjectMap.get(pathUrl.getType());
                if (objectType == null) {
                    objectType = pathUrl.getType();
                }
                String absolutePath = PromotionUtil.getAbsolutePathForSBIPUrl((PathUrl)pathUrl);
                MissingResourceInterface mr = resourceHandler.createMissingResource(objectType, absolutePath);
                mr.addDependentObjects(rPoint.getAssociatedObjects());
                continue;
            }
            targetSBIP.setObjectExistsOnTarget(true);
        }
    }
}

