/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.informationmap;

import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.informationmap.RB;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractConnectionPanel;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.util.Comparator;

public class InformationMapConnectionPanel
extends AbstractConnectionPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] ALL_SPECIFIC_MAP_TYPES = new String[]{"InformationMap.OLAP", "InformationMap.Relational"};

    public InformationMapConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
        this.setSupportedPublicTypes(ALL_SPECIFIC_MAP_TYPES);
    }

    public String getDefaultSelectionValue() {
        return RB.getStringResource("InformationMapConnectionPanel.NoneSelection.txt");
    }

    public String getHelpTopicSuffix() {
        return "mapwin";
    }

    public String getPanelBorderLabel() {
        return RB.getStringResource("InformationMapConnectionPanel.BorderTitle.txt");
    }

    public String getPanelDescription() {
        return RB.getStringResource("InformationMapConnectionPanel.Desc.txt");
    }

    public String getPanelTitle() {
        return RB.getStringResource("InformationMapConnectionPanel.Title.txt");
    }

    public int getSelectionType() {
        return 1;
    }

    public Comparator getSourceTargetComparator() {
        return new InfoMapComparator();
    }

    class InfoMapComparator
    implements Comparator {
        InfoMapComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            int rc = -1;
            if (obj1 instanceof SourceConnectionInterface && obj2 instanceof TargetConnectionInterface) {
                SourceConnectionInterface source = (SourceConnectionInterface)obj1;
                ConnectionPointInterface srcPoint = source.getConnectionPoint();
                String sourcePath = srcPoint.getSourcePath();
                TargetConnectionInterface target = (TargetConnectionInterface)obj2;
                Root trgObject = (Root)target.getMetadataObject();
                try {
                    MetadataInterface trgSmartObject = UtilPlatformServices.getSmartObject((Root)trgObject);
                    PathUrl targetPath = trgSmartObject.getPathUrl();
                    if (targetPath != null) {
                        String targetPathString = targetPath.toString();
                        rc = targetPathString.compareTo(sourcePath);
                    }
                }
                catch (RemoteException remoteException) {
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            return rc;
        }
    }
}

