/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.dataexploration;

import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.dataexploration.DataExplorationExportItem;
import com.sas.metadata.logical.dataexploration.DataExplorationImportListener;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionObjectType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.dataexplorer.DataExplorationEntryInterface;
import java.rmi.RemoteException;
import java.util.List;

public class DataExplorationExportListener
extends AbstractExportListener {
    private static final String INFOMAP_METADATA_TYPE = "Transformation";

    public DataExplorationExportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new DataExplorationExportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return DataExplorationImportListener.CONNECTION_TYPES;
    }

    public int analyzeConnections(ExportOperationInterface exportOperation, List exportObjects) throws MdException, RemoteException {
        int returnValue = super.analyzeConnections(exportOperation, exportObjects);
        for (ExportItemInterface exportItem : exportObjects) {
            if (!"DataExploration".equals(exportItem.getTypeInterface().getPublicType())) continue;
            this.addConnectionPointsFor(exportItem, exportOperation);
        }
        return returnValue;
    }

    private void addConnectionPointsFor(ExportItemInterface exportItem, ExportOperationInterface exportOperation) throws MdException {
        block13: {
            try {
                DataExplorationEntryInterface deEntry;
                String mapPathStr;
                ConnectionManagerInterface connMgr = exportOperation.getConnectionManager();
                ServerInterface metadataServer = exportOperation.getServer();
                MetadataInterface mi = PromotionUtil.getSmartObject((ServerInterface)metadataServer, (SimpleLogicalObjectInterface)exportItem);
                if (!(mi instanceof DataExplorationEntryInterface) || (mapPathStr = (deEntry = (DataExplorationEntryInterface)mi).getInformationMapPath()) == null) break block13;
                PathUrl mapPath = new PathUrl(mapPathStr);
                String absolutePath = mapPath.getAbsolutePath();
                PathUrl fullPath = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)metadataServer, (String)absolutePath);
                MetadataInterface foundObject = null;
                try {
                    foundObject = metadataServer.getObjectByPath(fullPath);
                }
                catch (ServiceException serviceException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                ConnectionPointInterface cpoint = null;
                if (foundObject == null) {
                    cpoint = connMgr.getConnectionByPath(ConnectionObjectType.MetadataType, INFOMAP_METADATA_TYPE, absolutePath);
                } else {
                    String id = foundObject.getReposId();
                    if (id != null) {
                        cpoint = connMgr.getConnection(id);
                        if (cpoint == null) {
                            cpoint = connMgr.getConnectionByPath(ConnectionObjectType.MetadataType, INFOMAP_METADATA_TYPE, absolutePath);
                        }
                        if (cpoint == null) {
                            cpoint = connMgr.createConnection(INFOMAP_METADATA_TYPE, id, mapPath.getName());
                        }
                    }
                }
                if (cpoint != null) {
                    cpoint.setPublicType("InformationMap");
                    cpoint.addAssociatedObject((PromotionItemInterface)exportItem);
                    if (absolutePath != null) {
                        cpoint.setSourcePath(absolutePath);
                    }
                }
            }
            catch (RemoteException e) {
                throw new MdException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new MdException((Throwable)e);
            }
        }
    }
}

