/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.businessruleflow;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.businessruleflow.BusinessRuleFlowPromotionOptionsPanel;
import com.sas.metadata.logical.businessruleflow.BusinessRuleFlowType;
import com.sas.metadata.logical.businessruleflow.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PropertyInterface;
import com.sas.services.information.metadata.businessruleflow.BusinessRuleFlowInterface;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

public class BusinessRuleFlowImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    private BusinessRuleFlowPromotionOptionsPanel _optionsPanel;
    private boolean _isOverwriteSeleted = true;

    public BusinessRuleFlowImportListener(BusinessRuleFlowType type) {
        super((TransportableTypeInterface)type);
        String value = System.getProperty("sas.promotion.businessruleflow.overwrite");
        if (value != null && value.equalsIgnoreCase("false")) {
            this._isOverwriteSeleted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        Log importLogger = operation.getLogger();
        importLogger.debug((Object)("BusinessRuleFlowImportListener invoked, object count = " + objects.size()));
        if (operation.getPromotionType() == 2) {
            importLogger.debug((Object)"Copy/Past Operation ...");
            return super.importContent(operation, objects);
        }
        importLogger.debug((Object)"Import Operation ...");
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        int returnCode = 0;
        String dfObjectName = null;
        int importedItemCount = 1;
        for (ImportItemInterface item : objects) {
            importLogger.debug((Object)("importing content for object #" + importedItemCount++ + " = " + item + ")"));
            try {
                String targetMdObjFQID = item.getTargetID();
                dfObjectName = item.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowImportListener.StatusIndicator.fmt.txt"), (Object)dfObjectName));
                BusinessRuleFlowInterface smartObj = (BusinessRuleFlowInterface)PromotionUtil.getSmartObject((ServerInterface)operation.getServer(), (String)targetMdObjFQID, (String)"Transformation");
                importLogger.debug((Object)"update storage location");
                if (smartObj.contentExists()) {
                    if (this._isOverwriteSeleted) {
                        smartObj.deleteContents();
                    } else {
                        importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowImportListener.ContentExists.fmt.txt"), (Object)dfObjectName));
                        throw new Exception();
                    }
                }
                String objectType = item.getTypeInterface().getDisplayType();
                importLogger.info((Object)UtilMisc.getMessage((String)UtilPromotion.getPromotionLogFormatString(), (Object)objectType, (Object)item.toString(), (Object)targetMdObjFQID));
                Map<String, InputStream> contentMap = contentHandler.getBinaryContent(item.getID());
                contentMap = this.sortMapByKey(contentMap);
                importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowImportListener.ImportContentItemCount.fmt.txt"), (Object)Integer.toString(contentMap.size()), (Object)dfObjectName));
                for (Map.Entry<String, InputStream> element : contentMap.entrySet()) {
                    String key = element.getKey();
                    if (!key.startsWith("BusinessRuleFlow-")) continue;
                    ByteArrayOutputStream bytestream = new ByteArrayOutputStream();
                    try {
                        String newVer;
                        int ch;
                        InputStream inStream = element.getValue();
                        while ((ch = inStream.read()) != -1) {
                            bytestream.write(ch);
                        }
                        byte[] imgdata = bytestream.toByteArray();
                        importLogger.debug((Object)("add content to content server, item key: " + key));
                        smartObj.addVersion(imgdata);
                        smartObj.update();
                        bytestream.close();
                        String origVer = key.split("-")[1];
                        if (origVer.equals(newVer = smartObj.defaultVersion())) continue;
                        importLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowImportListener.ImportContent.VersionChange.fmt.txt"), (Object)origVer, (Object)newVer));
                    }
                    catch (Exception e) {
                        returnCode = 8;
                        String path = null;
                        List objectProps = smartObj.getObjectProperties();
                        for (Object object : objectProps) {
                            PropertyInterface prop = (PropertyInterface)object;
                            if (!prop.getName().equals("davpath")) continue;
                            path = prop.getValue();
                        }
                        importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowImportListener.ImportContent.ZeroLength.fmt.txt"), (Object)dfObjectName, path));
                    }
                    finally {
                        if (bytestream == null) continue;
                        try {
                            bytestream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                returnCode = 8;
                String msg = dfObjectName == null ? RB.getStringResource("BusinessRuleFlowImportListener.ImportFailedGeneral.txt") : UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowImportListener.ImportFailedSpecific.fmt.txt"), (Object)dfObjectName);
                importLogger.error((Object)msg, (Throwable)e);
            }
        }
        return returnCode;
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        int rc = 0;
        for (ImportItemInterface importItem : objects) {
            if (importItem.getImportState() != 2) continue;
            String targetOMAId = importItem.getTargetID();
            String mdType = importItem.getTypeInterface().getMetadataType();
            try {
                MetadataInterface mdi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)targetOMAId, (String)mdType);
                mdi.refresh();
            }
            catch (ServiceException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (RemoteException e) {
                rc |= 8;
                if (!importLogger.isErrorEnabled()) continue;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return rc;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface handler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface handler) {
        Log importLogger = handler.getLogger();
        if (handler.getPromotionType() == 1 && null == this._optionsPanel) {
            importLogger.debug((Object)"initialize options panel ...");
            this._optionsPanel = new BusinessRuleFlowPromotionOptionsPanel();
        }
        return this._optionsPanel;
    }

    public void saveSettings() {
        if (null != this._optionsPanel) {
            this._isOverwriteSeleted = this._optionsPanel.isOverwriteSeleted();
        }
    }

    private Map<String, InputStream> sortMapByKey(Map<String, InputStream> contentMap) {
        LinkedList<Map.Entry<String, InputStream>> list = new LinkedList<Map.Entry<String, InputStream>>(contentMap.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<String, InputStream>>(){

            @Override
            public int compare(Map.Entry<String, InputStream> entry1, Map.Entry<String, InputStream> entry2) {
                if (!entry1.getKey().startsWith("BusinessRuleFlow-") || !entry2.getKey().startsWith("BusinessRuleFlow-")) {
                    return entry1.getKey().compareTo(entry2.getKey());
                }
                String o1 = entry1.getKey().split("-")[1];
                String o2 = entry2.getKey().split("-")[1];
                int o1_dotIndex = o1.indexOf(".");
                int o1_major = Integer.valueOf(o1.substring(0, o1_dotIndex));
                int o1_minor = Integer.valueOf(o1.substring(o1_dotIndex + 1));
                int o2_dotIndex = o2.indexOf(".");
                int o2_major = Integer.valueOf(o2.substring(0, o2_dotIndex));
                int o2_minor = Integer.valueOf(o2.substring(o2_dotIndex + 1));
                if (o1_major > o2_major) {
                    return 1;
                }
                if (o1_major < o2_major) {
                    return -1;
                }
                if (o1_minor > o2_minor) {
                    return 1;
                }
                if (o1_minor < o2_minor) {
                    return -1;
                }
                return 0;
            }
        });
        contentMap = new LinkedHashMap<String, InputStream>();
        for (Map.Entry entry : list) {
            contentMap.put((String)entry.getKey(), (InputStream)entry.getValue());
        }
        return contentMap;
    }
}

