/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.businessruleflow;

import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.businessruleflow.BusinessRuleFlowType;
import com.sas.metadata.logical.businessruleflow.RB;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.businessruleflow.BusinessRuleFlowInterface;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class BusinessRuleFlowExportListener
extends AbstractExportListener {
    public BusinessRuleFlowExportListener(BusinessRuleFlowType type) {
        super((TransportableTypeInterface)type);
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException, MdException {
        Log exportLogger = operation.getLogger();
        exportLogger.debug((Object)("BuinessRuleFlowExportListener Invoked, object count = " + objects.size()));
        if (operation.getPromotionType() == 2) {
            exportLogger.debug((Object)"Copy/Paste Operation ...");
            return super.exportContent(operation, objects);
        }
        exportLogger.debug((Object)"Export Operation ...");
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        int exportedItemsCount = 1;
        String name = null;
        int returnCode = 0;
        for (ExportItemInterface exportItem : objects) {
            try {
                String metaFQID = exportItem.getID();
                exportLogger.debug((Object)("Export item [" + exportedItemsCount++ + "] metadata ID = " + metaFQID));
                BusinessRuleFlowInterface smartObject = (BusinessRuleFlowInterface)PromotionUtil.getSmartObject((ServerInterface)operation.getServer(), (String)metaFQID, (String)"Transformation");
                name = smartObject.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowExportListener.StatusIndicator.fmt.txt"), (Object)name));
                for (String version : smartObject.getVersions()) {
                    exportLogger.debug((Object)("BusinessRuleFlowSmartObject object: " + name + " version: " + version + " (" + "BusinessRuleFlow" + ")"));
                    ByteArrayInputStream is = new ByteArrayInputStream(smartObject.getXml(version));
                    contentHandler.addBinaryContent(metaFQID, "BusinessRuleFlow-" + version, (InputStream)is);
                }
                exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowExportListener.ExportContentItemCount.fmt.txt"), (Object)Integer.toString(1), (Object)exportItem.toString()));
            }
            catch (Exception e) {
                returnCode = 8;
                String msg = null;
                msg = name == null ? RB.getStringResource("BusinessRuleFlowExportListener.ExportFailedGeneral.txt") : UtilMisc.getMessage((String)RB.getStringResource("BusinessRuleFlowExportListener.ExportFailedSpecific.fmt.txt"), name);
                exportLogger.error((Object)msg, (Throwable)e);
            }
        }
        exportLogger.debug((Object)"Done");
        return returnCode;
    }
}

