/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.bicommon;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.bicommon.RB;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UtilPromotion {
    public static final String PROMOTION_TYPE_STORED_PROCESS = "StoredProcess";
    public static final String PROMOTION_TYPE_INFORMATION_MAP = "InformationMap";
    public static final String PROMOTION_TYPE_INFORMATION_MAP_OLAP = "InformationMap.OLAP";
    public static final String PROMOTION_TYPE_INFORMATION_MAP_RELATIONAL = "InformationMap.Relational";
    public static final String PROMOTION_TYPE_BIP_REPORT = "Report";
    public static final String PROMOTION_TYPE_BIP_REPORT_IMAGE = "Report.Image";
    public static final String PROMOTION_TYPE_BIP_REPORT_COMPONENT = "Report.Component";
    public static final String PROMOTION_TYPE_DATA_EXPLORATION = "DataExploration";
    public static final String PROMOTION_TYPE_PROMPT_DEFINITION = "Prompt";
    public static final String PROMOTION_TYPE_PROMPT_GROUP = "PromptGroup";
    public static final String WD_ARCHIVE_MODELS = "BIManager.ARCHIVE_MODELS";
    public static final String WD_SOURCE_CODE_MODELS = "BIManager.SOURCE_CODE_MODELS";
    public static final String WD_LIBRARY_MAPPING = "BIManager.LIBRARY_MAPPING";
    public static final String WD_TABLE_MAPPING = "BIManager.TABLE_MAPPING";
    public static Map _smartObjectMap = new HashMap(3);

    public static String getPromotionLogFormatString() {
        return RB.getStringResource("Common.ImpExpLogObj.fmt.txt");
    }

    public static SimpleLogicalObjectInterface createSimpleLogicalObject(String name, String id, String type) throws RemoteException, LogicalTypeException {
        TypeInterface ti = Factory.getInstance().getTypeInterface(type);
        return type == null ? null : new SimpleLogicalObject(name, id, ti);
    }

    public static List getPromptValueSources(PromotionInterface promotionOperation, SimpleLogicalObjectInterface logicalObject, List input) throws LogicalTypeException {
        ArrayList<SimpleLogicalObjectInterface> retVal = null;
        retVal = input == null ? new ArrayList<SimpleLogicalObjectInterface>() : input;
        try {
            MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)promotionOperation, (SimpleLogicalObjectInterface)logicalObject);
            Log log = Log.getInstance((String)UtilPromotion.class.getName());
            log.debug((Object)("getPromptValueSources(), found smart obj named:" + mi.getName()));
            List pList = mi.getPrompts();
            if (!pList.isEmpty()) {
                for (BaseOMRPromptInterface promptSO : pList) {
                    List listSharedPrompts;
                    log.debug((Object)("getPromptValueSources(), found a prompt smart object named:" + promptSO.getName()));
                    List list = promptSO.getValueSources();
                    if (!list.isEmpty()) {
                        for (MetadataInterface valueSource : list) {
                            log.debug((Object)"ValueSource found:");
                            log.debug((Object)valueSource.getName());
                            log.debug((Object)valueSource.getReposId());
                            log.debug((Object)valueSource.getType());
                            SimpleLogicalObjectInterface obj = UtilPromotion.createSimpleLogicalObject(valueSource.getName(), valueSource.getReposId(), valueSource.getType());
                            if (obj == null) continue;
                            retVal.add(obj);
                        }
                    }
                    if ((listSharedPrompts = promptSO.getReferencedPrompts()).isEmpty()) continue;
                    for (MetadataInterface valueSource : listSharedPrompts) {
                        log.debug((Object)"Shared prompt found:");
                        log.debug((Object)valueSource.getName());
                        log.debug((Object)valueSource.getReposId());
                        log.debug((Object)valueSource.getType());
                        SimpleLogicalObjectInterface obj = UtilPromotion.createSimpleLogicalObject(valueSource.getName(), valueSource.getReposId(), valueSource.getType());
                        if (obj == null) continue;
                        retVal.add(obj);
                    }
                }
            }
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        return retVal;
    }

    static {
        _smartObjectMap.put("BriefInformationMap", RB.getStringResource("Common.InformationMap.txt"));
        _smartObjectMap.put(PROMOTION_TYPE_STORED_PROCESS, RB.getStringResource("Common.StoredProcess.txt"));
        _smartObjectMap.put(PROMOTION_TYPE_BIP_REPORT, RB.getStringResource("Common.Report.txt"));
        _smartObjectMap.put("Folder", RB.getStringResource("Common.Folder.txt"));
        _smartObjectMap.put("PromptDefinition", RB.getStringResource("Common.PromptDefinition.txt"));
        _smartObjectMap.put(PROMOTION_TYPE_PROMPT_GROUP, RB.getStringResource("Common.PromptGroup.txt"));
    }
}

