/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive.utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class YarnNodesHelper2 {
    private static HttpClient buildKerberosReadyHttpClient() {
        Credentials jaasCredntials = new Credentials(){

            public String getPassword() {
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }
        };
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(null, -1, null), jaasCredntials);
        Registry authSchemeRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true)).build();
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        return httpclient;
    }

    public static List<String> getRunningNodes(Configuration jobConf, String yarnResourceManager) throws IOException {
        HttpGet request;
        String responseBody = null;
        LinkedList<String> nodeList = new LinkedList<String>();
        if (yarnResourceManager == null || yarnResourceManager.length() == 0) {
            yarnResourceManager = jobConf.get("yarn.resourcemanager.webapp.address");
        }
        if (yarnResourceManager == null) {
            throw new IOException("YARN Resource Manager web application address not found. Make sure the yarn-site.xml exists and is in the class path. Also, make sure property yarn.resourcemanager.webapp.address is defined in the yarn-site.xml.");
        }
        String url = "http://" + yarnResourceManager + "/ws/v1/cluster/nodes";
        HttpClient client = YarnNodesHelper2.buildKerberosReadyHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)(request = new HttpGet(url)));
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            throw new IOException("ERROR : Unable to retrieve list of YARN nodes with a running Node Manager. URI: " + url + "  HTTP Reason phrase: " + response.getStatusLine().getReasonPhrase());
        }
        try {
            StringBuffer buffer = new StringBuffer();
            InputStreamReader reader = new InputStreamReader(response.getEntity().getContent());
            BufferedReader bufferedReader = new BufferedReader(reader);
            while ((responseBody = bufferedReader.readLine()) != null) {
                buffer.append(responseBody);
            }
            JSONObject jObject = new JSONObject(buffer.toString());
            JSONObject allNodes = jObject.getJSONObject("nodes");
            JSONArray nodesArray = allNodes.getJSONArray("node");
            for (int i = 0; i < nodesArray.length(); ++i) {
                String hostName = (String)nodesArray.getJSONObject(i).get("nodeHostName");
                String state = (String)nodesArray.getJSONObject(i).get("state");
                if (state.equalsIgnoreCase("DECOMMISSIONING") || state.equalsIgnoreCase("DECOMMISSIONED")) continue;
                nodeList.add(hostName);
            }
        }
        catch (JSONException e) {
            throw new IOException(e);
        }
        return nodeList;
    }
}

