/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive.utilities;

import com.sas.hadoop.serde.spde.hive.utilities.YarnNodesHelper2;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class AdminUtil
extends Configured
implements Tool {
    private Configuration config;

    public static String[] getLiveDataNodes(final Configuration conf, String userName) throws IOException, InterruptedException {
        String[] dataNodes = null;
        dataNodes = (String[])AdminUtil.getUserGroupInformation(conf, userName).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String[]>(){

            @Override
            public String[] run() throws Exception {
                TreeSet<String> hostSet = new TreeSet<String>();
                DistributedFileSystem dfs = (DistributedFileSystem)FileSystem.get((Configuration)conf);
                DatanodeInfo[] allNodes = dfs.getDataNodeStats();
                int nodelistLen = allNodes.length;
                String[] nodes = new String[nodelistLen];
                for (int i = 0; i < nodelistLen; ++i) {
                    if (allNodes[i].getAdminState() != DatanodeInfo.AdminStates.NORMAL) continue;
                    nodes[i] = InetAddress.getByName(allNodes[i].getHostName()).getCanonicalHostName();
                    hostSet.add(nodes[i]);
                }
                return hostSet.size() > 0 ? hostSet.toArray(new String[hostSet.size()]) : new String[]{};
            }
        });
        return dataNodes;
    }

    private void listDataNodes() throws Exception {
        String[] hosts = AdminUtil.getLiveDataNodes(this.config, null);
        if (hosts != null) {
            for (int i = 0; i < hosts.length; ++i) {
                System.out.print(hosts[i]);
                if (i >= hosts.length - 1) continue;
                System.out.print(" ");
            }
        }
    }

    private void listYarnNode(Configuration conf, final String yarnResourceManager) throws IOException {
        final JobConf jobConf = new JobConf(conf);
        List yarnNodes = null;
        try {
            yarnNodes = (List)AdminUtil.getUserGroupInformation(this.getConf(), null).doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<String>>(){

                @Override
                public List<String> run() throws Exception {
                    return YarnNodesHelper2.getRunningNodes((Configuration)jobConf, yarnResourceManager);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        Iterator it = yarnNodes.iterator();
        while (it.hasNext()) {
            String host = (String)it.next();
            System.out.print(host);
            if (!it.hasNext()) continue;
            System.out.print(" ");
        }
    }

    private void checkMapR() throws IOException {
        Logger logger = LogManager.getRootLogger();
        Configurator.setLevel((String)logger.getName(), (Level)Level.OFF);
        JobConf jobConf = new JobConf(this.config);
        String maprfs = this.config.get("fs.maprfs.impl", null);
        byte isMapr = (byte)(maprfs != null && maprfs.length() != 0 ? 1 : 0);
        System.out.print(isMapr);
    }

    public static synchronized UserGroupInformation getUserGroupInformation(Configuration config, String userName) throws IOException {
        if (config != null) {
            UserGroupInformation.setConfiguration((Configuration)config);
        }
        if (userName != null && userName.length() > 0) {
            return UserGroupInformation.createRemoteUser((String)userName);
        }
        return UserGroupInformation.getCurrentUser();
    }

    public int run(String[] args) throws Exception {
        int rc = 0;
        this.config = this.getConf();
        if (args.length > 0 && args[0] != null && args[0].trim().length() > 0) {
            String currentArg = args[0].trim();
            if (currentArg.equals("-listyarnnodes")) {
                String yarnResourceManager = null;
                if (args.length > 1) {
                    yarnResourceManager = args[1];
                }
                try {
                    this.listYarnNode(this.config, yarnResourceManager);
                }
                catch (ConnectException e) {
                    rc = -1;
                }
            } else if ("-isMapR".equals(currentArg)) {
                this.checkMapR();
            } else if (currentArg.equals("-gethadooplogin")) {
                System.out.println(System.getProperty("hadoop.login"));
            } else if (currentArg.equals("-listdatanodes")) {
                this.listDataNodes();
            } else {
                System.out.println("Invalid option: " + currentArg);
                rc = -1;
            }
        }
        return rc;
    }

    public static void main(String[] args) throws Exception {
        int rc = ToolRunner.run((Configuration)new Configuration(), (Tool)new AdminUtil(), (String[])args);
        System.exit(rc);
    }
}

