/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive;

import com.sas.hadoop.serde.spde.hive.FormatType;
import com.sas.hadoop.serde.spde.hive.utilities.SerdeUtils;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpdeSerDe
extends AbstractSerDe {
    private static final Logger logger = LogManager.getLogger(SpdeSerDe.class);
    private final boolean debugEnabled = logger.isDebugEnabled();
    private ObjectInspector rowOI;
    private List<Object> row;
    private int numColumns;
    private SerdeUtils.ColumnMeta[] columnMetaList;
    private static ByteOrder endianess;
    private static String encoding;
    private static final long minutesInSeconds = 60L;
    private static final long hoursInSeconds = 3600L;
    private static final TimeZone timezone;

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        if (this.debugEnabled) {
            logger.debug("SpdeSerde initialize() call.");
        }
        String columnNames_str = tbl.getProperty("columns");
        String columnTypes_str = tbl.getProperty("columns.types");
        String endianess_str = tbl.getProperty("spd.byte.order");
        endianess = endianess_str != null ? (endianess_str.equalsIgnoreCase(ByteOrder.LITTLE_ENDIAN.toString()) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN) : ByteOrder.LITTLE_ENDIAN;
        String table_encoding = tbl.getProperty("spd.encoding");
        encoding = table_encoding != null ? table_encoding : "windows-1252";
        String numColumns_str = tbl.getProperty("spd.column.count");
        if (numColumns_str != null) {
            try {
                this.numColumns = Integer.parseInt(numColumns_str);
            }
            catch (Exception e) {
                this.numColumns = 0;
            }
        } else {
            this.numColumns = 0;
        }
        if (this.numColumns != 0) {
            String[] columnNames = SerdeUtils.splitString(columnNames_str, ',', '\u0000', this.numColumns);
            this.numColumns = columnNames.length;
            ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypes_str);
            this.columnMetaList = new SerdeUtils.ColumnMeta[this.numColumns];
            ArrayList<Object> columnOIs = new ArrayList<Object>(this.numColumns);
            for (int i = 0; i < this.numColumns; ++i) {
                String className;
                String name = columnNames[i].toLowerCase();
                String type = ((TypeInfo)columnTypes.get(i)).getTypeName();
                String columnLength_str = FormatType.VARCHAR.equals(type) ? type.substring(8, type.length() - 1) : (!FormatType.STRING.equals(type) ? tbl.getProperty(name + ".length") : tbl.getProperty("SASFMT:" + name));
                String columnOffset_str = tbl.getProperty(name + ".offset");
                SerdeUtils.ColumnMeta col = new SerdeUtils.ColumnMeta(new SerdeUtils());
                if (columnLength_str != null && columnOffset_str != null) {
                    col.type = FormatType.VARCHAR.equals(type) ? FormatType.VARCHAR.getTypeName().toUpperCase() : type.toUpperCase();
                    if (FormatType.STRING.equals(col.type) && columnLength_str.startsWith("TIME")) {
                        columnLength_str = columnLength_str.substring(5, columnLength_str.length() - 3);
                        col.type = FormatType.TIME.getTypeName().toUpperCase();
                    }
                } else {
                    logger.error("SpdeSerDe.initialize: table properties missing either column length (" + columnLength_str + ") or column offset (" + columnOffset_str + ") for column '" + name + "'");
                    throw new SerDeException(SerdeUtils.getResourceBundle().getString("SerDe.missing.column.metadata.error.txt"));
                }
                col.col_len = Integer.parseInt(columnLength_str);
                col.col_offset = Integer.parseInt(columnOffset_str);
                this.columnMetaList[i] = col;
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)type);
                if (FormatType.TIME.equals(type)) {
                    columnOIs.add(PrimitiveObjectInspectorFactory.javaStringObjectInspector);
                    continue;
                }
                if (!(typeInfo instanceof PrimitiveTypeInfo)) continue;
                PrimitiveTypeInfo pti = (PrimitiveTypeInfo)typeInfo;
                AbstractPrimitiveJavaObjectInspector oi = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)pti);
                columnOIs.add(oi);
                if (FormatType.DATE.equals(type)) {
                    if (!oi.getJavaPrimitiveClass().equals(Date.class)) {
                        className = oi.getJavaPrimitiveClass().getName();
                        if (!className.equalsIgnoreCase("org.apache.hadoop.hive.common.type.Date")) {
                            logger.error("SpdeSerDe.initialize: Unexpected date column class " + className + " for column " + name);
                            throw new SerDeException(MessageFormat.format(SerdeUtils.getResourceBundle().getString("SerDe.initialize.unsupported.class.error.txt"), className, name));
                        }
                        if (this.debugEnabled) {
                            logger.debug("setting returned class for DATE column " + name + " to : " + className);
                        }
                        Type.DATE.setReturnedClass(className);
                        continue;
                    }
                    if (!this.debugEnabled) continue;
                    logger.debug("setting returned class for DATE column " + name + " to : java.sql.Date");
                    continue;
                }
                if (!FormatType.DATETIME.equals(type)) continue;
                if (!oi.getJavaPrimitiveClass().equals(Timestamp.class)) {
                    className = oi.getJavaPrimitiveClass().getName();
                    if (!className.equalsIgnoreCase("org.apache.hadoop.hive.common.type.Timestamp")) {
                        logger.error("SpdeSerDe.initialize: Unexpected datetime column class " + className + "for column " + name);
                        throw new SerDeException(MessageFormat.format(SerdeUtils.getResourceBundle().getString("SerDe.initialize.unsupported.class.error.txt"), className, name));
                    }
                    if (this.debugEnabled) {
                        logger.debug("setting returned class for DATETIME column " + name + " to : " + className);
                    }
                    Type.TIMESTAMP.setReturnedClass(className);
                    continue;
                }
                if (!this.debugEnabled) continue;
                logger.debug("setting returned class for TIMESTAMP column " + name + " to : java.sql.Timestamp");
            }
            String bytebuffer_str = tbl.getProperty("spd.record.length");
            if (bytebuffer_str != null) {
                conf.set("spd.record.length", bytebuffer_str);
            } else {
                conf.set("spd.record.length", "0");
            }
            String MDFlocation = tbl.getProperty("spd.mdf.location");
            if (MDFlocation != null) {
                conf.set("spd.mdf.location", MDFlocation);
            } else {
                conf.set("spd.mdf.location", "");
            }
            this.rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(Arrays.asList(columnNames), columnOIs);
            this.row = new ArrayList<Object>(this.numColumns);
            for (int c = 0; c < this.numColumns; ++c) {
                this.row.add(null);
            }
        }
    }

    public Object deserialize(Writable blob) throws SerDeException {
        BytesWritable rowText = (BytesWritable)blob;
        byte[] deserializedData = rowText.getBytes();
        for (int i = 0; i < this.numColumns; ++i) {
            SerdeUtils.ColumnMeta col = this.columnMetaList[i];
            if (col == null) {
                throw new SerDeException(SerdeUtils.getResourceBundle().getString("SerDe.missing.column.metadata.error.txt"));
            }
            String typeName = col.type;
            int col_len = col.col_len;
            Type type = Type.valueOf(typeName);
            this.row.set(i, type.read(deserializedData, col.col_offset, col_len));
        }
        return this.row;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowOI;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Class<? extends Writable> getSerializedClass() {
        return BytesWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new SerDeException(SerdeUtils.getResourceBundle().getString("SerDe.serialize.unsupported.txt"));
    }

    static {
        timezone = TimeZone.getDefault();
    }

    static enum Type {
        DATE{

            @Override
            public Object read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                Double date = (Double)DOUBLE.read(deserializedData, offsets, length);
                if (date != null) {
                    long javaDate = ((long)Math.floor(date) - 3653L) * 86400L * 1000L;
                    if (javaDate >= 253402318800000L) {
                        return null;
                    }
                    if (this.returnedClass == null) {
                        Calendar cal = Calendar.getInstance(timezone);
                        cal.setTimeInMillis(javaDate -= (long)timezone.getRawOffset());
                        return new Date(javaDate -= (long)cal.get(16));
                    }
                    org.apache.hadoop.hive.common.type.Date hiveCommonTypeDate = new org.apache.hadoop.hive.common.type.Date();
                    hiveCommonTypeDate.setTimeInMillis(javaDate);
                    return hiveCommonTypeDate;
                }
                return null;
            }
        }
        ,
        INT{

            @Override
            public Integer read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                Double db_value = (Double)DOUBLE.read(deserializedData, offsets, length);
                if (db_value == null) {
                    return null;
                }
                if (db_value > 2.147483647E9 || db_value < -2.147483648E9) {
                    throw new SerDeException(MessageFormat.format(SerdeUtils.getResourceBundle().getString("SerDe.int.out.of.range.fmt.txt"), db_value));
                }
                Integer value = db_value.intValue();
                return value;
            }
        }
        ,
        DOUBLE{

            @Override
            public Double read(byte[] deserializedData, int offsets, int length) {
                ByteBuffer buffer;
                if (length < 8) {
                    int i;
                    byte[] doubleArray = new byte[8];
                    Arrays.fill(doubleArray, (byte)0);
                    int lengthdiff = doubleArray.length - length;
                    if (endianess == ByteOrder.BIG_ENDIAN) {
                        for (i = 0; i < length; ++i) {
                            doubleArray[i] = deserializedData[offsets + i];
                        }
                        buffer = ByteBuffer.wrap(doubleArray).order(endianess);
                    } else {
                        for (i = length - 1; i >= 0; --i) {
                            doubleArray[i + lengthdiff] = deserializedData[offsets + i];
                        }
                        buffer = ByteBuffer.wrap(doubleArray).order(endianess);
                    }
                } else {
                    buffer = ByteBuffer.wrap(deserializedData, offsets, length).order(endianess);
                }
                double db = buffer.asDoubleBuffer().get();
                Double value = db;
                if (value.isNaN()) {
                    return null;
                }
                return value;
            }
        }
        ,
        SMALLINT{

            @Override
            public Short read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                Double db_value = (Double)DOUBLE.read(deserializedData, offsets, length);
                if (db_value == null) {
                    return null;
                }
                if (db_value > 32767.0 || db_value < -32768.0) {
                    throw new SerDeException(MessageFormat.format(SerdeUtils.getResourceBundle().getString("SerDe.smallint.out.of.range.fmt.txt"), db_value));
                }
                Short value = db_value.shortValue();
                return value;
            }
        }
        ,
        TIMESTAMP{

            @Override
            public Object read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                Double datetime = (Double)DOUBLE.read(deserializedData, offsets, length);
                if (datetime != null) {
                    long javaDate = (long)((datetime - 3.156192E8) * 1000.0);
                    if (this.returnedClass == null) {
                        Calendar cal = Calendar.getInstance(timezone);
                        cal.setTimeInMillis(javaDate -= (long)timezone.getRawOffset());
                        return new Timestamp(javaDate -= (long)cal.get(16));
                    }
                    org.apache.hadoop.hive.common.type.Timestamp hiveCommonTypeTimestamp = new org.apache.hadoop.hive.common.type.Timestamp();
                    hiveCommonTypeTimestamp.setTimeInMillis(javaDate);
                    return hiveCommonTypeTimestamp;
                }
                return null;
            }
        }
        ,
        TIME{

            @Override
            public String read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                Double rawSASValue = (Double)DOUBLE.read(deserializedData, offsets, length);
                if (rawSASValue != null) {
                    long sasvalue = rawSASValue.longValue();
                    long elapsedHours = sasvalue / 3600L;
                    long elapsedMinutes = (sasvalue %= 3600L) / 60L;
                    long elapsedSeconds = sasvalue %= 60L;
                    return String.format("%02d:%02d:%02d", elapsedHours, elapsedMinutes, elapsedSeconds);
                }
                return null;
            }
        }
        ,
        VARCHAR{

            public HiveVarchar read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                try {
                    int end;
                    String tmp = new String(deserializedData, offsets, length, encoding);
                    for (end = tmp.length() - 1; end >= 0 && tmp.charAt(end) == ' '; --end) {
                    }
                    if (++end == 0) {
                        return null;
                    }
                    HiveVarchar varchar = new HiveVarchar(tmp.substring(0, end), end);
                    return varchar;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SerDeException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        ,
        STRING{

            @Override
            public String read(byte[] deserializedData, int offsets, int length) throws SerDeException {
                try {
                    String str = new String(deserializedData, offsets, length, encoding);
                    if (str.trim().length() == 0) {
                        return null;
                    }
                    return str;
                }
                catch (UnsupportedEncodingException e) {
                    throw new SerDeException(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        };

        String returnedClass = null;

        public abstract Object read(byte[] var1, int var2, int var3) throws SerDeException;

        public void setReturnedClass(String className) {
            this.returnedClass = className;
        }
    }
}

