/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive;

import com.sas.hadoop.serde.spde.hive.DateFormats;
import com.sas.hadoop.serde.spde.hive.FormatType;
import com.sas.hadoop.serde.spde.hive.utilities.SerdeUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;

public class SPDMDFReader {
    private static final int RV_ENDIAN_BYTE = 9;
    private static final int RV_DOUBLE_BYTE = 7;
    private static final int RV_INT64_BYTE = 15;
    private static final byte ALIGN_8 = 3;
    private static final int DA_XOECOMPRESSED = 1;
    private static final int DA_XOEENCRYPTED = 2;
    private static final int DA_XOESASPW = 4;
    private static final int DA_XOETKENCRYPTED = 0x100000;
    private static final int SPDE_RV_INCOM64 = 1;
    private static final int SPDE_RV_INCOMMDF = 11;
    private static final int SPDE_RV_INCOMIDX = 12;
    private static final int SPDE_RV_INCOMCKY = 256;
    private static final int SPDE_RV_INCOMENCIDX = 512;
    private static String javaEncoding;
    private static ByteOrder BYTE_ORDER;
    private static int LONG_LENGTH;
    private static int DOUBLE_LENGTH;
    private static int INT_LENGTH;
    private static int SHORT_LENGTH;
    private static int BYTE_LENGTH;
    private boolean align_double = true;
    private boolean align_int64 = true;
    private final int STRING_TYPE = 2;
    private final int DA_STRPHEAD_OFFSET = 12;
    private final int DA_STRPOFFSET_OFFSET = 56;
    private long DA_DSFHEAD;
    private long DA_DSFXOEHEAD;
    private long DA_DSFNAMESTR;
    private long DA_DSFIDXHEAD;
    private long DA_DSFDATAFIB;
    private long DA_DSFDELMAP;
    private long DA_DSFSORT;
    private long DA_DSFOWNER;
    private long DA_DSFVBHEAD;
    private long DA_DSFXCHEAD;
    private long DA_DSFSTRPHEAD;
    private long DA_DSFBACKUP;
    private long DA_DSFISTATS;
    private long DA_DSFCOLCKY;
    private int botused;
    private int creflags;
    private byte[] dsreqv1;
    private byte[] dsrvgro;
    private int dsrvhdr;
    private int dsrvico;
    private short dsrvlen;
    private short dsrvver;
    private int encryptmode;
    private long encrypttime;
    private int encrypttype;
    private byte[] encryptvalid;
    private long filesize;
    private int flags;
    private int freesegoff;
    private int hdr_NE_info;
    private int hdr_length;
    private int hdr_version;
    private int hipath;
    private int mdtype;
    private int modtime;
    private int namelen;
    private int nfreeseg;
    private int numpde;
    private int numstripes;
    private int ods_length;
    private int ods_version;
    private int origtime;
    private long overflow;
    private int pdesize;
    private long pub_idxsegsize;
    private int pub_ioreclen;
    private long pub_numdelete;
    private long pub_numobs;
    private int pub_obslen;
    private int pub_odsreclen;
    private long pub_partfactor;
    private long pub_partsize;
    private byte[] requirementsVector;
    private int revision;
    private int sasver;
    private int stripesize;
    private int topused;
    private int nvar;
    private int DPFnumpde = 0;
    private final String locale;
    private final int encoding;
    private final String systemName;
    private final String language;
    boolean isSPDS = false;
    boolean isEncrypted = false;
    boolean isCompressed = false;
    boolean isPasswordProtected = false;
    private FSDataInputStream in;

    public SPDMDFReader(String mdfFileName, JobConf jobConf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        Path mdfPath = new Path(mdfFileName);
        this.in = fs.open(mdfPath);
        this.dsrvhdr = this.readInt();
        byte[] bytes = this.readBytes(2);
        this.dsrvver = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getShort();
        bytes = this.readBytes(2);
        this.dsrvlen = ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN).getShort();
        this.requirementsVector = this.readBytes(24);
        this.dsrvgro = this.readBytes(32);
        byte[] dsrvicoByte = this.readBytes(4);
        this.dsrvico = ByteBuffer.wrap(dsrvicoByte).order(BYTE_ORDER).getInt();
        this.dsreqv1 = this.readBytes(24);
        if (this.requirementsVector[0] == 0) {
            this.isSPDS = true;
        } else if (this.dsrvico != 0) {
            this.storeRVInfo(this.dsreqv1);
            if (BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
                this.dsrvico = ByteBuffer.wrap(dsrvicoByte).order(BYTE_ORDER).getInt();
            }
            int reason_code = this.dsrvico;
            if ((this.dsrvico & 0xB) == 11) {
                throw new IOException(SerdeUtils.getResourceBundle().getString("metastore.registration.table.unsupported.encrypted.error.txt"));
            }
            if ((reason_code & 1) == 1) {
                reason_code &= 0xFFFFFFFE;
            }
            if ((reason_code & 0xC) == 12) {
                reason_code &= 0xFFFFFFF3;
            }
            if ((reason_code & 0x100) == 256) {
                reason_code &= 0xFFFFFEFF;
            }
            if ((reason_code & 0x200) == 512) {
                reason_code &= 0xFFFFFDFF;
            }
            if (reason_code != 0) {
                throw new IOException(SerdeUtils.getResourceBundle().getString("SPDMDFReader.table.unsupported.feature.error.txt"));
            }
        } else {
            this.storeRVInfo(this.requirementsVector);
        }
        this.encrypttime = this.readLong();
        this.encrypttype = this.readInt();
        this.encryptmode = this.readInt();
        this.encryptvalid = this.readBytes(12);
        this.seek(this.dsrvlen);
        this.hdr_NE_info = this.readInt();
        if (this.hdr_NE_info == 2 || this.hdr_NE_info == 4 || this.hdr_NE_info == 5) {
            this.isEncrypted = true;
            throw new IOException(SerdeUtils.getResourceBundle().getString("metastore.registration.table.unsupported.encrypted.error.txt"));
        }
        this.hdr_version = this.readInt();
        this.hdr_length = this.readInt();
        this.overflow = this.readAlignedLong(0L);
        this.filesize = this.readAlignedLong(0L);
        this.modtime = this.readInt();
        this.revision = this.readInt();
        this.hipath = this.readInt();
        this.pdesize = this.readInt();
        this.numpde = this.readInt();
        this.topused = this.readInt();
        this.botused = this.readInt();
        this.numstripes = this.readInt();
        this.stripesize = this.readInt();
        this.nfreeseg = this.readInt();
        this.freesegoff = this.readInt();
        this.creflags = this.readInt();
        this.namelen = this.readInt();
        this.DA_DSFHEAD = this.hdr_length + this.pdesize;
        this.seek(this.DA_DSFHEAD);
        this.ods_version = this.readInt();
        this.ods_length = this.readInt();
        this.origtime = this.readInt();
        this.sasver = this.readInt();
        this.flags = this.readInt();
        this.mdtype = this.readInt();
        this.DA_DSFXOEHEAD = this.readAlignedLong(this.DA_DSFHEAD);
        this.DA_DSFNAMESTR = this.readLong();
        this.DA_DSFIDXHEAD = this.readLong();
        this.DA_DSFDATAFIB = this.readLong();
        this.DA_DSFDELMAP = this.readLong();
        this.DA_DSFSORT = this.readLong();
        this.DA_DSFOWNER = this.readLong();
        this.DA_DSFVBHEAD = this.readLong();
        this.DA_DSFXCHEAD = this.readLong();
        this.DA_DSFSTRPHEAD = this.readLong();
        this.DA_DSFBACKUP = this.readLong();
        this.DA_DSFISTATS = this.readLong();
        this.DA_DSFCOLCKY = this.readLong();
        this.seek(this.DA_DSFXOEHEAD);
        this.skip(8L);
        this.pub_numobs = this.readLong();
        this.pub_numdelete = this.readLong();
        this.pub_idxsegsize = this.readLong();
        this.pub_partsize = this.readAlignedLong(this.DA_DSFXOEHEAD);
        this.pub_partfactor = this.readLong();
        this.pub_odsreclen = this.readInt();
        this.pub_ioreclen = this.readInt();
        this.pub_obslen = this.readInt();
        this.skip(12L);
        this.nvar = this.readInt();
        if (this.align_double) {
            this.skip(68L);
        } else {
            this.skip(64L);
        }
        byte[] localebytes = this.readBytes(32);
        this.locale = new String(localebytes).trim();
        this.encoding = this.readInt();
        this.skip(8L);
        byte[] langbytes = this.readBytes(4);
        this.language = new String(langbytes).trim();
        this.skip(4L);
        int flags = this.readInt();
        if ((flags & 1) != 0) {
            this.isCompressed = true;
        }
        if ((flags & 2) != 0 || (flags & 0x100000) != 0) {
            this.isEncrypted = true;
        }
        if ((flags & 4) != 0) {
            this.isPasswordProtected = true;
        }
        this.skip(24L);
        byte[] sysnamebytes = this.readBytes(8);
        this.systemName = new String(sysnamebytes).trim();
    }

    public String[] getDPFnames() throws IOException {
        int i;
        long blockStart = this.DA_DSFDATAFIB;
        long overflow = 0L;
        do {
            blockStart = overflow == 0L ? this.DA_DSFDATAFIB : overflow;
            this.seek(blockStart + 136L);
        } while ((overflow = this.readLong()) != 0L);
        this.skip(24L);
        this.DPFnumpde = this.readInt();
        if (this.align_double) {
            this.skip(100L);
        } else {
            this.skip(96L);
        }
        int[] dpfLength = new int[this.DPFnumpde];
        int[] dpfOffset = new int[this.DPFnumpde];
        String[] dpfnames = new String[this.DPFnumpde];
        for (i = 0; i < this.DPFnumpde; ++i) {
            dpfLength[i] = this.readInt();
            dpfOffset[i] = this.readInt();
        }
        for (i = 0; i < this.DPFnumpde; ++i) {
            this.seek(blockStart + (long)dpfOffset[i]);
            byte[] dpfbyteArray = this.readBytes(dpfLength[i]);
            dpfnames[i] = new String(dpfbyteArray);
        }
        return dpfnames;
    }

    public SerdeUtils.ColumnMeta[] getColumnInfo() throws IOException {
        int var_count = this.getNumofColumns();
        if (this.DA_DSFNAMESTR <= 0L || var_count <= 0) {
            throw new IOException(SerdeUtils.getResourceBundle().getString("metastore.registration.table.invalid.no.columns.error.txt"));
        }
        this.seek(this.DA_DSFNAMESTR);
        SerdeUtils.ColumnMeta[] colmetaList = new SerdeUtils.ColumnMeta[var_count];
        for (int i = 0; i < var_count; ++i) {
            colmetaList[i] = new SerdeUtils.ColumnMeta(new SerdeUtils());
            colmetaList[i].col_offset = this.readInt();
            this.skip(12L);
            colmetaList[i].col_len = this.readInt();
            this.skip(12L);
            colmetaList[i].name_offset = this.readInt();
            this.skip(4L);
            colmetaList[i].format_offset = this.readInt();
            this.skip(4L);
            colmetaList[i].name_len = this.readShort();
            this.skip(2L);
            colmetaList[i].formatname_len = this.readShort();
            this.skip(2L);
            colmetaList[i].format_len = this.readShort();
            this.skip(10L);
            if (this.readByte() == 2) {
                colmetaList[i].type = FormatType.VARCHAR.getTypeName();
            }
            this.skip(7L);
        }
        long strp_start = this.DA_DSFSTRPHEAD + 12L;
        long strp_offset = this.DA_DSFSTRPHEAD + 56L;
        this.seek(strp_start);
        int sectsize = this.readInt();
        int numSects = this.readInt();
        this.seek(strp_offset);
        long[] nameblocks = new long[numSects];
        for (int i = 0; i < numSects; ++i) {
            nameblocks[i] = this.readLong();
        }
        int idx = 0;
        long namebuff_offset = nameblocks[idx] + 12L;
        int endOfBlock = sectsize * (idx + 1);
        for (int i = 0; i < var_count; ++i) {
            String str;
            SerdeUtils.ColumnMeta columnMeta = colmetaList[i];
            if (columnMeta.name_offset >= endOfBlock) {
                namebuff_offset = nameblocks[++idx] + 12L;
                endOfBlock = sectsize * (idx + 1);
            }
            int name_offset = columnMeta.name_offset % sectsize;
            this.seek(namebuff_offset + (long)name_offset);
            byte[] byteArray = this.readBytes(columnMeta.name_len);
            columnMeta.name = str = new String(byteArray, this.CeiToJavaEncoding());
            int formatnamelen = columnMeta.formatname_len;
            int formatlen = columnMeta.format_len;
            if (columnMeta.type != null) continue;
            if (formatnamelen > 0 && columnMeta.format_offset > -1) {
                if (columnMeta.format_offset >= endOfBlock) {
                    namebuff_offset = nameblocks[++idx] + 12L;
                    endOfBlock = sectsize * (idx + 1);
                }
                int fmt_offset = columnMeta.format_offset % sectsize;
                this.seek(namebuff_offset + (long)fmt_offset);
                byte[] formatbyteArray = this.readBytes(formatnamelen);
                String formatname = new String(formatbyteArray);
                try {
                    DateFormats.FORMATNAME format_name = DateFormats.FORMATNAME.valueOf(formatname);
                    if (DateFormats.dateFormatMap.containsKey((Object)format_name)) {
                        FormatType formattype = DateFormats.dateFormatMap.get((Object)format_name);
                        columnMeta.type = formattype.getTypeName();
                    }
                }
                catch (IllegalArgumentException e) {
                    columnMeta.type = FormatType.DOUBLE.getTypeName();
                }
            } else if (formatlen > 0) {
                if (formatlen >= 1 && formatlen <= 4) {
                    columnMeta.type = FormatType.SMALLINT.getTypeName();
                } else if (formatlen >= 5 && formatlen <= 9) {
                    columnMeta.type = FormatType.INT.getTypeName();
                }
            }
            if (colmetaList[i].type != null) continue;
            colmetaList[i].type = FormatType.DOUBLE.getTypeName();
        }
        return colmetaList;
    }

    public void storeRVInfo(byte[] RV) {
        byte testByte = RV[7];
        if ((testByte & 3) != 3) {
            this.align_double = false;
        }
        if (((testByte = RV[15]) & 3) != 3) {
            this.align_int64 = false;
        }
        BYTE_ORDER = RV[9] == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public String CeiToJavaEncoding() throws IOException {
        if (javaEncoding != null) {
            return javaEncoding;
        }
        InputStream input = this.getClass().getResourceAsStream("Encoding.txt");
        int linelength = 32;
        int encoding_startpos = 7;
        long newPosition = (this.getEncoding() - 1) * 32;
        try {
            input.skip(newPosition);
            byte[] buffer = new byte[32];
            input.read(buffer);
            javaEncoding = new String(buffer, 7, 21);
            javaEncoding = javaEncoding.trim();
            if (javaEncoding.length() > 0) {
                return javaEncoding;
            }
        }
        catch (IOException e) {
            throw new CharacterCodingException();
        }
        throw new CharacterCodingException();
    }

    public FSDataInputStream getInputStream() {
        return this.in;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void skip(long bytes) throws IOException {
        this.in.skip(bytes);
    }

    public void seek(long location) throws IOException {
        this.in.seek(location);
    }

    public int fillBuffer(byte[] buffer) throws IOException {
        int bytesCount;
        int bytesRead = 0;
        for (bytesCount = 0; bytesCount < buffer.length; bytesCount += bytesRead) {
            bytesRead = this.in.read(buffer, bytesCount, buffer.length - bytesCount);
            if (bytesRead >= 0) continue;
            throw new EOFException();
        }
        if (bytesCount < buffer.length) {
            throw new EOFException();
        }
        return bytesCount;
    }

    public int readInt() throws IOException {
        byte[] intByte = new byte[INT_LENGTH];
        this.fillBuffer(intByte);
        return ByteBuffer.wrap(intByte).order(BYTE_ORDER).getInt();
    }

    public short readShort() throws IOException {
        byte[] shortByte = new byte[SHORT_LENGTH];
        this.fillBuffer(shortByte);
        return ByteBuffer.wrap(shortByte).order(BYTE_ORDER).getShort();
    }

    public byte readByte() throws IOException {
        byte[] oneByte = new byte[BYTE_LENGTH];
        this.fillBuffer(oneByte);
        return oneByte[0];
    }

    public byte[] readBytes(int numBytes) throws IOException {
        byte[] bytes = new byte[numBytes];
        this.fillBuffer(bytes);
        return bytes;
    }

    public long readLong() throws IOException {
        byte[] longByte = new byte[LONG_LENGTH];
        this.fillBuffer(longByte);
        return ByteBuffer.wrap(longByte).order(BYTE_ORDER).getLong();
    }

    public long readAlignedLong(long struct_start) throws IOException {
        if (this.align_int64) {
            this.align8Byte(struct_start);
        }
        return this.readLong();
    }

    public double readDouble(long struct_start) throws IOException {
        if (this.align_double) {
            this.align8Byte(struct_start);
        }
        byte[] doubleByte = new byte[DOUBLE_LENGTH];
        this.fillBuffer(doubleByte);
        return ByteBuffer.wrap(doubleByte).order(BYTE_ORDER).getDouble();
    }

    private void align8Byte(long struct_start) throws IOException {
        long position = this.in.getPos();
        long offset = position - struct_start;
        long currAlign = offset % 8L;
        if (currAlign != 0L) {
            this.skip(8L - currAlign);
        }
    }

    public ByteOrder getByteOrder() {
        return BYTE_ORDER;
    }

    public long getDA_DSFHEAD() {
        return this.DA_DSFHEAD;
    }

    public long getDA_DSFXOEHEAD() {
        return this.DA_DSFXOEHEAD;
    }

    public long getDA_DSFNAMESTR() {
        return this.DA_DSFNAMESTR;
    }

    public long getDA_DSFIDXHEAD() {
        return this.DA_DSFIDXHEAD;
    }

    public long getDA_DSFDATAFIB() {
        return this.DA_DSFDATAFIB;
    }

    public long getDA_DSFDELMAP() {
        return this.DA_DSFDELMAP;
    }

    public long getDA_DSFSORT() {
        return this.DA_DSFSORT;
    }

    public long getDA_DSFOWNER() {
        return this.DA_DSFOWNER;
    }

    public long getDA_DSFVBHEAD() {
        return this.DA_DSFVBHEAD;
    }

    public long getDA_DSFXCHEAD() {
        return this.DA_DSFXCHEAD;
    }

    public long getDA_DSFSTRPHEAD() {
        return this.DA_DSFSTRPHEAD;
    }

    public long getDA_DSFBACKUP() {
        return this.DA_DSFBACKUP;
    }

    public long getDA_DSFISTATS() {
        return this.DA_DSFISTATS;
    }

    public long getDA_DSFCOLCKY() {
        return this.DA_DSFCOLCKY;
    }

    public int getBotused() {
        return this.botused;
    }

    public int getCreflags() {
        return this.creflags;
    }

    public byte[] getDsreqv1() {
        return this.dsreqv1;
    }

    public byte[] getDsrvgro() {
        return this.dsrvgro;
    }

    public int getDsrvhdr() {
        return this.dsrvhdr;
    }

    public int getDsrvico() {
        return this.dsrvico;
    }

    public short getDsrvlen() {
        return this.dsrvlen;
    }

    public short getDsrvver() {
        return this.dsrvver;
    }

    public int getEncryptmode() {
        return this.encryptmode;
    }

    public long getEncrypttime() {
        return this.encrypttime;
    }

    public int getEncrypttype() {
        return this.encrypttype;
    }

    public byte[] getEncryptvalid() {
        return this.encryptvalid;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getFreesegoff() {
        return this.freesegoff;
    }

    public int getHdr_NE_info() {
        return this.hdr_NE_info;
    }

    public int getHdr_length() {
        return this.hdr_length;
    }

    public int getHdr_version() {
        return this.hdr_version;
    }

    public int getHipath() {
        return this.hipath;
    }

    public int getMdtype() {
        return this.mdtype;
    }

    public int getModtime() {
        return this.modtime;
    }

    public int getNamelen() {
        return this.namelen;
    }

    public int getNfreeseg() {
        return this.nfreeseg;
    }

    public int getNumpde() {
        return this.numpde;
    }

    public int getNumstripes() {
        return this.numstripes;
    }

    public int getOds_length() {
        return this.ods_length;
    }

    public int getOds_version() {
        return this.ods_version;
    }

    public int getOrigtime() {
        return this.origtime;
    }

    public long getOverflow() {
        return this.overflow;
    }

    public int getPdesize() {
        return this.pdesize;
    }

    public long getPub_idxsegsize() {
        return this.pub_idxsegsize;
    }

    public int getPub_ioreclen() {
        return this.pub_ioreclen;
    }

    public long getNumberDeleted() {
        return this.pub_numdelete;
    }

    public long getNumberOfObservations() {
        return this.pub_numobs;
    }

    public int getObservationLength() {
        return this.pub_obslen;
    }

    public int getPub_odsreclen() {
        return this.pub_odsreclen;
    }

    public long getPub_partfactor() {
        return this.pub_partfactor;
    }

    public long getPub_partsize() {
        return this.pub_partsize;
    }

    public byte[] getRequirementsVector() {
        return this.requirementsVector;
    }

    public int getRevision() {
        return this.revision;
    }

    public int getSasver() {
        return this.sasver;
    }

    public int getStripesize() {
        return this.stripesize;
    }

    public int getTopused() {
        return this.topused;
    }

    public String getLocale() {
        return this.locale;
    }

    public int getEncoding() {
        return this.encoding;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public String getLanguage() {
        return this.language;
    }

    public boolean isSPDS() {
        return this.isSPDS;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isPasswordProtected() {
        return this.isPasswordProtected;
    }

    public int getNumofColumns() {
        return this.nvar;
    }

    public int getDPFnumpde() {
        return this.DPFnumpde;
    }

    static {
        BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
        LONG_LENGTH = 8;
        DOUBLE_LENGTH = 8;
        INT_LENGTH = 4;
        SHORT_LENGTH = 2;
        BYTE_LENGTH = 1;
    }
}

