/*
 * Decompiled with CFR 0.152.
 */
package com.sas.hadoop.serde.spde.hive;

import com.sas.hadoop.serde.spde.hive.FormatType;
import com.sas.hadoop.serde.spde.hive.MdfFilter;
import com.sas.hadoop.serde.spde.hive.SPDInputParms;
import com.sas.hadoop.serde.spde.hive.SPDMDFReader;
import com.sas.hadoop.serde.spde.hive.utilities.SerdeUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetastoreRegistration
extends Configured
implements Tool {
    private static final Logger logger = LogManager.getLogger(MetastoreRegistration.class);
    private final boolean debugEnabled = logger.isDebugEnabled();
    private final boolean traceEnabled = logger.isTraceEnabled();
    private static final String SPDE_SERDE_VERSION_NUMBER = "9.43";
    private String DPFLOCATION = null;
    private HashMap<String, String> tableprop;

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Usage: MetastoreRegistration\n    -table          <Required: Table name on HDFS location>\n    -mdflocation    <Required: HDFS directory location containing the MDF file>\n    -renametable    <Optional: Rename table name>\n    -database       <Optional: Assign database name>\n    -owner          <Optional: Assign owner name>\n");
            System.exit(-1);
        }
        int exitCode = ToolRunner.run((Tool)new MetastoreRegistration(), (String[])args);
        System.exit(exitCode);
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        JobConf jobConf = new JobConf(conf);
        String tablename = null;
        String dbname = null;
        String newtablename = null;
        String owner = null;
        String MDFLOCATION = null;
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i].equalsIgnoreCase("-table")) {
                tablename = args[i + 1];
            } else if (args[i].equalsIgnoreCase("-mdflocation")) {
                MDFLOCATION = args[i + 1];
            } else if (args[i].equalsIgnoreCase("-renametable")) {
                newtablename = args[i + 1];
            } else if (args[i].equalsIgnoreCase("-database")) {
                dbname = args[i + 1];
            } else if (args[i].equalsIgnoreCase("-owner")) {
                owner = args[i + 1];
            }
            ++i;
        }
        String language = Locale.getDefault().getLanguage();
        String country = Locale.getDefault().getCountry();
        SPDInputParms.USER_LOCALE_LANGUAGE.setConfigParm(language);
        SPDInputParms.USER_LOCALE_COUNTRY.setConfigParm(country);
        String MDF_FILENAME = this.getMDFfilename(jobConf, tablename, MDFLOCATION);
        if (newtablename == null) {
            newtablename = tablename;
        }
        if (dbname == null) {
            dbname = "default";
        }
        if (owner == null) {
            owner = "anonymous";
        }
        this.tableprop = new HashMap();
        HiveConf hiveConfig = new HiveConf(conf, ((Object)((Object)this)).getClass());
        HiveMetaStoreClient metastore = SerdeUtils.getHiveMetaStoreClient(hiveConfig);
        if (metastore.tableExists(dbname, newtablename)) {
            logger.error("Table " + dbname + "." + newtablename + " is already registered in the Hive metastore.");
            return 1;
        }
        ArrayList<FieldSchema> fs_list = null;
        fs_list = this.getMetadata(jobConf, fs_list, MDF_FILENAME);
        if (this.DPFLOCATION == null) {
            throw new RuntimeException(SerdeUtils.getResourceBundle().getString("SPDInputformat.dpf.file.not.found.error.txt"));
        }
        HashMap<String, String> serdeparms = new HashMap<String, String>();
        serdeparms.put("serialization.format", "1");
        SerDeInfo serdeinfo = new SerDeInfo("serde", "com.sas.hadoop.serde.spde.hive.SpdeSerDe", serdeparms);
        StorageDescriptor sd = new StorageDescriptor(fs_list, this.DPFLOCATION, "com.sas.hadoop.serde.spde.hive.SPDInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat", false, -1, serdeinfo, new ArrayList(), new ArrayList(), new HashMap());
        Table tbl = new Table(newtablename, dbname, owner, 0, 0, 0, sd, new ArrayList(), this.tableprop, "", "", TableType.EXTERNAL_TABLE.toString());
        this.tableprop.put("EXTERNAL", "TRUE");
        metastore.createTable(tbl);
        logger.info(MessageFormat.format(SerdeUtils.getResourceBundle().getString("metastore.registration.table.registered.txt"), dbname, newtablename));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<FieldSchema> getMetadata(JobConf jobconf, ArrayList<FieldSchema> fs_list, String mdffilename) throws IOException {
        try (SPDMDFReader readMDF = null;){
            readMDF = new SPDMDFReader(mdffilename, jobconf);
            if (readMDF.isSPDS) {
                String msg = SerdeUtils.getResourceBundle().getString("metastore.registration.table.unsupported.spds.error.txt");
                logger.error(msg);
                throw new IOException(msg);
            }
            if (readMDF.isCompressed) {
                String msg = SerdeUtils.getResourceBundle().getString("metastore.registration.table.unsupported.compressed.error.txt");
                logger.error(msg);
                throw new IOException(msg);
            }
            if (readMDF.isEncrypted) {
                String msg = SerdeUtils.getResourceBundle().getString("metastore.registration.table.unsupported.encrypted.error.txt");
                logger.error(msg);
                throw new IOException(msg);
            }
            if (readMDF.isPasswordProtected) {
                String msg = SerdeUtils.getResourceBundle().getString("metastore.registration.table.unsupported.passwordprotected.error.txt");
                logger.error(msg);
                throw new IOException(msg);
            }
            this.tableprop.put("spd.byte.order", readMDF.getByteOrder().toString());
            this.tableprop.put("spd.mdf.location", mdffilename);
            this.tableprop.put("spd.record.length", Integer.toString(readMDF.getObservationLength()));
            String tableEncoding = readMDF.CeiToJavaEncoding();
            this.tableprop.put("spd.encoding", tableEncoding);
            this.tableprop.put("spde.serde.version.number", SPDE_SERDE_VERSION_NUMBER);
            String[] DPFfilenames = readMDF.getDPFnames();
            if (DPFfilenames.length > 0) {
                Path dpfpath = new Path(DPFfilenames[0]);
                Path dpfparent = dpfpath.getParent();
                Path fspath = dpfparent.getFileSystem((Configuration)jobconf).makeQualified(dpfparent);
                this.DPFLOCATION = fspath.toString();
                logger.debug("DPFLOCATION set to " + this.DPFLOCATION);
            }
            SerdeUtils.ColumnMeta[] columnMetaList = readMDF.getColumnInfo();
            int numofcolumns = readMDF.getNumofColumns();
            this.tableprop.put("spd.column.count", Integer.toString(numofcolumns));
            fs_list = new ArrayList();
            for (int i = 0; i < numofcolumns; ++i) {
                SerdeUtils.ColumnMeta currColumnMeta = columnMetaList[i];
                String str = currColumnMeta.name;
                String type = currColumnMeta.type;
                if (this.traceEnabled) {
                    logger.trace("Column name: " + str);
                    logger.trace("Column type: " + type);
                }
                String lcStr = str.toLowerCase();
                if (type.equalsIgnoreCase(FormatType.VARCHAR.getTypeName())) {
                    type = FormatType.VARCHAR.getTypeName() + "(" + currColumnMeta.col_len + ")";
                } else if (type.equalsIgnoreCase("time")) {
                    this.tableprop.put("SASFMT:" + lcStr, "TIME(" + Integer.toString(currColumnMeta.col_len) + ".0)");
                    type = FormatType.STRING.getTypeName();
                } else {
                    this.tableprop.put(lcStr + ".length", Integer.toString(currColumnMeta.col_len));
                }
                this.tableprop.put(lcStr + ".offset", Integer.toString(currColumnMeta.col_offset));
                fs_list.add(new FieldSchema(str, type, null));
            }
        }
        return fs_list;
    }

    private String getMDFfilename(JobConf jobconf, String tablename, String mdflocation) throws IOException {
        Path directoryPath;
        FileSystem fs = FileSystem.get((Configuration)jobconf);
        if (fs.isDirectory(directoryPath = new Path(mdflocation))) {
            MdfFilter filter = new MdfFilter(tablename, fs);
            FileStatus[] fileList = fs.listStatus(directoryPath, (PathFilter)filter);
            if (fileList.length > 0) {
                if (this.debugEnabled) {
                    logger.debug("MDF path:" + fileList[0].getPath().toString());
                }
                return fileList[0].getPath().toString();
            }
            String msg = SerdeUtils.getResourceBundle().getString("SPDInputformat.mdf.file.not.found.error.txt");
            logger.error(msg);
            throw new IOException(msg);
        }
        String msg = SerdeUtils.getResourceBundle().getString("metastore.registration.table.invalid.location.error.txt");
        logger.error(msg);
        throw new IOException(msg);
    }
}

