/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.subscription;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.subscription.CorruptSubscriptionException;
import com.atomikos.subscription.ExpiredSubscriptionException;
import com.atomikos.subscription.NoSubscriptionFoundException;
import com.atomikos.subscription.SignedSubscription;
import com.atomikos.subscription.SubscriptionException;
import java.io.File;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;

public class SubscriptionVerifier {
    private static Logger LOGGER = LoggerFactory.createLogger(SubscriptionVerifier.class);
    public static final String DEFAULT_PROPERTY_FILE_NAME = "atomikos-subscription.properties";
    public static final String DEFAULT_SIGNATURE_FILE_NAME = "atomikos-subscription.properties.sig";
    public static final String SUBSCRIPTION_FOLDER = "com.atomikos.icatch.subscription_folder";
    private static final String DEV_ONLY_MESSAGE = "Without valid commercial subscription this product (Atomikos ExtremeTransactions) is licensed for DEVELOPMENT ONLY - production use is not allowed!";
    private static final String RENEW_MESSAGE = "PLEASE RENEW YOUR SUBSCRIPTION AS EXPLAINED BELOW...";
    private static final String DOCUMENTATION_MESSAGE = "See https://www.atomikos.com/Documentation/ConfiguringYourSubscription for instructions on how to obtain and configure valid subscription files for your installation...";

    private SubscriptionVerifier() {
    }

    public static void verifyWithWarnings() {
        try {
            SubscriptionVerifier.verify();
        }
        catch (ExpiredSubscriptionException expired) {
            if (expired.hasRecentlyExpired()) {
                SubscriptionVerifier.logWarnings("YOUR SUBSCRIPTION HAS RECENTLY EXPIRED: " + expired.getSubscriptionFileURL(), "CONTINUED PRODUCTION USE REQUIRES A CURRENT SUBSCRIPTION", RENEW_MESSAGE, DOCUMENTATION_MESSAGE);
            } else {
                SubscriptionVerifier.logFatals("YOUR SUBSCRIPTION EXPIRED MORE THAN 90 DAYS AGO: " + expired.getSubscriptionFileURL(), "PRODUCTION USE IS NOW ILLEGAL AND SOFTWARE ACCESS AND SUPPORT MAY GET CUT OFF SOON!", RENEW_MESSAGE, DOCUMENTATION_MESSAGE);
            }
        }
        catch (CorruptSubscriptionException corrupt) {
            SubscriptionVerifier.logWarnings("Your subscription file has been tampered with, or no matching signature file has been found: " + corrupt.getSubscriptionFileURL(), DEV_ONLY_MESSAGE, DOCUMENTATION_MESSAGE);
        }
        catch (NoSubscriptionFoundException notFound) {
            SubscriptionVerifier.logWarnings("No subscription files found.", DEV_ONLY_MESSAGE, DOCUMENTATION_MESSAGE);
        }
        catch (Exception e) {
            LOGGER.logWarning("Unexpected exception while verifying your subscription files", (Throwable)e);
            SubscriptionVerifier.logWarnings("Unexpected exception while verifying your subscription files - see the logs for details...", DEV_ONLY_MESSAGE, DOCUMENTATION_MESSAGE);
        }
    }

    private static void logFatals(String ... messages) {
        for (String message : messages) {
            SubscriptionVerifier.logFatal(message);
        }
    }

    private static void logFatal(String message) {
        LOGGER.logWarning(message);
        System.out.println(message);
        System.err.println(message);
    }

    private static void logWarning(String message) {
        if (LOGGER.isWarnEnabled()) {
            LOGGER.logWarning(message);
        } else {
            System.out.println(message);
            System.err.println(message);
        }
    }

    private static void logWarnings(String ... messages) {
        for (String message : messages) {
            SubscriptionVerifier.logWarning(message);
        }
    }

    public static void verify() throws SubscriptionException {
        try {
            SignedSubscription subscription = new SignedSubscription(SubscriptionVerifier.getUrl(DEFAULT_PROPERTY_FILE_NAME), SubscriptionVerifier.getUrl(DEFAULT_SIGNATURE_FILE_NAME));
            subscription.verify();
        }
        catch (MalformedURLException e) {
            throw new SubscriptionException(e);
        }
    }

    private static URL getUrl(String relativeFileName) throws MalformedURLException {
        URL url = null;
        if (System.getProperty(SUBSCRIPTION_FOLDER) != null) {
            StringWriter path = new StringWriter();
            path.append(System.getProperty(SUBSCRIPTION_FOLDER));
            path.append(File.separatorChar);
            path.append(relativeFileName);
            File file = new File(path.toString());
            url = file.toURI().toURL();
        } else {
            url = SubscriptionVerifier.class.getResource("/" + relativeFileName);
        }
        return url;
    }
}

