/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.subscription;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.subscription.CorruptSubscriptionException;
import com.atomikos.subscription.ExpiredSubscriptionException;
import com.atomikos.subscription.IOHelper;
import com.atomikos.subscription.NoSubscriptionFoundException;
import com.atomikos.subscription.SubscriptionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

class SignedSubscription {
    private static Logger LOGGER = LoggerFactory.createLogger(SignedSubscription.class);
    static long NINETY_DAYS_IN_MILLIS = 7776000000L;
    public static final String ALGORITHM = "MD5withRSA";
    public static final BigInteger PUB_KEY_MODULUS = new BigInteger("140658304810032005358034973148790185636270088330156859601776911261673898675396294290778280576306894283085855379220106242370995399756138006536565537004270538844939222454790084049748039467458753521167712302802205560260964387415838221710815725878406788812352586781064246394662399196263536966153511962431816738957");
    public static final BigInteger PUB_KEY_EXPONENT = new BigInteger("65537");
    public static final String EXPIRY_PROPERTY_NAME = "expires";
    public static final String LICENSEE_PROPERTY_NAME = "licensee";
    private URL fileURL;
    private URL sigFileURL;
    private Date now;

    SignedSubscription(URL fileURL, URL sigFileURL) {
        this.fileURL = fileURL;
        this.sigFileURL = sigFileURL;
        this.now = new Date(System.currentTimeMillis());
    }

    void setNow(Date date) {
        this.now = date;
    }

    public void verify() throws SubscriptionException {
        LOGGER.logDebug("Verifying subscription file: " + this.fileURL + " against signature file: " + this.sigFileURL);
        Signature signature = this.loadSubscriptionBytes();
        this.assertSignatureIsValid(signature);
        this.assertNotExpired();
        LOGGER.logInfo("Subscription valid!");
    }

    private void assertNotExpired() throws ExpiredSubscriptionException {
        try {
            SimpleDateFormat formatter;
            Date expiryDate;
            Properties details = this.loadSubscriptionProperties();
            String expiryDateAsString = details.getProperty(EXPIRY_PROPERTY_NAME);
            if (expiryDateAsString != null && this.now.after(expiryDate = (formatter = new SimpleDateFormat("dd/MM/yyyy")).parse(expiryDateAsString))) {
                throw new ExpiredSubscriptionException(this.fileURL, this.hasRecentlyExpired(expiryDate));
            }
        }
        catch (SubscriptionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SubscriptionException(e);
        }
    }

    private boolean hasRecentlyExpired(Date expiryDate) {
        return expiryDate.getTime() + NINETY_DAYS_IN_MILLIS > this.now.getTime();
    }

    private void assertSignatureIsValid(Signature signature) throws CorruptSubscriptionException {
        boolean valid = false;
        try {
            byte[] signatureBytes = this.loadBytesFromURL(this.sigFileURL);
            valid = signature.verify(signatureBytes);
        }
        catch (SignatureException e) {
            LOGGER.logDebug("Error verifying signature", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            LOGGER.logWarning("Your subscription's signature file is missing!", (Throwable)e);
            throw new CorruptSubscriptionException(this.fileURL);
        }
        catch (IOException e) {
            throw new SubscriptionException(e);
        }
        if (!valid) {
            throw new CorruptSubscriptionException(this.fileURL);
        }
    }

    private Signature loadSubscriptionBytes() throws NoSubscriptionFoundException {
        Signature signature = this.createSignature();
        this.addPublicKeyToSignature(signature);
        this.addDataBytesToSignature(signature);
        return signature;
    }

    private Properties loadSubscriptionProperties() throws IOException {
        if (this.fileURL == null) {
            throw new FileNotFoundException("Subscription file not found");
        }
        Properties ret = new Properties();
        InputStream in = this.fileURL.openStream();
        ret.load(in);
        in.close();
        return ret;
    }

    private void addPublicKeyToSignature(Signature signature) {
        try {
            PublicKey pk = this.loadPublicKey();
            signature.initVerify(pk);
        }
        catch (Exception e) {
            throw new SubscriptionException(e);
        }
    }

    private PublicKey loadPublicKey() throws NoSuchAlgorithmException, FileNotFoundException, InvalidKeySpecException {
        RSAPublicKeySpec rsaSpec = new RSAPublicKeySpec(PUB_KEY_MODULUS, PUB_KEY_EXPONENT);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(rsaSpec);
    }

    private void addDataBytesToSignature(Signature signature) {
        byte[] data;
        try {
            data = this.loadBytesFromURL(this.fileURL);
        }
        catch (IOException e) {
            throw new NoSubscriptionFoundException();
        }
        try {
            signature.update(data);
        }
        catch (SignatureException e) {
            throw new SubscriptionException(e);
        }
    }

    private byte[] loadBytesFromURL(URL url) throws IOException {
        byte[] ret = null;
        if (url == null) {
            throw new NoSubscriptionFoundException();
        }
        ret = IOHelper.readBytesFromUrl(url);
        return ret;
    }

    private Signature createSignature() {
        try {
            return Signature.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SubscriptionException(e);
        }
    }
}

