/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.tree;

import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.OpRequestUICancellableRunnable;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractOperation;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.changemanagement.CMListenerManager;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.tree.CheckoutsTreeModel;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.SimpleBrowseObjectTreeNode;
import com.sas.workspace.visuals.tree.AbstractCategoryTree;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;

public class CheckoutsTree
extends AbstractCategoryTree {
    private static final WAdminResource bundle = WAdminResource.getBundle(CheckoutsTree.class);
    public static final String CHECKOUTS_TREE_CONTEXT = "CheckoutsTree";

    public CheckoutsTree(UserContextInterface userContext) {
        this(new CheckoutsTreeModel(userContext));
    }

    public CheckoutsTree(ITreeModel model) {
        super(model);
        this.setName(bundle.getString("CheckoutsTree.Name.txt"));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.setIconDecorationsSupported(true);
        this.addTreeWillExpandListener(this.createWillExpandListener());
        this.expandRoot();
        this.setLeadSelectionPath(this.getPathForRow(0));
    }

    @Override
    protected WsActionContextInterface createActionContext() {
        return new WsActionContext(CHECKOUTS_TREE_CONTEXT, this);
    }

    protected TreeWillExpandListener createWillExpandListener() {
        return new cRootCollapseVetoListener();
    }

    @Override
    protected void updateActions() {
        super.updateActions();
        this.m_expandAction.setEnabled(false);
        this.m_collapseAction.setEnabled(false);
        this.m_expandAllAction.setEnabled(false);
    }

    @Override
    protected OpRequestUICancellableRunnable createDeleteOperation(IDataTreeNode[] aNodes, OpRequestUI opUI) {
        return new DeleteOperation(aNodes, opUI);
    }

    @Override
    protected void onDelete() {
        String sNames;
        this.cancelEditing();
        IDataTreeNode[] aNodes = this.getSelectedDataNodes();
        if (this.isAnyObjectInUse(aNodes, "Common.ObjectInUseNoDelete.Text.fmt")) {
            return;
        }
        if (!this.isFolderEmpty(aNodes)) {
            return;
        }
        if (aNodes.length == 1) {
            sNames = aNodes[0].getName();
        } else if (aNodes.length == 2) {
            sNames = bundle.formatString("Common.TwoNames.fmt", aNodes[0].getName(), aNodes[1].getName());
        } else {
            int iNode;
            sNames = "";
            int nNodes = Math.min(aNodes.length, 20);
            for (iNode = 0; iNode < nNodes - 1; ++iNode) {
                sNames = bundle.formatString("Common.ConcatenateNames.fmt", sNames, aNodes[iNode].getName());
            }
            sNames = nNodes < aNodes.length ? bundle.formatString("Common.AndOthers.fmt", sNames) : bundle.formatString("Common.LastName.fmt", sNames, aNodes[iNode].getName());
        }
        int eAnswer = MessageUtil.displayMessage(bundle.formatString("Common.ConfirmDeleteInProject.Text.txt", sNames), bundle.getString("Common.ConfirmDelete.Title.txt"), 1, 0);
        if (eAnswer == 0) {
            OpRequestUI request = new OpRequestUI(Workspace.getWorkspace(), bundle.getString("AbstractBaseTree.DeleteProgressIndicator.MessagePrototype.txt"), bundle.getString("AbstractBaseTree.DeleteProgressIndicator.Title.txt"));
            request.setDelayBeforeProgressCancelDialog(200);
            request.executeWithCancel(this.createDeleteOperation(aNodes, request));
            Workspace.getDefaultLogger().debug("Finished waiting on delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFolderEmpty(IDataTreeNode[] aNodes) {
        int nNodes = aNodes.length;
        ChildServerInterface transaction = null;
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            transaction = server.newChild(true);
            for (int iNode = 0; iNode < nNodes; ++iNode) {
                IDataTreeNode node;
                if (aNodes[iNode] == null || !(node = aNodes[iNode]).isFolder()) continue;
                String sMetadataType = transaction.getTypeDescriptor(node.getType()).getMetadataType();
                String key = node.getID() + "/" + sMetadataType;
                MetadataInterface mi = transaction.fetch(key, true);
                List lChildren = ((FolderInterface)mi).getChildren();
                if (lChildren.isEmpty()) continue;
                String message = bundle.formatString("CheckoutsTree.FolderNotEmpty.Message.fmt", node.getName());
                MessageUtil.displayMessage(message, 2);
                boolean bl = false;
                return bl;
            }
        }
        catch (ServiceException se) {
            MessageUtil.displayServiceExceptionMessage(se);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException(ex);
        }
        finally {
            if (transaction != null) {
                try {
                    transaction.destroy();
                }
                catch (ServiceException e) {
                    MessageUtil.displayServiceExceptionMessage(e);
                }
                catch (RemoteException e) {
                    Workspace.handleRemoteException(e);
                }
            }
        }
        return true;
    }

    @Override
    protected void onDefault() {
        Object selectedObject = this.getSelectedObjects()[0];
        if (selectedObject != null || selectedObject instanceof SimpleBrowseObject) {
            WsAbstractApplicationActionsManager.getInstance().performDefaultActionFor(this, selectedObject, this.m_context);
        }
    }

    private class cRootCollapseVetoListener
    implements TreeWillExpandListener {
        private cRootCollapseVetoListener() {
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            if (CheckoutsTree.this.getSelectedNode() == CheckoutsTree.this.getModel().getRoot()) {
                throw new ExpandVetoException(event);
            }
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        }
    }

    private class DeleteOperation
    extends WsAbstractOperation {
        private OpRequestUI m_opUI;
        private IDataTreeNode[] m_aDeleteNodes;

        public DeleteOperation(IDataTreeNode[] aNodes, OpRequestUI opUI) {
            super(opUI);
            this.m_aDeleteNodes = aNodes;
            this.m_opUI = opUI;
        }

        @Override
        public void run() {
            CheckoutsTree.this.cancelEditing();
            Integer nNodes = new Integer(this.m_aDeleteNodes.length);
            String sChangeState = "";
            String sType = "";
            CMListenerManager cmManager = CMListenerManager.getInstance();
            for (int iNode = 0; iNode < this.m_aDeleteNodes.length && !this.isOperationCancelled(); ++iNode) {
                SimpleBrowseObject oObject = ((SimpleBrowseObjectTreeNode)this.m_aDeleteNodes[iNode]).getSimpleBrowseObject();
                sChangeState = oObject.getChangeState();
                sType = oObject.getMetadataType();
                this.m_opUI.setMessage(bundle.formatString("AbstractBaseTree.DeleteProgressIndicator.Message.fmt.txt", new Integer(iNode + 1), nNodes));
                boolean bDeleteSuccessful = this.m_aDeleteNodes[iNode].delete();
                if (!bDeleteSuccessful || sChangeState == null || !sChangeState.toUpperCase().startsWith("CHECKOUT")) continue;
                String strCSId = sChangeState.substring(sChangeState.indexOf(":") + 2);
                if (cmManager != null) {
                    cmManager.checkInDeletedObject(strCSId, sType);
                }
                sChangeState = "";
                sType = "";
            }
        }
    }

    protected class cDeleteAction
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.ContextualAction {
        public cDeleteAction() {
            this.setMenuSupportId("Common:Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CheckoutsTree.this.onDelete();
        }

        @Override
        public boolean isValidForContext(WsActionContextInterface context) {
            Object[] aSelectedObjects = context.getSelectedObjects();
            if (aSelectedObjects.length == 0) {
                return false;
            }
            for (int i = 0; i < aSelectedObjects.length; ++i) {
                if (aSelectedObjects[i] instanceof SimpleObject) continue;
                return false;
            }
            return true;
        }
    }
}

