/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.tree;

import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.tree.AbstractBaseTree;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class BaseTreeUI
extends BasicTreeUI {
    public static ComponentUI createUI(JComponent cmp) {
        return new BaseTreeUI();
    }

    private AbstractBaseTree getTree() {
        return (AbstractBaseTree)this.tree;
    }

    @Override
    protected MouseListener createMouseListener() {
        return new cMouseListener();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new cFocusListener();
    }

    protected class cMouseListener
    extends BasicTreeUI.MouseHandler {
        protected cMouseListener() {
            super(BaseTreeUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BaseTreeUI.this.getTree().isEnabled()) {
                return;
            }
            if (e.getButton() == 3) {
                BaseTreeUI.this.getTree().requestFocusInWindow();
            }
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
                return;
            }
            int x = e.getX();
            int y = e.getY();
            TreePath path = BaseTreeUI.this.getTree().getPathForLocation(x, y);
            if (path == null && !BaseTreeUI.this.isLocationInExpandControl(path = BaseTreeUI.this.getClosestPathForLocation(BaseTreeUI.this.getTree(), x, y), x, y)) {
                BaseTreeUI.this.getTree().requestFocusInWindow();
                BaseTreeUI.this.getTree().clearSelection();
                return;
            }
            if (BaseTreeUI.this.getTree().getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                BaseTreeUI.this.getTree().requestFocusInWindow();
            } else {
                super.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!BaseTreeUI.this.getTree().isEnabled()) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.triggerPopup(e);
                return;
            }
            if (BaseTreeUI.this.getTree().getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                MouseEvent ePressed = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), false, e.getButton());
                super.mousePressed(ePressed);
            }
            if (e.getClickCount() == 2) {
                TreePath path = BaseTreeUI.this.getTree().getPathForLocation(e.getX(), e.getY());
                if (BaseTreeUI.this.getTree().isPathSelected(path) && BaseTreeUI.this.getTree().getSelectedObjects().length == 1 && !((ITreeNode)path.getLastPathComponent()).getAllowsChildren()) {
                    Action userAction = BaseTreeUI.this.getTree().getUserDefaultAction();
                    if (userAction != null && userAction.isEnabled()) {
                        userAction.actionPerformed(new ActionEvent(BaseTreeUI.this.tree, 1, "default"));
                    } else {
                        BaseTreeUI.this.getTree().onDefault();
                    }
                }
            }
            super.mouseReleased(e);
        }

        protected boolean isPointOnSelectedPath(Point pt) {
            TreePath path = BaseTreeUI.this.getTree().getPathForLocation(pt.x, pt.y);
            return path != null && BaseTreeUI.this.getTree().isPathSelected(path);
        }

        protected void triggerPopup(MouseEvent e) {
            BaseTreeUI.this.getTree().requestFocusInWindow();
            if (!e.isShiftDown() && !e.isControlDown()) {
                TreePath path = BaseTreeUI.this.getTree().getPathForLocation(e.getX(), e.getY());
                if (!BaseTreeUI.this.getTree().isPathSelected(path)) {
                    BaseTreeUI.this.getTree().setSelectionPath(path);
                }
            }
            BaseTreeUI.this.getTree().onPopup(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected class cFocusListener
    implements FocusListener {
        protected cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            TreeCellRenderer renderer = BaseTreeUI.this.tree.getCellRenderer();
            if (renderer instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)renderer).setBackgroundSelectionColor(BaseTreeUI.this.getTree().getSelectionBackground());
                ((DefaultTreeCellRenderer)renderer).setTextSelectionColor(BaseTreeUI.this.getTree().getSelectionForeground());
            }
            BaseTreeUI.this.getTree().repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            TreeCellRenderer renderer = BaseTreeUI.this.tree.getCellRenderer();
            if (renderer instanceof DefaultTreeCellRenderer) {
                ((DefaultTreeCellRenderer)renderer).setBackgroundSelectionColor(BaseTreeUI.this.getTree().getNonFocusSelectionBackground());
                ((DefaultTreeCellRenderer)renderer).setTextSelectionColor(BaseTreeUI.this.getTree().getNonFocusSelectionForeground());
            }
            BaseTreeUI.this.getTree().repaint();
        }
    }
}

