/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDIconNode;
import com.sas.graphics.components.pfd.PFDText;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;

public class WsPFDIconNode
extends PFDIconNode
implements WsPFDPrimitive {
    private static final long serialVersionUID = 1L;
    public static final int RECTANGLE = 2;
    public static final int ROUND_RECTANGLE = 3;
    public static final int ELLIPSE = 5;
    public static final int DIAMOND = 6;
    public static final int HEXAGON = 7;
    public static final int OCTAGON = 10;
    protected static final Point DEFAULT_LOCATION = new Point(0, 0);
    protected static final Dimension DEFAULT_SIZE = new Dimension(36, 36);
    protected static final int DEFAULT_BORDER_WIDTH = 3;
    private boolean m_bActive;
    private boolean m_bEditable;
    private Action m_actDefault;
    private Action m_actDelete;

    public WsPFDIconNode() {
        this(DEFAULT_LOCATION, DEFAULT_SIZE, null, null);
    }

    public WsPFDIconNode(Point ptLocation, Dimension dimSize, Icon icon, String sLabel) {
        this(ptLocation, dimSize, 2, icon, sLabel);
    }

    public WsPFDIconNode(Point ptLocation, Dimension dimSize, int eShape, Icon icon, String sLabel) {
        super(ptLocation, dimSize, eShape, (ImageIcon)icon, sLabel);
    }

    protected void initialize() {
        super.initialize();
        PFDText label = this.getLabel();
        if (label != null) {
            label.setMultiline(true);
            label.setClipHeight(Integer.MAX_VALUE);
        }
        this.getPort("east").setSelectable(false);
        this.getPort("west").setSelectable(false);
        this.getPort("north").setSelectable(false);
        this.getPort("south").setSelectable(false);
        this.m_bEditable = true;
    }

    @Override
    public void addPopupMenuItems(JPopupMenu menuPopup) {
    }

    @Override
    public void setActive(boolean bActive) {
        this.m_bActive = bActive;
    }

    @Override
    public boolean isActive() {
        return this.m_bActive;
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        if (this.m_actDelete != null) {
            this.m_actDelete.setEnabled(bEditable);
        }
    }

    @Override
    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setDefaultAction(Action actDefault) {
        this.m_actDefault = actDefault;
    }

    @Override
    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    @Override
    public void setDeleteAction(Action actDelete) {
        this.m_actDelete = actDelete;
        if (actDelete != null) {
            actDelete.setEnabled(this.m_bEditable);
        }
    }

    @Override
    public Action getDeleteAction() {
        return this.m_actDelete;
    }

    @Override
    public boolean isDropValid(Point ptEvent, List lObjects) {
        return false;
    }

    @Override
    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }
}

