/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.graphics.components.pfd.PFDAbstractNode;
import com.sas.graphics.components.pfd.PFDLink;
import com.sas.graphics.components.pfd.PFDPrimitive;
import com.sas.graphics.components.pfd.PFDSelectionList;
import com.sas.graphics.components.pfd.PFDView;
import com.sas.workspace.visuals.pfd.WsPFDSelectionEvent;
import com.sas.workspace.visuals.pfd.WsPFDSelectionListener;
import com.sas.workspace.visuals.pfd.WsPFDSelectionModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;

public class WsPFDDefaultSelectionModel
implements WsPFDSelectionModel {
    private int m_eMode;
    private int m_fTypes;
    private PFDView m_view;
    private List m_lListeners;
    private boolean m_bIgnoreEvents;
    private ItemListener m_lsnr;

    public WsPFDDefaultSelectionModel(PFDView view) {
        this.m_view = view;
        this.m_lsnr = this.createItemListener();
        this.m_view.addItemListener(this.m_lsnr);
        this.m_eMode = 0;
        this.m_fTypes = 3;
        this.m_lListeners = new ArrayList();
    }

    @Override
    public void dispose() {
        this.m_view.removeItemListener(this.m_lsnr);
        this.m_view = null;
    }

    @Override
    public void addPrimitive(PFDPrimitive prim) {
        this.addPrimitives(new PFDPrimitive[]{prim});
    }

    @Override
    public void removePrimitive(PFDPrimitive prim) {
        this.removePrimitives(new PFDPrimitive[]{prim});
    }

    @Override
    public void addPrimitives(PFDPrimitive[] aPrimitives) {
        if (this.m_eMode == 0) {
            if (aPrimitives.length > 1) {
                throw new UnsupportedOperationException("Can not add more than one primitive in SINGLE_SELECT mode");
            }
            this.removeAllPrimitives();
        }
        try {
            this.m_bIgnoreEvents = true;
            this.m_view.setHoldDisplay(true);
            for (int iPrimitive = 0; iPrimitive < aPrimitives.length; ++iPrimitive) {
                this.m_view.selectPrimitive(aPrimitives[iPrimitive]);
            }
            this.fireSelectionChanged(1, aPrimitives);
        }
        finally {
            this.m_bIgnoreEvents = false;
            this.m_view.setHoldDisplay(false);
        }
    }

    @Override
    public void removePrimitives(PFDPrimitive[] aPrimitives) {
        try {
            this.m_bIgnoreEvents = true;
            this.m_view.setHoldDisplay(true);
            for (int iPrimitive = 0; iPrimitive < aPrimitives.length; ++iPrimitive) {
                this.m_view.deselectPrimitive(aPrimitives[iPrimitive]);
            }
            this.fireSelectionChanged(2, aPrimitives);
        }
        finally {
            this.m_bIgnoreEvents = false;
            this.m_view.setHoldDisplay(false);
        }
    }

    @Override
    public void removeAllPrimitives() {
        this.removePrimitives(this.getPrimitives());
    }

    @Override
    public int getSelectionCount() {
        return this.m_view.getSelectionList().getNumPrimitives();
    }

    @Override
    public PFDPrimitive[] getPrimitives() {
        return this.m_view.getSelectedPrimitives();
    }

    @Override
    public boolean isPrimitiveSelected(PFDPrimitive prim) {
        return this.m_view.isSelected(prim);
    }

    @Override
    public void setPrimaryPrimitive(PFDPrimitive prim) {
        try {
            this.m_view.setHoldDisplay(true);
            if (this.isPrimitiveSelected(prim)) {
                this.removePrimitive(prim);
            }
            this.addPrimitive(prim);
        }
        finally {
            this.m_view.setHoldDisplay(false);
        }
    }

    @Override
    public PFDPrimitive getPrimaryPrimitive() {
        return this.m_view.getSelectionList().getLastPrimitive();
    }

    @Override
    public void setSelectionMode(int eMode) {
        PFDPrimitive[] aSelected;
        if (eMode != 0 && eMode != 1) {
            throw new IllegalArgumentException("Selection mode must be SINGLE_SELECT or MULTIPLE_SELECT");
        }
        if (eMode == this.m_eMode) {
            return;
        }
        this.m_eMode = eMode;
        if (this.m_eMode == 0 && (aSelected = this.m_view.getSelectedPrimitives()).length > 1) {
            PFDPrimitive[] aDeselect = new PFDPrimitive[aSelected.length - 1];
            System.arraycopy(aSelected, 0, aDeselect, 0, aSelected.length - 1);
            this.removePrimitives(aDeselect);
        }
    }

    @Override
    public int getSelectionMode() {
        return this.m_eMode;
    }

    @Override
    public void setSelectablePrimitives(int fPrimitives) {
        if (this.m_fTypes == fPrimitives) {
            return;
        }
        this.m_fTypes = fPrimitives;
        if (this.m_fTypes != 3) {
            PFDPrimitive[] aSelected = this.m_view.getSelectedPrimitives();
            for (int iSelected = 0; iSelected < aSelected.length; ++iSelected) {
                if (((this.m_fTypes & 1) != 0 || !(aSelected[iSelected] instanceof PFDAbstractNode)) && ((this.m_fTypes & 2) != 0 || !(aSelected[iSelected] instanceof PFDLink))) continue;
                this.removePrimitive(aSelected[iSelected]);
            }
        }
    }

    @Override
    public int getSelectablePrimitives() {
        return this.m_fTypes;
    }

    @Override
    public void addSelectionListener(WsPFDSelectionListener lsnr) {
        this.m_lListeners.add(lsnr);
    }

    @Override
    public void removeSelectionListener(WsPFDSelectionListener lsnr) {
        this.m_lListeners.remove(lsnr);
    }

    protected void fireSelectionChanged(int eAction, PFDPrimitive[] aPrimitives) {
        WsPFDSelectionEvent ev = new WsPFDSelectionEvent(this, eAction, aPrimitives);
        for (int iListener = this.m_lListeners.size() - 1; iListener >= 0; --iListener) {
            WsPFDSelectionListener lsnr = (WsPFDSelectionListener)this.m_lListeners.get(iListener);
            lsnr.selectionChanged(ev);
        }
    }

    protected ItemListener createItemListener() {
        return new PFDItemListener();
    }

    protected class PFDItemListener
    implements ItemListener {
        protected PFDItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent ev) {
            if (!WsPFDDefaultSelectionModel.this.m_bIgnoreEvents) {
                PFDPrimitive prim = (PFDPrimitive)ev.getItem();
                if ((WsPFDDefaultSelectionModel.this.m_fTypes & 1) == 0 && prim instanceof PFDAbstractNode || (WsPFDDefaultSelectionModel.this.m_fTypes & 2) == 0 && prim instanceof PFDLink) {
                    WsPFDDefaultSelectionModel.this.removePrimitive(prim);
                    return;
                }
                if (WsPFDDefaultSelectionModel.this.m_eMode == 0 && ev.getStateChange() == 1) {
                    PFDSelectionList list = WsPFDDefaultSelectionModel.this.m_view.getSelectionList();
                    while (list.getNumPrimitives() > 1) {
                        WsPFDDefaultSelectionModel.this.removePrimitive(list.getPrimitive(0));
                    }
                }
                PFDPrimitive[] aPrimitives = new PFDPrimitive[]{prim};
                WsPFDDefaultSelectionModel.this.fireSelectionChanged(ev.getStateChange(), aPrimitives);
            }
        }
    }
}

