/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.pfd;

import com.sas.workspace.DNDObject;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.pfd.PFDComponentNode;
import com.sas.workspace.visuals.pfd.WsPFDPrimitive;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;

public class WsPFDComponentNode
extends PFDComponentNode
implements WsPFDPrimitive {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(PFDComponentNode.class);
    private boolean m_bActive;
    private boolean m_bEditable;
    private Action m_actDefault;
    private Action m_actDelete;
    private boolean m_bDropOnComponentEnabled;
    private DropTargetListener m_lsnrDropTarget;
    private DropTarget m_dropTarget;

    public WsPFDComponentNode() {
        this.getComponentPanel().setLayout(new BorderLayout());
        this.setForcedSize(100, 100);
        this.setTitleText(bundle.getString("WsPFDComponentNode.DefaultTitle.txt"));
        this.setTitleAreaColor(SystemColor.controlShadow);
        this.setContentAreaColor(SystemColor.control);
        this.getInputPort().setSelectable(false);
        this.componentSpacer = 1;
        this.m_bEditable = true;
    }

    public WsPFDComponentNode(JComponent cmp) {
        this();
        this.setComponent(cmp);
    }

    public void setComponent(JComponent cmp) {
        if (this.m_bDropOnComponentEnabled) {
            this.uninstallDropTargetOnComponent();
        }
        this.getComponentPanel().add(cmp);
        if (this.m_bDropOnComponentEnabled) {
            this.installDropTargetOnComponent();
        }
    }

    public JComponent getComponent() {
        JPanel pnl = this.getComponentPanel();
        return pnl.getComponentCount() > 0 ? (JComponent)pnl.getComponent(0) : null;
    }

    public void setDropOnComponentEnabled(boolean bEnabled) {
        if (this.m_bDropOnComponentEnabled == bEnabled) {
            return;
        }
        this.m_bDropOnComponentEnabled = bEnabled;
        if (bEnabled) {
            this.installDropTargetOnComponent();
        } else {
            this.uninstallDropTargetOnComponent();
        }
    }

    public boolean isDropOnComponentEnabled() {
        return this.m_bDropOnComponentEnabled;
    }

    private void installDropTargetOnComponent() {
        JScrollPane scr;
        JComponent cmp = this.getComponent();
        if (cmp == null) {
            return;
        }
        if (cmp instanceof JScrollPane && (cmp = (JComponent)(scr = (JScrollPane)cmp).getViewport().getView()) == null) {
            return;
        }
        this.m_lsnrDropTarget = new DropTargetHandler(this);
        this.m_dropTarget = new DropTarget(cmp, this.m_lsnrDropTarget);
    }

    private void uninstallDropTargetOnComponent() {
        if (this.m_dropTarget == null) {
            return;
        }
        this.m_dropTarget.removeDropTargetListener(this.m_lsnrDropTarget);
        this.m_dropTarget.setComponent(null);
        this.m_dropTarget = null;
        this.m_lsnrDropTarget = null;
    }

    @Override
    public void addPopupMenuItems(JPopupMenu menuPopup) {
    }

    @Override
    public void setActive(boolean bActive) {
        this.m_bActive = bActive;
    }

    @Override
    public boolean isActive() {
        return this.m_bActive;
    }

    @Override
    public void setEditable(boolean bEditable) {
        if (this.m_bEditable == bEditable) {
            return;
        }
        this.m_bEditable = bEditable;
        if (this.m_actDelete != null) {
            this.m_actDelete.setEnabled(bEditable);
        }
    }

    @Override
    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setDefaultAction(Action actDefault) {
        this.m_actDefault = actDefault;
    }

    @Override
    public Action getDefaultAction() {
        return this.m_actDefault;
    }

    @Override
    public void setDeleteAction(Action actDelete) {
        this.m_actDelete = actDelete;
        if (actDelete != null) {
            actDelete.setEnabled(this.m_bEditable);
        }
    }

    @Override
    public Action getDeleteAction() {
        return this.m_actDelete;
    }

    @Override
    public boolean isDropValid(Point ptEvent, List lObjects) {
        return false;
    }

    @Override
    public boolean drop(Point ptEvent, List lObjects) {
        return false;
    }

    protected void removeAssociation() {
        this.uninstallDropTargetOnComponent();
        super.removeAssociation();
    }

    private static class DropTargetHandler
    implements DropTargetListener {
        private WsPFDComponentNode m_node;

        public DropTargetHandler(WsPFDComponentNode node) {
            this.m_node = node;
        }

        @Override
        public void dragEnter(DropTargetDragEvent ev) {
            List lDraggedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors());
            if (this.m_node.isDropValid(ev.getLocation(), lDraggedObjects)) {
                ev.acceptDrag(ev.getDropAction());
            } else {
                ev.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent ev) {
            WsUIUtilities.autoscrollForDragEvent(ev);
            List lDraggedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors());
            if (this.m_node.isDropValid(ev.getLocation(), lDraggedObjects)) {
                ev.acceptDrag(ev.getDropAction());
            } else {
                ev.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent ev) {
            List lDroppedObjects;
            Point ptDrop = ev.getLocation();
            if (this.m_node.isDropValid(ptDrop, lDroppedObjects = this.getDraggedObjects(ev.getCurrentDataFlavors()))) {
                if (this.m_node.drop(ptDrop, lDroppedObjects)) {
                    ev.acceptDrop(ev.getDropAction());
                } else {
                    ev.rejectDrop();
                }
            } else {
                ev.rejectDrop();
            }
        }

        protected List getDraggedObjects(DataFlavor[] flavors) {
            for (int iFlavor = 0; iFlavor < flavors.length; ++iFlavor) {
                if (!(flavors[iFlavor] instanceof DNDObject.DNDObjectFlavor)) continue;
                DNDObject object = ((DNDObject.DNDObjectFlavor)flavors[iFlavor]).getData();
                return object.getObjects();
            }
            return null;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }
}

