/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.objectselector;

import com.sas.workspace.models.IPublicTypeFilter;
import com.sas.workspace.models.ISimpleObjectFilter;
import com.sas.workspace.models.SimpleObject;

public class ObjectSelectorFilterFactory {
    public static IPublicTypeFilter createTypeFilter(String[] aPublicTypes) {
        return new cPublicTypeFilter(aPublicTypes);
    }

    public static ISimpleObjectFilter createObjectFilter(String[] aPublicTypes) {
        cPublicTypeFilter typeFilter = new cPublicTypeFilter(aPublicTypes);
        return new cSimpleObjectFilter(typeFilter);
    }

    private ObjectSelectorFilterFactory() {
    }

    private static class cPublicTypeFilter
    implements IPublicTypeFilter {
        String[] m_aPublicTypes;

        public cPublicTypeFilter(String[] aPublicTypes) {
            this.m_aPublicTypes = aPublicTypes;
        }

        @Override
        public boolean accept(String sPublicType) {
            for (int i = 0; i < this.m_aPublicTypes.length; ++i) {
                if (!this.m_aPublicTypes[i].equals(sPublicType)) continue;
                return true;
            }
            return false;
        }
    }

    private static class cSimpleObjectFilter
    implements ISimpleObjectFilter {
        IPublicTypeFilter m_typeFilter;

        public cSimpleObjectFilter(IPublicTypeFilter typeFilter) {
            this.m_typeFilter = typeFilter;
        }

        @Override
        public boolean accept(SimpleObject simpleObject) {
            return this.m_typeFilter.accept(simpleObject.getPublicType());
        }
    }
}

