/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.visuals.expression.AbstractFunctionsModel;
import com.sas.workspace.visuals.expression.BaseFunction;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;

public class PropertiesFunctionsModel
extends AbstractFunctionsModel {
    public static final String SQL_LANGUAGE_PREFIX = "SQL.";
    public static final String MDX_LANGUAGE_PREFIX = "MDX.";
    private static final String CATEGORY_PREFIX = "Function.Category.";
    private static final String FUNCTION_PREFIX = "Function.Format.";

    public void load(WAdminResource resources, String sLanguage) {
        HashMap<String, Category> mapCategories = new HashMap<String, Category>();
        ArrayList<BaseFunction> lFunctions = new ArrayList<BaseFunction>();
        Enumeration keysEnum = resources.getKeys();
        while (keysEnum.hasMoreElements()) {
            String key = (String)keysEnum.nextElement();
            String sSubKey = this.getSubKey(key, sLanguage + CATEGORY_PREFIX, ".DisplayName.txt");
            if (sSubKey != null) {
                if (sSubKey.equals("ALL")) continue;
                mapCategories.put(sSubKey, this.acquireCategory(sSubKey, resources.getString(key)));
                continue;
            }
            sSubKey = this.getSubKey(key, sLanguage + FUNCTION_PREFIX, ".DisplayName.txt");
            if (sSubKey == null) continue;
            lFunctions.add(new BaseFunction(resources, sLanguage + FUNCTION_PREFIX + sSubKey));
        }
        int nNotFound = 0;
        for (int iFunction = 0; iFunction < lFunctions.size(); ++iFunction) {
            Function function = (Function)lFunctions.get(iFunction);
            Category category = (Category)mapCategories.get(function.getCategoryName());
            if (category == null) {
                Workspace.getDefaultLogger().info(++nNotFound + "Category not found for " + function.getCategoryName() + ":" + function.getDisplayName());
                continue;
            }
            category.addFunction(function);
            function.setCategory(category);
        }
    }

    private String getSubKey(String key, String prefix, String suffix) {
        if (key.startsWith(prefix) && key.endsWith(suffix)) {
            return key.substring(prefix.length(), key.length() - suffix.length());
        }
        return null;
    }
}

