/*
 * Decompiled with CFR 0.152.
 */
package com.sas.workspace.visuals.expression;

import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.visuals.expression.FunctionsModel;
import com.sas.workspace.visuals.expression.FunctionsTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.Icon;

public class ExpressionPanel
extends ExpressionBuilderPanel {
    private static final String DIVIDER_LOCATION_KEY = ".DividerLocation";
    private static final String SELECTED_TAB_KEY = ".SelectedTab";
    private static final String FUNCTIONS_TAB_KEY = ".FunctionsTab";
    private FunctionsTab m_tabFunctions;

    public ExpressionPanel() {
        this(3);
    }

    public ExpressionPanel(FunctionsModel mdlFunctions) {
        this(mdlFunctions, 3);
    }

    public ExpressionPanel(int fTabsShown) {
        this(null, fTabsShown);
    }

    public ExpressionPanel(FunctionsModel mdlFunctions, int fTabsShown) {
        super(fTabsShown & 0xFFFFFFFE);
        this.setValidationButtonVisible(true);
        this.setSingleButtonInsertMode(true);
        if ((fTabsShown & 1) == 1) {
            this.m_tabFunctions = this.createDefaultFunctionsTab(mdlFunctions);
            this.addCustomTab(this.m_tabFunctions, this._functionsTabLabel, this._functionsTabToolTip);
        }
        this.fixInsertIcon(null);
        this.fixExpressionLabel();
        this.fixDefaultSplitLocation();
    }

    protected void fixInsertIcon(Icon icon) {
        this.JButton_Insert_BeforeTabs.setIcon(icon);
    }

    protected void fixExpressionLabel() {
        this.JPanel_LabelAndExpression.add((Component)this.JLabel_Expression, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 2, new Insets(0, 4, 4, 0), 0, 0));
    }

    private void fixDefaultSplitLocation() {
        int height;
        Dimension dimTop = this.JPanel_ExpressionAndOkCancel.getPreferredSize();
        Dimension dimBottom = this.JPanel_Helpers.getPreferredSize();
        dimTop.height = height = (dimTop.height + dimBottom.height) / 2;
        dimBottom.height = height;
        this.JPanel_ExpressionAndOkCancel.setPreferredSize(dimTop);
        this.JPanel_Helpers.setPreferredSize(dimBottom);
    }

    public int getInsertPosition() {
        return this._expressionTextPane.getSelectionStart();
    }

    public void selectExpressionText(int iStart, int iEnd) {
        this._expressionTextPane.select(iStart, iEnd);
    }

    public void restoreSettings(String settingsKeyPrefix, WorkspaceFile appDefaults) {
        this.JSplitPane_ExpressionAndTools.setDividerLocation(appDefaults.getPropertyInt(settingsKeyPrefix + DIVIDER_LOCATION_KEY, -1));
        int index = appDefaults.getPropertyInt(settingsKeyPrefix + SELECTED_TAB_KEY, 0);
        if (index < this.JTabbedPane_Chooser.getTabCount()) {
            this.JTabbedPane_Chooser.setSelectedIndex(index);
        }
        this.m_tabFunctions.restoreSettings(settingsKeyPrefix + FUNCTIONS_TAB_KEY, appDefaults);
    }

    public void saveSettings(String settingsKeyPrefix, WorkspaceFile appDefaults) {
        appDefaults.setPropertyInt(settingsKeyPrefix + DIVIDER_LOCATION_KEY, this.JSplitPane_ExpressionAndTools.getDividerLocation());
        appDefaults.setPropertyInt(settingsKeyPrefix + SELECTED_TAB_KEY, this.JTabbedPane_Chooser.getSelectedIndex());
        this.m_tabFunctions.saveSettings(settingsKeyPrefix + FUNCTIONS_TAB_KEY, appDefaults);
    }

    protected FunctionsTab createDefaultFunctionsTab(FunctionsModel mdlFunctions) {
        return new FunctionsTab(mdlFunctions);
    }

    public FunctionsTab getFunctionsTab() {
        return this.m_tabFunctions;
    }
}

